/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.utilityHandlers;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ContentHandler.class);
    private final String rootPath;

    public ContentHandler(String rootPath) {
        this.rootPath = rootPath;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (!request.getMethod().equals("GET")) {
                request.setHandled(false);
                return;
            }
            if (target.equals("/ui/")) {
                if (this.getContent(response, this.rootPath + "/index.html")) {
                    logger.info("Handled {} request {} with root path {}", new Object[]{request.getMethod(), target, this.rootPath});
                    response.setStatus(200);
                    request.setHandled(true);
                }
            } else if (target.startsWith("/ui/")) {
                if (this.getContent(response, this.rootPath + target.substring(3))) {
                    logger.debug("Handled {} request {} root path {}", new Object[]{request.getMethod(), target, this.rootPath});
                    response.setStatus(200);
                    request.setHandled(true);
                }
            } else if (target.equals("/favicon.ico")) {
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }

    private boolean getContent(HttpServletResponse response, String resource) throws IOException {
        byte[] buffer = new byte[51200];
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);){
            if (is == null) {
                boolean bl = false;
                return bl;
            }
            if (resource.toLowerCase().endsWith(".html")) {
                response.addHeader("X-Frame-Options", "DENY");
                response.setContentType("text/html; charset=utf-8");
            }
            int len = is.read(buffer);
            while (len != -1) {
                response.getOutputStream().write(buffer, 0, len);
                len = is.read(buffer);
            }
        }
        return true;
    }
}

