/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service.helper;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class InfoHelper {
    private final OkHttpClient client;

    public InfoHelper(OkHttpClient client) {
        this.client = client;
    }

    public int readAvailability(String host, String url) throws IOException {
        try {
            Request request = new Request.Builder().url("http://" + url.replace("{host}", host)).build();
            Response response = this.client.newCall(request).execute();
            return response.code();
        }
        catch (ConnectException | SocketTimeoutException | UnknownHostException ex) {
            return -1;
        }
    }

    public String readVersion(String host, String url) throws IOException {
        try {
            Request request = new Request.Builder().url("http://" + url.replace("{host}", host)).build();
            Response response = this.client.newCall(request).execute();
            if (response.isSuccessful()) {
                return response.body().string();
            }
            return "Error: " + response.code();
        }
        catch (UnknownHostException ex) {
            return "Unknown Host";
        }
        catch (ConnectException | SocketTimeoutException ex) {
            return "Time Out";
        }
    }
}

