/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.access.AccessException;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.service.dao.PostVipData;
import com.northernwall.hadrian.service.dao.PutVipData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VipHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(VipHandler.class);
    private final AccessHelper accessHelper;
    private final DataAccess dataAccess;
    private final WorkItemProcessor workItemProcess;

    public VipHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        this.accessHelper = accessHelper;
        this.dataAccess = dataAccess;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.startsWith("/v1/vip/")) {
                switch (request.getMethod()) {
                    case "POST": {
                        if (target.matches("/v1/vip/vip")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.createVip(request);
                            break;
                        }
                        throw new RuntimeException("Unknown vip operation");
                    }
                    case "PUT": {
                        if (target.matches("/v1/vip/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String vipId = target.substring(8, target.length());
                            this.updateVip(request, vipId);
                            break;
                        }
                        throw new RuntimeException("Unknown vip operation");
                    }
                    case "DELETE": {
                        if (target.matches("/v1/vip/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String serviceId = target.substring(8, 44);
                            String vipId = target.substring(45);
                            this.deleteVip(request, serviceId, vipId);
                            break;
                        }
                        throw new RuntimeException("Unknown vip operation");
                    }
                    default: {
                        throw new RuntimeException("Unknown vip operation");
                    }
                }
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (AccessException e) {
            logger.error("Exception {} while handling request for {}", (Object)e.getMessage(), (Object)target);
            response.setStatus(401);
            request.setHandled(true);
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
            request.setHandled(true);
        }
    }

    private void createVip(Request request) throws IOException {
        PostVipData postVipData = Util.fromJson(request, PostVipData.class);
        Service service = this.dataAccess.getService(postVipData.serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a vip");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        List<Vip> vips = this.dataAccess.getVips(postVipData.serviceId);
        for (Vip temp : vips) {
            if (temp.getVipName().equals(postVipData.vipName)) {
                return;
            }
            if (!temp.getDns().equals(postVipData.dns) || !temp.getDomain().equals(postVipData.domain) || temp.getVipPort() != postVipData.vipPort) continue;
            return;
        }
        List<Module> modules = this.dataAccess.getModules(postVipData.serviceId);
        Module module = null;
        for (Module temp : modules) {
            if (!temp.getModuleId().equals(postVipData.moduleId)) continue;
            module = temp;
        }
        if (module == null) {
            throw new RuntimeException("Unknown module");
        }
        Vip vip = new Vip(postVipData.vipName, postVipData.serviceId, "Creating...", postVipData.moduleId, postVipData.dns, postVipData.domain, postVipData.external, postVipData.network, postVipData.protocol, postVipData.vipPort, postVipData.servicePort);
        this.dataAccess.saveVip(vip);
        WorkItem workItem = new WorkItem("vip", "create", user, team, service, module, null, vip, null);
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }

    private void updateVip(Request request, String vipId) throws IOException {
        PutVipData putVipData = Util.fromJson(request, PutVipData.class);
        Vip vip = this.dataAccess.getVip(putVipData.serviceId, vipId);
        if (vip == null) {
            throw new RuntimeException("Could not find vip");
        }
        Service service = this.dataAccess.getService(vip.getServiceId());
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "modify a vip");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        vip.setStatus("Updating...");
        this.dataAccess.saveVip(vip);
        WorkItem workItem = new WorkItem("vip", "update", user, team, service, null, null, vip, vip);
        workItem.getNewVip().external = putVipData.external;
        workItem.getNewVip().servicePort = putVipData.servicePort;
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }

    private void deleteVip(Request request, String serviceId, String vipId) throws IOException {
        Service service = this.dataAccess.getService(serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "delete a vip");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        Vip vip = this.dataAccess.getVip(serviceId, vipId);
        if (vip == null) {
            logger.info("Could not find vip with id {}", (Object)vipId);
            return;
        }
        vip.setStatus("Deleting...");
        this.dataAccess.updateVip(vip);
        WorkItem workItem = new WorkItem("vip", "delete", user, team, service, null, null, vip, null);
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }
}

