/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.access.AccessException;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.service.dao.PostModuleData;
import com.northernwall.hadrian.service.dao.PutModuleData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ModuleHandler.class);
    private final AccessHelper accessHelper;
    private final Config config;
    private final DataAccess dataAccess;
    private final WorkItemProcessor workItemProcess;
    private final Gson gson;

    public ModuleHandler(AccessHelper accessHelper, Config config, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        this.accessHelper = accessHelper;
        this.config = config;
        this.dataAccess = dataAccess;
        this.workItemProcess = workItemProcess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.startsWith("/v1/module")) {
                switch (request.getMethod()) {
                    case "POST": {
                        if (target.equalsIgnoreCase("/v1/module")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.createModule(request);
                            break;
                        }
                        throw new RuntimeException("Unknown module operation");
                    }
                    case "PUT": {
                        if (target.matches("/v1/module/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String serviceId = target.substring(11, 47);
                            String moduleId = target.substring(48);
                            this.updateModule(request, serviceId, moduleId);
                            break;
                        }
                        throw new RuntimeException("Unknown module operation");
                    }
                    case "DELETE": {
                        if (target.matches("/v1/module/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String serviceId = target.substring(11, 47);
                            String moduleId = target.substring(48);
                            this.deleteModule(request, serviceId, moduleId);
                            break;
                        }
                        throw new RuntimeException("Unknown module operation");
                    }
                    default: {
                        throw new RuntimeException("Unknown host operation");
                    }
                }
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (AccessException e) {
            logger.error("Exception {} while handling request for {}", (Object)e.getMessage(), (Object)target);
            response.setStatus(401);
            request.setHandled(true);
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
            request.setHandled(true);
        }
    }

    private void createModule(Request request) throws IOException {
        PostModuleData postModuleData = Util.fromJson(request, PostModuleData.class);
        Service service = this.dataAccess.getService(postModuleData.serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a module");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        if (!this.config.moduleTypes.contains(postModuleData.moduleType)) {
            throw new RuntimeException("Unknown module type");
        }
        if (!this.config.templates.contains(postModuleData.template)) {
            throw new RuntimeException("Unknown template");
        }
        if (!this.config.artifactTypes.contains(postModuleData.artifactType)) {
            throw new RuntimeException("Unknown artifact");
        }
        if (service.getServiceType().equals("Shared Library")) {
            postModuleData.moduleType = "Library";
        }
        if (!postModuleData.moduleType.equals("Deployable")) {
            postModuleData.hostAbbr = "";
            postModuleData.versionUrl = "";
            postModuleData.availabilityUrl = "";
            postModuleData.runAs = "";
            postModuleData.deploymentFolder = "";
            postModuleData.startCmdLine = "";
            postModuleData.startTimeOut = 0;
            postModuleData.stopCmdLine = "";
            postModuleData.stopTimeOut = 0;
        } else if (postModuleData.hostAbbr.contains("-")) {
            throw new RuntimeException("Can not have '-' in host abbr");
        }
        if (service.getGitMode().equals("Consolidated")) {
            postModuleData.gitPath = service.getGitPath();
        } else {
            postModuleData.gitFolder = "";
        }
        List<Module> modules = this.dataAccess.getModules(postModuleData.serviceId);
        LinkedList<Module> zeroModules = new LinkedList<Module>();
        for (Module temp : modules) {
            if (postModuleData.moduleName.equalsIgnoreCase(temp.getModuleName())) {
                logger.warn("Error there already exists a module named {} on service {}", (Object)postModuleData.moduleName, (Object)postModuleData.serviceId);
                return;
            }
            if (postModuleData.gitPath.equalsIgnoreCase(temp.getGitPath()) && postModuleData.gitFolder.equalsIgnoreCase(temp.getGitFolder())) {
                logger.warn("Error there already exists a module with git path {} and folder {} on service {}", new Object[]{postModuleData.gitPath, postModuleData.gitFolder, postModuleData.serviceId});
                return;
            }
            if (temp.getOrder() != 0) continue;
            zeroModules.add(temp);
        }
        modules.removeAll(zeroModules);
        Collections.sort(modules);
        if (postModuleData.order < 0) {
            postModuleData.order = 0;
        }
        if (postModuleData.order > 0) {
            if (postModuleData.order > modules.size() + 1) {
                postModuleData.order = modules.size() + 1;
            }
            for (Module temp : modules) {
                if (temp.getOrder() < postModuleData.order) continue;
                temp.setOrder(temp.getOrder() + 1);
                this.dataAccess.updateModule(temp);
            }
        }
        Module module = new Module(postModuleData.moduleName, postModuleData.serviceId, postModuleData.order, postModuleData.moduleType, postModuleData.gitPath, postModuleData.gitFolder, postModuleData.mavenGroupId, postModuleData.mavenArtifactId, postModuleData.artifactType, postModuleData.artifactSuffix, postModuleData.hostAbbr.toLowerCase(), postModuleData.versionUrl, postModuleData.availabilityUrl, postModuleData.runAs, postModuleData.deploymentFolder, postModuleData.startCmdLine, postModuleData.startTimeOut, postModuleData.stopCmdLine, postModuleData.stopTimeOut);
        this.dataAccess.saveModule(module);
        if (module.getOrder() > 0) {
            modules.add(module.getOrder() - 1, module);
        } else {
            zeroModules.add(module);
        }
        WorkItem workItem = new WorkItem("module", "create", user, team, service, module, null, null, null);
        workItem.getMainModule().template = postModuleData.template;
        for (Module temp : zeroModules) {
            workItem.addModule(temp);
        }
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }

    private void updateModule(Request request, String serviceId, String moduleId) throws IOException {
        Service service = this.dataAccess.getService(serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "update module");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        PutModuleData putModuleData = Util.fromJson(request, PutModuleData.class);
        List<Module> modules = this.dataAccess.getModules(serviceId);
        LinkedList<Module> zeroModules = new LinkedList<Module>();
        Module module = null;
        for (Module temp : modules) {
            if (temp.getModuleId().equals(moduleId)) {
                module = temp;
            }
            if (temp.getOrder() != 0) continue;
            zeroModules.add(temp);
        }
        if (module == null) {
            logger.warn("Could not find module with id {} in service {}", (Object)moduleId, (Object)serviceId);
            return;
        }
        modules.removeAll(zeroModules);
        Collections.sort(modules);
        if (putModuleData.order < 0) {
            putModuleData.order = 0;
        }
        if (putModuleData.order > modules.size()) {
            putModuleData.order = modules.size();
        }
        module.setModuleName(putModuleData.moduleName);
        module.setMavenGroupId(putModuleData.mavenGroupId);
        module.setMavenArtifactId(putModuleData.mavenArtifactId);
        module.setArtifactType(putModuleData.artifactType);
        module.setArtifactSuffix(putModuleData.artifactSuffix);
        module.setHostAbbr(putModuleData.hostAbbr.toLowerCase());
        module.setVersionUrl(putModuleData.versionUrl);
        module.setAvailabilityUrl(putModuleData.availabilityUrl);
        module.setRunAs(putModuleData.runAs);
        module.setDeploymentFolder(putModuleData.deploymentFolder);
        module.setStartCmdLine(putModuleData.startCmdLine);
        module.setStartTimeOut(putModuleData.startTimeOut);
        module.setStopCmdLine(putModuleData.stopCmdLine);
        module.setStopTimeOut(putModuleData.stopTimeOut);
        if (module.getOrder() != putModuleData.order) {
            if (module.getOrder() > 0) {
                modules.remove(module);
            } else {
                zeroModules.remove(module);
            }
            module.setOrder(putModuleData.order);
            if (putModuleData.order > 0) {
                modules.add(putModuleData.order - 1, module);
            } else {
                zeroModules.add(module);
            }
            int i = 1;
            for (Module temp : modules) {
                if (temp.getOrder() != i) {
                    temp.setOrder(i);
                    this.dataAccess.saveModule(temp);
                }
                ++i;
            }
        }
        this.dataAccess.saveModule(module);
        WorkItem workItem = new WorkItem("module", "update", user, team, service, module, null, null, null);
        for (Module temp : zeroModules) {
            workItem.addModule(temp);
        }
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }

    private void deleteModule(Request request, String serviceId, String moduleId) throws IOException {
        Module module = this.dataAccess.getModule(serviceId, moduleId);
        if (module == null) {
            logger.warn("Could not find module with id {}", (Object)moduleId);
            return;
        }
        Service service = this.dataAccess.getService(serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "deleting a module");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        for (Host host : this.dataAccess.getHosts(serviceId)) {
            if (!host.getModuleId().equals(moduleId)) continue;
            throw new RuntimeException("Can not delete module with an active host");
        }
        for (Vip vip : this.dataAccess.getVips(serviceId)) {
            if (!vip.getModuleId().equals(moduleId)) continue;
            throw new RuntimeException("Can not delete module with an active vip");
        }
        List<Module> modules = this.dataAccess.getModules(serviceId);
        Collections.sort(modules);
        modules.remove(module.getOrder() - 1);
        int i = 1;
        for (Module temp : modules) {
            if (temp.getOrder() != i) {
                temp.setOrder(i);
                this.dataAccess.saveModule(temp);
            }
            ++i;
        }
        this.dataAccess.deleteModule(serviceId, moduleId);
        WorkItem workItem = new WorkItem("module", "delete", user, team, service, module, null, null, null);
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }
}

