/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.access.AccessException;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.service.dao.GetHostDetailsData;
import com.northernwall.hadrian.service.dao.PostHostData;
import com.northernwall.hadrian.service.dao.PostHostVipData;
import com.northernwall.hadrian.service.dao.PutDeploySoftwareData;
import com.northernwall.hadrian.service.dao.PutRestartHostData;
import com.northernwall.hadrian.service.helper.HostDetailsHelper;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(HostHandler.class);
    private final AccessHelper accessHelper;
    private final Config config;
    private final DataAccess dataAccess;
    private final WorkItemProcessor workItemProcess;
    private final HostDetailsHelper hostDetailsHelper;
    private final Gson gson;

    public HostHandler(AccessHelper accessHelper, Config config, DataAccess dataAccess, WorkItemProcessor workItemProcess, HostDetailsHelper hostDetailsHelper) {
        this.accessHelper = accessHelper;
        this.config = config;
        this.dataAccess = dataAccess;
        this.workItemProcess = workItemProcess;
        this.hostDetailsHelper = hostDetailsHelper;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.startsWith("/v1/host/")) {
                switch (request.getMethod()) {
                    case "GET": {
                        if (target.matches("/v1/host/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+-\\w+-\\w+-\\w+-\\w+/details")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String serviceId = target.substring(9, 45);
                            String hostId = target.substring(46, 82);
                            this.getHostDetails(response, serviceId, hostId);
                            break;
                        }
                        throw new RuntimeException("Unknown host operation");
                    }
                    case "POST": {
                        if (target.matches("/v1/host/host")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.createHosts(request);
                            break;
                        }
                        if (target.matches("/v1/host/vips")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.addVIPs(request);
                            break;
                        }
                        if (target.matches("/v1/host/backfill")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.backfillHosts(request);
                            break;
                        }
                        throw new RuntimeException("Unknown host operation");
                    }
                    case "PUT": {
                        if (target.matches("/v1/host/host")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.deploySoftware(request);
                            break;
                        }
                        if (target.matches("/v1/host/restart")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.restartHost(request);
                            break;
                        }
                        throw new RuntimeException("Unknown host operation");
                    }
                    case "DELETE": {
                        if (target.matches("/v1/host/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String serviceId = target.substring(9, 45);
                            String hostId = target.substring(46);
                            this.deleteHost(request, serviceId, hostId);
                            break;
                        }
                        if (target.matches("/v1/host/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String serviceId = target.substring(9, 45);
                            String hostId = target.substring(46, 82);
                            String vipId = target.substring(83);
                            this.deleteVIP(request, serviceId, hostId, vipId);
                            break;
                        }
                        throw new RuntimeException("Unknown host operation");
                    }
                    default: {
                        throw new RuntimeException("Unknown host operation");
                    }
                }
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (AccessException e) {
            logger.error("Exception {} while handling request for {}", (Object)e.getMessage(), (Object)target);
            response.setStatus(401);
            request.setHandled(true);
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
            request.setHandled(true);
        }
    }

    private void getHostDetails(HttpServletResponse response, String serviceId, String hostId) throws IOException {
        Host host = this.dataAccess.getHost(serviceId, hostId);
        if (host == null) {
            throw new RuntimeException("Could not find host");
        }
        GetHostDetailsData details = this.hostDetailsHelper.getDetails(host);
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)details, GetHostDetailsData.class, jw);
        }
    }

    private void createHosts(Request request) throws IOException {
        PostHostData postHostData = Util.fromJson(request, PostHostData.class);
        Service service = this.dataAccess.getService(postHostData.serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a host");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        if (postHostData.count < 1) {
            throw new RuntimeException("count must to at least 1");
        }
        if (postHostData.count > 10) {
            logger.warn("Reducing count to 10, was {}", (Object)postHostData.count);
            postHostData.count = 10;
        }
        if (!this.config.dataCenters.contains(postHostData.dataCenter)) {
            throw new RuntimeException("Unknown data center");
        }
        if (!this.config.networks.contains(postHostData.network)) {
            throw new RuntimeException("Unknown network");
        }
        if (!this.config.envs.contains(postHostData.env)) {
            throw new RuntimeException("Unknown env");
        }
        if (!this.config.sizes.contains(postHostData.size)) {
            throw new RuntimeException("Unknown size");
        }
        List<Module> modules = this.dataAccess.getModules(postHostData.serviceId);
        Module module = null;
        for (Module temp : modules) {
            if (!temp.getModuleId().equals(postHostData.moduleId)) continue;
            module = temp;
        }
        if (module == null) {
            throw new RuntimeException("Unknown module");
        }
        String prefix = postHostData.dataCenter + "-" + postHostData.network + "-" + module.getHostAbbr() + "-";
        int len = prefix.length();
        int num = 0;
        List<Host> hosts = this.dataAccess.getHosts(postHostData.serviceId);
        for (Host existingHost : hosts) {
            String existingHostName = existingHost.getHostName();
            if (!existingHostName.startsWith(prefix) || existingHostName.length() <= len) continue;
            String numPart = existingHostName.substring(len);
            try {
                int temp = Integer.parseInt(numPart);
                if (temp <= num) continue;
                num = temp;
            }
            catch (Exception e) {
                logger.warn("Error parsing int from last part of {}", (Object)existingHostName);
            }
        }
        ++num;
        for (int c = 0; c < postHostData.count; ++c) {
            String numStr = Integer.toString(num + c);
            numStr = "000".substring(numStr.length()) + numStr;
            Host host = new Host(prefix + numStr, postHostData.serviceId, "Creating...", postHostData.moduleId, postHostData.dataCenter, postHostData.network, postHostData.env, postHostData.size);
            this.dataAccess.saveHost(host);
            WorkItem workItemCreate = new WorkItem("host", "create", user, team, service, module, host, null, null);
            WorkItem workItemDeploy = new WorkItem("host", "deploy", user, team, service, module, host, null, null);
            workItemCreate.getHost().version = postHostData.version;
            workItemCreate.getHost().reason = postHostData.reason;
            workItemCreate.setNextId(workItemDeploy.getId());
            workItemDeploy.getHost().version = postHostData.version;
            workItemDeploy.getHost().reason = postHostData.reason;
            this.dataAccess.saveWorkItem(workItemCreate);
            this.dataAccess.saveWorkItem(workItemDeploy);
            this.workItemProcess.sendWorkItem(workItemCreate);
        }
    }

    private void deploySoftware(Request request) throws IOException {
        WorkItem workItem;
        PutDeploySoftwareData putHostData = Util.fromJson(request, PutDeploySoftwareData.class);
        Service service = null;
        Module module = null;
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(putHostData.hosts.size());
        User user = null;
        Team team = null;
        for (Map.Entry<String, String> entry : putHostData.hosts.entrySet()) {
            Host host;
            if (!entry.getValue().equalsIgnoreCase("true") || (host = this.dataAccess.getHost(putHostData.serviceId, entry.getKey())) == null || !host.getServiceId().equals(putHostData.serviceId) || !host.getStatus().equals("-") || !host.getNetwork().equals(putHostData.network) || !host.getModuleId().equals(putHostData.moduleId)) continue;
            if (service == null) {
                service = this.dataAccess.getService(host.getServiceId());
                if (service == null) {
                    throw new RuntimeException("Could not find service");
                }
                user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "deploy software to host");
                team = this.dataAccess.getTeam(service.getTeamId());
            }
            if (module == null || !module.getModuleId().equals(host.getModuleId())) {
                module = this.dataAccess.getModule(host.getServiceId(), host.getModuleId());
            }
            workItem = new WorkItem("host", "deploy", user, team, service, module, host, null, null);
            workItem.getHost().version = putHostData.version;
            workItem.getHost().reason = putHostData.reason;
            if (workItems.isEmpty()) {
                host.setStatus("Deploying...");
            } else {
                host.setStatus("Deploy Queued");
            }
            this.dataAccess.updateHost(host);
            workItems.add(workItem);
        }
        String prevId = null;
        int size = workItems.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                workItem = (WorkItem)workItems.get(size - i - 1);
                workItem.setNextId(prevId);
                prevId = workItem.getId();
                this.dataAccess.saveWorkItem(workItem);
            }
            this.workItemProcess.sendWorkItem((WorkItem)workItems.get(0));
        }
    }

    private void restartHost(Request request) throws IOException {
        WorkItem workItem;
        PutRestartHostData putRestartHostData = Util.fromJson(request, PutRestartHostData.class);
        Service service = null;
        Module module = null;
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(putRestartHostData.hosts.size());
        User user = null;
        Team team = null;
        for (Map.Entry<String, String> entry : putRestartHostData.hosts.entrySet()) {
            Host host;
            if (!entry.getValue().equalsIgnoreCase("true") || (host = this.dataAccess.getHost(putRestartHostData.serviceId, entry.getKey())) == null || !host.getServiceId().equals(putRestartHostData.serviceId) || !host.getStatus().equals("-") || !host.getNetwork().equals(putRestartHostData.network) || !host.getModuleId().equals(putRestartHostData.moduleId)) continue;
            if (service == null) {
                service = this.dataAccess.getService(host.getServiceId());
                if (service == null) {
                    throw new RuntimeException("Could not find service");
                }
                user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "restart host");
                team = this.dataAccess.getTeam(service.getTeamId());
            }
            if (module == null || !module.getModuleId().equals(host.getModuleId())) {
                module = this.dataAccess.getModule(host.getServiceId(), host.getModuleId());
            }
            workItem = new WorkItem("host", "restart", user, team, service, module, host, null, null);
            if (workItems.isEmpty()) {
                host.setStatus("Restarting...");
            } else {
                host.setStatus("Restart Queued");
            }
            this.dataAccess.updateHost(host);
            workItems.add(workItem);
        }
        String prevId = null;
        int size = workItems.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                workItem = (WorkItem)workItems.get(size - i - 1);
                workItem.setNextId(prevId);
                prevId = workItem.getId();
                this.dataAccess.saveWorkItem(workItem);
            }
            this.workItemProcess.sendWorkItem((WorkItem)workItems.get(0));
        }
    }

    private void deleteHost(Request request, String serviceId, String hostId) throws IOException {
        Host host = this.dataAccess.getHost(serviceId, hostId);
        if (host == null) {
            logger.info("Could not find host with id {}", (Object)hostId);
            return;
        }
        Service service = this.dataAccess.getService(host.getServiceId());
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "deleting a host");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        host.setStatus("Deleting...");
        this.dataAccess.updateHost(host);
        WorkItem workItem = new WorkItem("host", "delete", user, team, service, null, host, null, null);
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }

    private void backfillHosts(Request request) throws IOException {
        User user = this.accessHelper.checkIfUserIsOps(request, "Backfill");
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String s = reader.readLine();
        while (s != null && !s.isEmpty()) {
            String[] parts = s.split(",");
            if (parts.length == 7) {
                this.backfillHost(parts[0].trim(), parts[1].trim(), parts[2].trim(), parts[3].trim(), parts[4].trim(), parts[5].trim(), parts[6].trim(), user);
            }
            s = reader.readLine();
        }
    }

    private void backfillHost(String serviceAbbr, String moduleName, String hostName, String dataCenter, String network, String env, String size, User user) {
        if (this.config.dataCenters.contains(dataCenter) && this.config.networks.contains(network) && this.config.envs.contains(env) && this.config.sizes.contains(size)) {
            for (Service service : this.dataAccess.getServices()) {
                if (!service.getServiceAbbr().equalsIgnoreCase(serviceAbbr)) continue;
                List<Host> hosts = this.dataAccess.getHosts(service.getServiceId());
                for (Host host : hosts) {
                    if (!host.getHostName().equalsIgnoreCase(hostName)) continue;
                    logger.warn("There already exists host '{}' on service '{}'", (Object)hostName, (Object)serviceAbbr);
                    return;
                }
                Module module = null;
                List<Module> modules = this.dataAccess.getModules(service.getServiceId());
                for (Module temp : modules) {
                    if (!temp.getModuleName().equalsIgnoreCase(moduleName)) continue;
                    module = temp;
                }
                if (module == null) {
                    logger.warn("Could not find module with name {} in service {}", (Object)moduleName, (Object)serviceAbbr);
                    return;
                }
                Host host = new Host(hostName, service.getServiceId(), "-", module.getModuleId(), dataCenter, network, env, size);
                this.dataAccess.saveHost(host);
                Audit audit = new Audit();
                audit.serviceId = service.getServiceId();
                audit.timePerformed = new Date();
                audit.timeRequested = new Date();
                audit.requestor = user.getUsername();
                audit.type = "host";
                audit.operation = "create";
                audit.moduleName = module.getModuleName();
                audit.hostName = hostName;
                HashMap<String, String> notes = new HashMap<String, String>();
                notes.put("reason", "Backfill via OPS tool.");
                audit.notes = this.gson.toJson(notes);
                this.dataAccess.saveAudit(audit, "");
                return;
            }
            logger.warn("Could not find a service with the abbr '{}'", (Object)serviceAbbr);
        }
    }

    private void addVIPs(Request request) throws IOException {
        PostHostVipData data = Util.fromJson(request, PostHostVipData.class);
        Service service = this.dataAccess.getService(data.serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a host vip");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        List<Host> hosts = this.dataAccess.getHosts(data.serviceId);
        List<Vip> vips = this.dataAccess.getVips(data.serviceId);
        Module module = null;
        for (Map.Entry<String, String> entry : data.hosts.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase("true")) continue;
            boolean found = false;
            for (Host host : hosts) {
                if (!entry.getKey().equals(host.getHostId())) continue;
                found = true;
                for (Map.Entry<String, String> entry2 : data.vips.entrySet()) {
                    if (!entry2.getValue().equalsIgnoreCase("true")) continue;
                    boolean found2 = false;
                    for (Vip vip : vips) {
                        if (!entry2.getKey().equals(vip.getVipId())) continue;
                        found2 = true;
                        if (host.getNetwork().equals(vip.getNetwork())) {
                            if (module == null || host.getModuleId().equals(module.getModuleId())) {
                                for (Module temp : this.dataAccess.getModules(host.getServiceId())) {
                                    if (!temp.getModuleId().equals(host.getModuleId())) continue;
                                    module = temp;
                                }
                            }
                            this.dataAccess.saveVipRef(new VipRef(host.getHostId(), vip.getVipId(), "Adding..."));
                            WorkItem workItem = new WorkItem("hostvip", "add", user, team, service, module, host, vip, null);
                            this.dataAccess.saveWorkItem(workItem);
                            this.workItemProcess.sendWorkItem(workItem);
                            continue;
                        }
                        logger.warn("Request to add {} to {} reject because they are not on the same network", (Object)host.getHostName(), (Object)vip.getVipName());
                    }
                    if (found2) continue;
                    logger.error("Asked to add host(s) to vip {}, but vip is not on service {}", (Object)entry2.getKey(), (Object)data.serviceId);
                }
            }
            if (found) continue;
            logger.error("Asked to add vip(s) to host {}, but host is not on service {}", (Object)entry.getKey(), (Object)data.serviceId);
        }
    }

    private void deleteVIP(Request request, String serviceId, String hostId, String vipId) throws IOException {
        Service service = this.dataAccess.getService(serviceId);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "delete host vip");
        Team team = this.dataAccess.getTeam(service.getTeamId());
        VipRef vipRef = this.dataAccess.getVipRef(hostId, vipId);
        if (vipRef == null) {
            return;
        }
        Host host = this.dataAccess.getHost(serviceId, hostId);
        if (host == null) {
            throw new RuntimeException("Could not find host");
        }
        Vip vip = this.dataAccess.getVip(serviceId, vipId);
        if (vip == null) {
            throw new RuntimeException("Could not find vip");
        }
        vipRef.setStatus("Removing...");
        this.dataAccess.updateVipRef(vipRef);
        WorkItem workItem = new WorkItem("hostvip", "delete", user, team, service, null, host, vip, null);
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }
}

