/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessException;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(DataStoreHandler.class);
    private final AccessHelper accessHelper;
    private final DataAccess dataAccess;
    private final Gson gson;

    public DataStoreHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        this.accessHelper = accessHelper;
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.matches("/v1/datastore/")) {
                logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (AccessException e) {
            logger.error("Exception {} while handling request for {}", (Object)e.getMessage(), (Object)target);
            response.setStatus(401);
            request.setHandled(true);
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
            request.setHandled(true);
        }
    }
}

