/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.graph;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.graph.Graph;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(GraphHandler.class);
    private final DataAccess dataAccess;
    private final Gson gson;

    public GraphHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (request.getMethod().equals("GET") && target.startsWith("/v1/graph/")) {
                if (target.equals("/v1/graph/all")) {
                    logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                    this.produceAllGraph(response);
                    request.setHandled(true);
                    response.setStatus(200);
                } else if (target.matches("/v1/graph/fanout/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                    logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                    String id = target.substring(17);
                    this.produceFanOutGraph(response, id);
                    request.setHandled(true);
                    response.setStatus(200);
                } else if (target.matches("/v1/graph/fanin/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                    logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                    String id = target.substring(16);
                    this.produceFanInGraph(response, id);
                    request.setHandled(true);
                    response.setStatus(200);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }

    private void produceAllGraph(HttpServletResponse response) throws IOException {
        Graph graph = new Graph(response, true);
        List<Team> teams = this.dataAccess.getTeams();
        if (teams != null && !teams.isEmpty()) {
            List<Service> services;
            int c = 0;
            for (Team team : teams) {
                graph.startSubGraph(c);
                services = this.dataAccess.getServices(team.getTeamId());
                if (services != null && !services.isEmpty()) {
                    for (Service service : services) {
                        graph.writeService(service, "ellipse");
                    }
                }
                graph.finishSubGraph(team.getTeamName());
                ++c;
            }
            for (Team team : teams) {
                services = this.dataAccess.getServices(team.getTeamId());
                if (services == null || services.isEmpty()) continue;
                for (Service service : services) {
                    List<ServiceRef> serviceRefs = this.dataAccess.getServiceRefsByClient(service.getServiceId());
                    if (serviceRefs == null || serviceRefs.isEmpty()) continue;
                    for (ServiceRef serviceRef : serviceRefs) {
                        Service temp = this.dataAccess.getService(serviceRef.getServerServiceId());
                        graph.writeLink(service.getServiceAbbr(), temp.getServiceAbbr());
                    }
                }
                graph.newLine();
            }
        }
        graph.close();
    }

    private void produceFanInGraph(HttpServletResponse response, String serviceId) throws IOException {
        Graph graph = new Graph(response, false);
        LinkedList<Service> services = new LinkedList<Service>();
        LinkedList<String> foundIds = new LinkedList<String>();
        Service service = this.dataAccess.getService(serviceId);
        services.add(service);
        foundIds.add(service.getServiceId());
        while (!services.isEmpty()) {
            this.fanIn((Service)services.remove(0), graph, services, foundIds);
        }
        graph.newLine();
        graph.writeService(service, "square");
        graph.close();
    }

    private void fanIn(Service service, Graph graph, List<Service> services, List<String> foundIds) throws IOException {
        List<ServiceRef> serviceRefs = this.dataAccess.getServiceRefsByServer(service.getServiceId());
        if (serviceRefs != null && !serviceRefs.isEmpty()) {
            for (ServiceRef serviceRef : serviceRefs) {
                if (foundIds.contains(serviceRef.getClientServiceId())) continue;
                Service temp = this.dataAccess.getService(serviceRef.getClientServiceId());
                graph.writeLink(temp.getServiceAbbr(), service.getServiceAbbr());
                graph.writeService(temp, "ellipse");
                services.add(temp);
                foundIds.add(temp.getServiceId());
            }
        }
    }

    private void produceFanOutGraph(HttpServletResponse response, String serviceId) throws IOException {
        Graph graph = new Graph(response, false);
        LinkedList<Service> services = new LinkedList<Service>();
        LinkedList<String> foundIds = new LinkedList<String>();
        Service service = this.dataAccess.getService(serviceId);
        services.add(service);
        foundIds.add(service.getServiceId());
        while (!services.isEmpty()) {
            this.fanOut((Service)services.remove(0), graph, services, foundIds);
        }
        graph.newLine();
        graph.writeService(service, "square");
        graph.close();
    }

    private void fanOut(Service service, Graph graph, List<Service> services, List<String> foundIds) throws IOException {
        List<ServiceRef> serviceRefs = this.dataAccess.getServiceRefsByClient(service.getServiceId());
        if (serviceRefs != null && !serviceRefs.isEmpty()) {
            for (ServiceRef serviceRef : serviceRefs) {
                if (foundIds.contains(serviceRef.getServerServiceId())) continue;
                Service temp = this.dataAccess.getService(serviceRef.getServerServiceId());
                graph.writeLink(service.getServiceAbbr(), temp.getServiceAbbr());
                graph.writeService(temp, "ellipse");
                services.add(temp);
                foundIds.add(temp.getServiceId());
            }
        }
    }
}

