/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db.inMemory;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.DataStore;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class InMemoryDataAccess
implements DataAccess {
    private final Map<String, Team> teams = new ConcurrentHashMap<String, Team>();
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private final Map<String, Host> hosts = new ConcurrentHashMap<String, Host>();
    private final Map<String, Vip> vips = new ConcurrentHashMap<String, Vip>();
    private final List<ServiceRef> serviceRefs = new LinkedList<ServiceRef>();
    private final List<VipRef> vipRefs = new LinkedList<VipRef>();
    private final Map<String, CustomFunction> customFunctions = new ConcurrentHashMap<String, CustomFunction>();
    private final Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private final Map<String, DataStore> dataStores = new ConcurrentHashMap<String, DataStore>();
    private final Map<String, WorkItem> workItems = new ConcurrentHashMap<String, WorkItem>();
    private final Map<String, User> users = new ConcurrentHashMap<String, User>();
    private final List<Audit> audits = new LinkedList<Audit>();

    @Override
    public boolean getAvailability() {
        return true;
    }

    @Override
    public Map<String, String> getHealth() {
        HashMap<String, String> health = new HashMap<String, String>();
        return health;
    }

    @Override
    public List<Team> getTeams() {
        LinkedList<Team> temp = new LinkedList<Team>(this.teams.values());
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Team getTeam(String teamId) {
        return this.teams.get(teamId);
    }

    @Override
    public void saveTeam(Team team) {
        this.teams.put(team.getTeamId(), team);
    }

    @Override
    public void updateTeam(Team team) {
        this.teams.put(team.getTeamId(), team);
    }

    @Override
    public List<Service> getServices() {
        LinkedList<Service> temp = new LinkedList<Service>();
        for (Service service : this.services.values()) {
            temp.add(service);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public List<Service> getServices(String teamId) {
        LinkedList<Service> temp = new LinkedList<Service>();
        for (Service service : this.services.values()) {
            if (!service.getTeamId().equals(teamId)) continue;
            temp.add(service);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Service getService(String serviceId) {
        return this.services.get(serviceId);
    }

    @Override
    public void saveService(Service service) {
        this.services.put(service.getServiceId(), service);
    }

    @Override
    public void updateService(Service service) {
        this.services.put(service.getServiceId(), service);
    }

    @Override
    public List<Host> getHosts(String serviceId) {
        LinkedList<Host> temp = new LinkedList<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.getServiceId().equals(serviceId)) continue;
            temp.add(host);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Host getHost(String serviceId, String hostId) {
        return this.hosts.get(hostId);
    }

    @Override
    public void saveHost(Host host) {
        this.hosts.put(host.getHostId(), host);
    }

    @Override
    public void updateHost(Host host) {
        this.hosts.put(host.getHostId(), host);
    }

    @Override
    public void deleteHost(String serviceId, String hostId) {
        this.hosts.remove(hostId);
    }

    @Override
    public List<Vip> getVips(String serviceId) {
        LinkedList<Vip> temp = new LinkedList<Vip>();
        for (Vip vip : this.vips.values()) {
            if (!vip.getServiceId().equals(serviceId)) continue;
            temp.add(vip);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Vip getVip(String serviceId, String vipId) {
        return this.vips.get(vipId);
    }

    @Override
    public void saveVip(Vip vip) {
        this.vips.put(vip.getVipId(), vip);
    }

    @Override
    public void updateVip(Vip vip) {
        this.vips.put(vip.getVipId(), vip);
    }

    @Override
    public void deleteVip(String serviceId, String vipId) {
        this.vips.remove(vipId);
    }

    @Override
    public List<ServiceRef> getServiceRefs() {
        return this.serviceRefs;
    }

    @Override
    public List<ServiceRef> getServiceRefsByClient(String clientServiceId) {
        LinkedList<ServiceRef> temp = new LinkedList<ServiceRef>();
        for (ServiceRef serviceRef : this.serviceRefs) {
            if (!serviceRef.getClientServiceId().equals(clientServiceId)) continue;
            temp.add(serviceRef);
        }
        return temp;
    }

    @Override
    public List<ServiceRef> getServiceRefsByServer(String serverServiceId) {
        LinkedList<ServiceRef> temp = new LinkedList<ServiceRef>();
        for (ServiceRef serviceRef : this.serviceRefs) {
            if (!serviceRef.getServerServiceId().equals(serverServiceId)) continue;
            temp.add(serviceRef);
        }
        return temp;
    }

    @Override
    public void saveServiceRef(ServiceRef serviceRef) {
        this.serviceRefs.add(serviceRef);
    }

    @Override
    public void deleteServiceRef(final String clientId, final String serviceId) {
        this.serviceRefs.removeIf(new Predicate<ServiceRef>(){

            @Override
            public boolean test(ServiceRef t) {
                return t.getClientServiceId().equals(clientId) && t.getServerServiceId().equals(serviceId);
            }
        });
    }

    @Override
    public List<VipRef> getVipRefsByHost(String hostId) {
        LinkedList<VipRef> temp = new LinkedList<VipRef>();
        for (VipRef vipRef : this.vipRefs) {
            if (!vipRef.getHostId().equals(hostId)) continue;
            temp.add(vipRef);
        }
        return temp;
    }

    @Override
    public VipRef getVipRef(String hostId, String vipId) {
        for (VipRef vipRef : this.vipRefs) {
            if (!vipRef.getHostId().equals(hostId) || !vipRef.getVipId().equals(vipId)) continue;
            return vipRef;
        }
        return null;
    }

    @Override
    public void saveVipRef(VipRef vipRef) {
        for (VipRef temp : this.vipRefs) {
            if (!temp.getVipId().equals(vipRef.getVipId()) || !temp.getHostId().equals(vipRef.getHostId())) continue;
            return;
        }
        this.vipRefs.add(vipRef);
    }

    @Override
    public void updateVipRef(VipRef vipRef) {
        for (VipRef temp : this.vipRefs) {
            if (!temp.getVipId().equals(vipRef.getVipId()) || !temp.getHostId().equals(vipRef.getHostId())) continue;
            temp.setStatus(vipRef.getStatus());
            return;
        }
    }

    @Override
    public void deleteVipRef(final String hostId, final String vipId) {
        this.vipRefs.removeIf(new Predicate<VipRef>(){

            @Override
            public boolean test(VipRef ref) {
                return ref.getHostId().equals(hostId) && ref.getVipId().equals(vipId);
            }
        });
    }

    @Override
    public void deleteVipRefs(final String vipId) {
        this.vipRefs.removeIf(new Predicate<VipRef>(){

            @Override
            public boolean test(VipRef ref) {
                return ref.getVipId().equals(vipId);
            }
        });
    }

    @Override
    public List<CustomFunction> getCustomFunctions(String serviceId) {
        LinkedList<CustomFunction> temp = new LinkedList<CustomFunction>();
        for (CustomFunction customFunction : this.customFunctions.values()) {
            if (!customFunction.getServiceId().equals(serviceId)) continue;
            temp.add(customFunction);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public CustomFunction getCustomFunction(String serviceId, String customFunctionId) {
        return this.customFunctions.get(customFunctionId);
    }

    @Override
    public void saveCustomFunction(CustomFunction customFunction) {
        this.customFunctions.put(customFunction.getCustomFunctionId(), customFunction);
    }

    @Override
    public void updateCustomFunction(CustomFunction customFunction) {
        this.customFunctions.put(customFunction.getCustomFunctionId(), customFunction);
    }

    @Override
    public void deleteCustomFunction(String serviceId, String customFunctionId) {
        this.customFunctions.remove(customFunctionId);
    }

    @Override
    public List<Module> getModules(String serviceId) {
        LinkedList<Module> temp = new LinkedList<Module>();
        for (Module module : this.modules.values()) {
            if (!module.getServiceId().equals(serviceId)) continue;
            temp.add(module);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Module getModule(String serviceId, String moduleId) {
        return this.modules.get(moduleId);
    }

    @Override
    public void saveModule(Module module) {
        this.modules.put(module.getModuleId(), module);
    }

    @Override
    public void updateModule(Module module) {
        this.modules.put(module.getModuleId(), module);
    }

    @Override
    public void deleteModule(String serviceId, String moduleId) {
        this.modules.remove(moduleId);
    }

    @Override
    public List<DataStore> getDataStores(String serviceId) {
        LinkedList<DataStore> temp = new LinkedList<DataStore>();
        for (DataStore dataStore : this.dataStores.values()) {
            if (!dataStore.getServiceId().equals(serviceId)) continue;
            temp.add(dataStore);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public DataStore getDataStore(String serviceId, String dataStoreId) {
        return this.dataStores.get(dataStoreId);
    }

    @Override
    public void saveDataStore(DataStore dataStore) {
        this.dataStores.put(dataStore.getDataStoreId(), dataStore);
    }

    @Override
    public void updateDataStore(DataStore dataStore) {
        this.dataStores.put(dataStore.getDataStoreId(), dataStore);
    }

    @Override
    public void deleteDataStore(String serviceId, String dataStoreId) {
        this.dataStores.remove(dataStoreId);
    }

    @Override
    public List<WorkItem> getWorkItems() {
        LinkedList<WorkItem> temp = new LinkedList<WorkItem>(this.workItems.values());
        return temp;
    }

    @Override
    public WorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    @Override
    public void saveWorkItem(WorkItem workItem) {
        this.workItems.put(workItem.getId(), workItem);
    }

    @Override
    public void deleteWorkItem(String id) {
        this.workItems.remove(id);
    }

    @Override
    public List<User> getUsers() {
        LinkedList<User> temp = new LinkedList<User>(this.users.values());
        Collections.sort(temp);
        return temp;
    }

    @Override
    public User getUser(String userName) {
        return this.users.get(userName);
    }

    @Override
    public void saveUser(User user) {
        this.users.put(user.getUsername(), user);
    }

    @Override
    public void updateUser(User user) {
        this.users.put(user.getUsername(), user);
    }

    @Override
    public void deleteUser(String userName) {
        this.users.remove(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAudit(Audit audit, String output) {
        List<Audit> list = this.audits;
        synchronized (list) {
            this.audits.add(audit);
            if (this.audits.size() > 100) {
                this.audits.remove(0);
            }
        }
    }

    @Override
    public List<Audit> getAudit(String serviceId, Date start, Date end) {
        LinkedList<Audit> temp = new LinkedList<Audit>();
        for (Audit audit : this.audits) {
            if (!audit.serviceId.equals(serviceId)) continue;
            temp.add(audit);
        }
        return temp;
    }
}

