/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.calendar.google;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.calendar.Calendar;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.calendar.CalendarHelperFactory;
import com.northernwall.hadrian.calendar.google.GoogleCalendarHelper;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.OkHttpClient;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCalendarHelperFactory
implements CalendarHelperFactory {
    private static final Logger logger = LoggerFactory.getLogger(GoogleCalendarHelperFactory.class);
    private static final String APPLICATION_NAME = "";

    @Override
    public CalendarHelper create(Parameters parameters, OkHttpClient client) {
        try {
            JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            File dataStoreDir = new File(parameters.getString("calendarHelper.google.dataStoreDir", null));
            FileDataStoreFactory dataStoreFactory = new FileDataStoreFactory(dataStoreDir);
            StringReader reader = new StringReader(parameters.getString("calendarHelper.google.clientSecrets", null));
            GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)jsonFactory, (Reader)reader);
            GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, clientSecrets, Collections.singleton("https://www.googleapis.com/auth/calendar")).setDataStoreFactory((DataStoreFactory)dataStoreFactory).build();
            Credential credential = new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new LocalServerReceiver()).authorize("user");
            Calendar calendarClient = new Calendar.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
            logger.info("Finished building GoogleCalendarHelper successfully");
            return new GoogleCalendarHelper(calendarClient, parameters);
        }
        catch (IOException ex) {
            throw new RuntimeException("IO Exception while building GoogleCalendarHelper", ex);
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("General Security Exception while building GoogleCalendarHelper", ex);
        }
    }
}

