/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.params;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface Params {
    public Optional<Map<String, Object>> getParameters();

    public static class Param {
        private final String key;
        private final Object val;

        public Param(String key, Object val) {
            if (key == null || key.isEmpty()) {
                throw new IllegalArgumentException("[key] must be a non-empty string");
            }
            this.key = key;
            this.val = val;
        }

        public String getKey() {
            return this.key;
        }

        public Object getVal() {
            return this.val;
        }

        public static Optional<Map<String, Object>> mapOf(Param ... params) {
            if (params == null || params.length == 0) {
                return Optional.absent();
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (Param param : params) {
                paramMap.put(param.key, param.val);
            }
            return Optional.of(Collections.unmodifiableMap(paramMap));
        }

        public static Param param(String key, Object val) {
            return new Param(key, val);
        }
    }
}

