/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.jdbc;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class Param {
    private Mode mode = Mode.IN;
    private int paramType;
    private Object inputValue;

    private Param() {
    }

    public static Param create(Mode mode, int paramType, Object inputValue) {
        if (mode == Mode.OUT) {
            return Param.out(paramType);
        }
        if (mode == Mode.INOUT) {
            return Param.inOut(paramType, inputValue);
        }
        return Param.in(paramType, inputValue);
    }

    public static Param in(int paramType, Object inputValue) {
        Param parameter = new Param();
        parameter.mode = Mode.IN;
        parameter.paramType = paramType;
        parameter.inputValue = inputValue;
        return parameter;
    }

    public static Param out(int paramType) {
        Param parameter = new Param();
        parameter.mode = Mode.OUT;
        parameter.paramType = paramType;
        return parameter;
    }

    public static Param inOut(int paramType, Object inputValue) {
        Param parameter = new Param();
        parameter.mode = Mode.INOUT;
        parameter.inputValue = inputValue;
        parameter.paramType = paramType;
        return parameter;
    }

    static Param[] array(int size) {
        return new Param[size];
    }

    public void set(CallableStatement sproc, int index) throws SQLException {
        if (this.isOutput()) {
            sproc.registerOutParameter(index, this.paramType);
        }
        if (this.isInput()) {
            if (this.inputValue == null) {
                sproc.setNull(index, this.paramType);
            } else {
                switch (this.paramType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setCharString(sproc, index);
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: {
                        this.setNCharString(sproc, index);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this.setBinary(sproc, index);
                        break;
                    }
                    case -7: 
                    case 16: {
                        this.setBoolean(sproc, index);
                        break;
                    }
                    case 5: {
                        this.setSmallInt(sproc, index);
                        break;
                    }
                    case 4: {
                        this.setInteger(sproc, index);
                        break;
                    }
                    case -5: {
                        this.setBigInt(sproc, index);
                        break;
                    }
                    case 7: {
                        this.setReal(sproc, index);
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(sproc, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.setDecimal(sproc, index);
                        break;
                    }
                    case 91: {
                        this.setDate(sproc, index);
                        break;
                    }
                    case 92: {
                        this.setTime(sproc, index);
                        break;
                    }
                    case 93: {
                        this.setTimestamp(sproc, index);
                        break;
                    }
                    case 1111: 
                    case 2000: {
                        this.setJavaObject(sproc, index);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Specified parameter type [" + this.paramType + "] is unsupported");
                    }
                }
            }
        }
    }

    private void setCharString(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof String)) {
            throw new IllegalArgumentException("Specified parameter value is not a string");
        }
        sproc.setString(index, (String)this.inputValue);
    }

    private void setNCharString(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof String)) {
            throw new IllegalArgumentException("Specified parameter value is not a string");
        }
        sproc.setNString(index, (String)this.inputValue);
    }

    private void setBinary(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof byte[])) {
            throw new IllegalArgumentException("Specified parameter value is not an array of bytes");
        }
        sproc.setBytes(index, (byte[])this.inputValue);
    }

    private void setBoolean(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Boolean)) {
            throw new IllegalArgumentException("Specified parameter value is not a boolean");
        }
        sproc.setBoolean(index, (boolean)((Boolean)this.inputValue));
    }

    private void setSmallInt(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Short)) {
            throw new IllegalArgumentException("Specified parameter value is not a small integer (short)");
        }
        sproc.setShort(index, (short)((Short)this.inputValue));
    }

    private void setInteger(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Integer)) {
            throw new IllegalArgumentException("Specified parameter value is not an integer");
        }
        sproc.setInt(index, (int)((Integer)this.inputValue));
    }

    private void setBigInt(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Long)) {
            throw new IllegalArgumentException("Specified parameter value is not a big integer (long)");
        }
        sproc.setLong(index, (long)((Long)this.inputValue));
    }

    private void setReal(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Float)) {
            throw new IllegalArgumentException("Specified parameter value is not a single-precision float (float)");
        }
        sproc.setFloat(index, ((Float)this.inputValue).floatValue());
    }

    private void setDouble(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Double)) {
            throw new IllegalArgumentException("Specified parameter value is not a double-precision float (double)");
        }
        sproc.setDouble(index, (double)((Double)this.inputValue));
    }

    private void setDecimal(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof BigDecimal)) {
            throw new IllegalArgumentException("Specified parameter value is not a decimal (BigDecimal)");
        }
        sproc.setBigDecimal(index, (BigDecimal)this.inputValue);
    }

    private void setDate(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Date)) {
            throw new IllegalArgumentException("Specified parameter value is not a SQL Date object");
        }
        sproc.setDate(index, (Date)this.inputValue);
    }

    private void setTime(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Time)) {
            throw new IllegalArgumentException("Specified parameter value is not a SQL Time object");
        }
        sproc.setTime(index, (Time)this.inputValue);
    }

    private void setTimestamp(CallableStatement sproc, int index) throws SQLException {
        if (!(this.inputValue instanceof Timestamp)) {
            throw new IllegalArgumentException("Specified parameter value is not a SQL Timestamp object");
        }
        sproc.setTimestamp(index, (Timestamp)this.inputValue);
    }

    private void setJavaObject(CallableStatement sproc, int index) throws SQLException {
        sproc.setObject(index, this.inputValue);
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isInput() {
        return this.mode.isInput();
    }

    public boolean isOutput() {
        return this.mode.isOutput();
    }

    public Object getInValue() {
        return this.inputValue;
    }

    public int getParamType() {
        return this.paramType;
    }

    public static enum Mode {
        IN('>', 1),
        OUT('<', 2),
        INOUT('=', 3);

        private static final int INPUT = 1;
        private static final int OUTPUT = 2;
        private final char chr;
        private final int val;

        private Mode(char chr, int val) {
            this.chr = chr;
            this.val = val;
        }

        public char chr() {
            return this.chr;
        }

        public int val() {
            return this.val;
        }

        public boolean isInput() {
            return (this.val & 1) == 1;
        }

        public boolean isOutput() {
            return (this.val & 2) == 2;
        }

        public static Mode fromChar(char chr) {
            for (Mode thisMode : Mode.values()) {
                if (thisMode.chr != chr) continue;
                return thisMode;
            }
            throw new IllegalArgumentException("Specified parameter mode placeholder '" + chr + "' is unsupported");
        }
    }
}

