/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.jar;

import com.google.common.base.Joiner;
import com.nordstrom.common.base.UncheckedThrow;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarUtils {
    public static String getClasspath(String[] dependencyContexts) {
        List<String> contextPaths = JarUtils.getContextPaths(false, dependencyContexts);
        String classPath = contextPaths.remove(0);
        if (contextPaths.isEmpty()) {
            return classPath;
        }
        return classPath + "\n" + Joiner.on((String)"\t").join(contextPaths);
    }

    public static List<String> getContextPaths(String[] dependencyContexts) {
        return JarUtils.getContextPaths(true, dependencyContexts);
    }

    private static List<String> getContextPaths(boolean prefixAgents, String[] dependencyContexts) {
        HashSet<String> pathList = new HashSet<String>();
        HashSet<String> agentList = new HashSet<String>();
        ArrayList<String> contextPaths = new ArrayList<String>();
        String prefix = prefixAgents ? "-javaagent:" : "";
        for (String contextClassName : dependencyContexts) {
            String jarPath = JarUtils.findJarPathFor(contextClassName);
            if (contextClassName.equals(JarUtils.getJarPremainClass(jarPath))) {
                agentList.add(prefix + jarPath);
                continue;
            }
            pathList.add(jarPath);
        }
        contextPaths.add(Joiner.on((String)File.pathSeparator).join(pathList));
        contextPaths.addAll(agentList);
        return contextPaths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findJarPathFor(String contextClassName) {
        String protocol;
        String uri;
        Class<?> contextClass;
        try {
            contextClass = Class.forName(contextClassName);
        }
        catch (ClassNotFoundException e) {
            throw UncheckedThrow.throwUnchecked(e);
        }
        String shortName = contextClassName;
        int idx = shortName.lastIndexOf(46);
        if (idx > -1) {
            shortName = shortName.substring(idx + 1);
        }
        if ((uri = contextClass.getResource(shortName + ".class").toString()).startsWith("file:")) {
            protocol = "file:";
            String relPath = '/' + contextClassName.replace('.', '/') + ".class";
            if (!uri.endsWith(relPath)) throw new IllegalStateException("Unrecognized structure file-protocol path: " + uri);
            idx = uri.length() - relPath.length();
        } else if (uri.startsWith("jar:file:")) {
            protocol = "jar:file:";
            idx = uri.indexOf(33);
            if (idx == -1) {
                throw new IllegalStateException("No separator found in jar-protocol path: " + uri);
            }
        } else {
            idx = uri.indexOf(58);
            String protocol2 = idx > -1 ? uri.substring(0, idx) : "(unknown)";
            throw new IllegalStateException("This class has been loaded remotely via the " + protocol2 + " protocol. Only loading from a jar on the local file system is supported.");
        }
        try {
            String fileName = URLDecoder.decode(uri.substring(protocol.length(), idx), Charset.defaultCharset().name());
            return new File(fileName).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw (InternalError)new InternalError("Default charset doesn't exist. Your VM is borked.").initCause(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJarPremainClass(String jarPath) {
        try (FileInputStream inputStream = new FileInputStream(jarPath);
             JarInputStream jarStream = new JarInputStream(inputStream);){
            Manifest manifest = jarStream.getManifest();
            if (manifest == null) return null;
            String string = manifest.getMainAttributes().getValue("Premain-Class");
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

