/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.base;

public class StackTrace
extends Throwable {
    private static final long serialVersionUID = -3623586250962214453L;

    public StackTrace() {
        this("stack trace");
    }

    public StackTrace(String message) {
        this(message, null);
    }

    public StackTrace(String message, Throwable cause) {
        super(message + " on " + Thread.currentThread().getName(), cause);
    }

    public static StackTrace forThread(Thread t) {
        if (t == null) {
            return null;
        }
        StackTrace st = new StackTrace(t.toString());
        StackTraceElement[] stackTrace = t.getStackTrace();
        int start = 0;
        if (stackTrace.length > 2 && stackTrace[0].isNativeMethod()) {
            ++start;
        }
        if (start > 0) {
            StackTraceElement[] ste2 = new StackTraceElement[stackTrace.length - start];
            System.arraycopy(stackTrace, start, ste2, 0, ste2.length);
            stackTrace = ste2;
        }
        st.setStackTrace(stackTrace);
        return st;
    }
}

