/*
 * Decompiled with CFR 0.152.
 */
package com.nlocketz.plugins;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.nlocketz.internal.EasyPluginPlugin;
import com.nlocketz.internal.MarkedPluginClass;
import com.nlocketz.internal.UserMarkerAnnotation;
import com.nlocketz.internal.Util;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.lang.model.element.Modifier;

public class JacksonEasyPluginPlugin
implements EasyPluginPlugin {
    private static final String DESERIALIZER_CLASS = "Deserializer";
    private static final ParameterizedTypeName ITERATOR_STRING = ParameterizedTypeName.get(Iterator.class, (Type[])new Type[]{String.class});

    public void updateRegistry(TypeSpec.Builder registry, UserMarkerAnnotation annotation) {
        TypeName retType = annotation.getServiceInterfaceTypeName();
        TypeSpec.Builder deserializerBuilder = TypeSpec.classBuilder((String)DESERIALIZER_CLASS).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(StdDeserializer.class), (TypeName[])new TypeName[]{retType})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addStatement("this(null)", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addParameter(Class.class, "clazz", new Modifier[0]).addStatement("super(clazz)", new Object[0]).build());
        String jsonParser = "jsonParser";
        String registeredName = "registeredName";
        String node = "node";
        String fieldNames = "fieldNames";
        MethodSpec deserializerMethod = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(JsonParser.class, jsonParser, new Modifier[0]).addParameter(DeserializationContext.class, "ctxt", new Modifier[0]).addException(IOException.class).addException(JsonProcessingException.class).returns(annotation.getServiceInterfaceTypeName()).addStatement("$T $L", new Object[]{String.class, registeredName}).beginControlFlow("if ($L.isExpectedStartObjectToken())", new Object[]{jsonParser}).addStatement("$T $L = $L.getCodec().readTree($L)", new Object[]{TreeNode.class, node, jsonParser, jsonParser}).addComment("Check that object has exactly one key", new Object[0]).addStatement("$T $L = $L.fieldNames()", new Object[]{ITERATOR_STRING, fieldNames, node}).beginControlFlow("if (!$L.hasNext())", new Object[]{fieldNames}).addComment("No keys; throw an exception", new Object[0]).addStatement(String.format("throw new RuntimeException(\"Failed to deserialize %s: no field names found\")", annotation.getServiceInterfaceName()), new Object[0]).endControlFlow().addComment("At least one key; get the registered name", new Object[0]).addStatement("$L = $L.next()", new Object[]{registeredName, fieldNames}).beginControlFlow("if ($L.hasNext())", new Object[]{fieldNames}).addComment("Too many keys; input is malformed", new Object[0]).addStatement(String.format("throw new RuntimeException(\"Failed to deserialize %s: too many field names found\")", annotation.getServiceInterfaceName()), new Object[0]).endControlFlow().addComment("Check that service is registered and initialize", new Object[0]).beginControlFlow("if (getInstance().$L.containsKey($L))", new Object[]{"pluginMap", registeredName}).addStatement("return getInstance().$L.get($L).deserialize($L.get($L).traverse($L.getCodec()))", new Object[]{"pluginMap", registeredName, node, registeredName, jsonParser}).nextControlFlow("else", new Object[0]).addStatement(String.format("throw new RuntimeException($T.format(\"Failed to deserialize %s: Service \\\"%%s\\\" not found in registry\", $L))", annotation.getServiceInterfaceName()), new Object[]{String.class, registeredName}).endControlFlow().nextControlFlow("else", new Object[0]).addComment("Not an object; assume we're working with a string that corresponds to a configuration-less service", new Object[0]).addStatement("$L = $L.getValueAsString()", new Object[]{registeredName, jsonParser}).addComment("Check that service is registered and initialize", new Object[0]).beginControlFlow("if (getInstance().$L.containsKey($L))", new Object[]{"pluginMap", registeredName}).addStatement("return getInstance().$L.get($L).deserialize()", new Object[]{"pluginMap", registeredName}).nextControlFlow("else", new Object[0]).addStatement(String.format("throw new RuntimeException($T.format(\"Failed to deserialize %s: Service \\\"%%s\\\" not found in registry\", $L))", annotation.getServiceInterfaceName()), new Object[]{String.class, registeredName}).endControlFlow().endControlFlow().build();
        deserializerBuilder = deserializerBuilder.addMethod(deserializerMethod);
        ParameterizedTypeName configType = ParameterizedTypeName.get((ClassName)ClassName.get(TypeReference.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        String serviceName = "serviceName";
        MethodSpec getConfigTypeReference = MethodSpec.methodBuilder((String)"getConfigTypeReference").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(String.class, serviceName, new Modifier[0]).returns((TypeName)configType).beginControlFlow("if (getInstance().$L.containsKey($L))", new Object[]{"pluginMap", serviceName}).addStatement("return getInstance().$L.get($L).getConfigTypeReference()", new Object[]{"pluginMap", serviceName}).nextControlFlow("else", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().build();
        registry.addType(deserializerBuilder.build());
        registry.addMethod(getConfigTypeReference);
    }

    public void updatePluginProvider(TypeSpec.Builder provider, MarkedPluginClass markedPluginClass) {
        ParameterizedTypeName configTypeRef = ParameterizedTypeName.get((ClassName)ClassName.get(TypeReference.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        MethodSpec.Builder getConfigTypeReferenceBuilder = MethodSpec.methodBuilder((String)"getConfigTypeReference").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)configTypeRef);
        getConfigTypeReferenceBuilder = markedPluginClass.getConfigType() != null ? getConfigTypeReferenceBuilder.addStatement("return new $T<$T>() {}", new Object[]{TypeReference.class, markedPluginClass.getConfigType()}) : getConfigTypeReferenceBuilder.addStatement("return null", new Object[0]);
        String config = "config";
        String typeRef = "typeRef";
        MethodSpec deserializeWithConfig = Util.publicFinalMethod((String)"deserialize", (TypeName)markedPluginClass.getTypeName()).addAnnotation(Override.class).addParameter(JsonParser.class, config, new Modifier[0]).addStatement("$T $L = this.getConfigTypeReference()", new Object[]{configTypeRef, typeRef}).beginControlFlow("if ($L == null || $L == null)", new Object[]{config, typeRef}).addStatement("return this.create()", new Object[0]).nextControlFlow("else", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("return this.createWithConfig($L.readValueAs($L))", new Object[]{config, typeRef}).nextControlFlow("catch ($T e)", new Object[]{IOException.class}).addStatement("throw new $T(e)", new Object[]{RuntimeException.class}).endControlFlow().endControlFlow().build();
        MethodSpec deserializeWithoutConfig = Util.publicFinalMethod((String)"deserialize", (TypeName)markedPluginClass.getTypeName()).addAnnotation(Override.class).addStatement("return this.create()", new Object[0]).build();
        provider.addMethod(getConfigTypeReferenceBuilder.build());
        provider.addMethod(deserializeWithConfig);
        provider.addMethod(deserializeWithoutConfig);
    }

    public void updatePluginProviderInterface(TypeSpec.Builder serviceInterface, UserMarkerAnnotation annotation) {
        TypeName returnType = annotation.getServiceInterfaceTypeName();
        MethodSpec deserializeWithoutConfig = Util.publicAbstractMethod((String)"deserialize", (TypeName)returnType).build();
        MethodSpec deserializeWithConfig = Util.publicAbstractMethod((String)"deserialize", (TypeName)returnType).addParameter(JsonParser.class, "config", new Modifier[0]).build();
        ParameterizedTypeName configType = ParameterizedTypeName.get((ClassName)ClassName.get(TypeReference.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        MethodSpec getConfigTypeReference = Util.publicAbstractMethod((String)"getConfigTypeReference", (TypeName)configType).build();
        serviceInterface.addMethod(deserializeWithoutConfig);
        serviceInterface.addMethod(deserializeWithConfig);
        serviceInterface.addMethod(getConfigTypeReference);
    }
}

