/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.xmlutils;

import com.nitorcreations.xmlutils.FileTransformListener;
import com.nitorcreations.xmlutils.IterableNodeList;
import com.nitorcreations.xmlutils.NodeTransformListener;
import com.nitorcreations.xmlutils.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLMultiplier {
    private Document baseXsl;
    private String templateNodesXpath;
    private Document transformTemplateNodeXsl;
    private Document getNodeParentXsl;
    private Document getFilenameXsl;
    private Document finalizeFileXsl;
    private Map<String, Integer> nodeCounts = new HashMap<String, Integer>();
    private List<NodeTransformListener> nodeListeners = new ArrayList<NodeTransformListener>();
    private List<FileTransformListener> fileListeners = new ArrayList<FileTransformListener>();
    private Map<String, String> context = new LinkedHashMap<String, String>();

    public Document getBaseXsl() {
        return this.baseXsl;
    }

    public void setBaseXsl(Document baseXsl) {
        this.baseXsl = baseXsl;
    }

    public String getTemplateNodesXpath() {
        return this.templateNodesXpath;
    }

    public void setTemplateNodesXpath(String templateNodesXpath) {
        this.templateNodesXpath = templateNodesXpath;
    }

    public Document getTransformTemplateNodeXsl() {
        return this.transformTemplateNodeXsl;
    }

    public void setTransformTemplateNodeXsl(Document transformTemplateNodeXsl) {
        this.transformTemplateNodeXsl = transformTemplateNodeXsl;
    }

    public Document getGetNodeParentXsl() {
        return this.getNodeParentXsl;
    }

    public void setGetNodeParentXsl(Document getNodeParentXsl) {
        this.getNodeParentXsl = getNodeParentXsl;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public Document getGetFilenameXsl() {
        return this.getFilenameXsl;
    }

    public void setGetFilenameXsl(Document getFilenameXsl) {
        this.getFilenameXsl = getFilenameXsl;
    }

    public Document getFinalizeFileXsl() {
        return this.finalizeFileXsl;
    }

    public void setFinalizeFileXsl(Document finalizeFileXsl) {
        this.finalizeFileXsl = finalizeFileXsl;
    }

    public void addNodeTransformListener(NodeTransformListener listener) {
        this.nodeListeners.add(listener);
    }

    public void addFileTransformListener(FileTransformListener listener) {
        this.fileListeners.add(listener);
    }

    public List<File> multiply(File outputDir, File template, int nodecopiesPerFile, int files) {
        Document templateXml = XMLUtil.parseDocument(template);
        for (Map.Entry<Object, Object> next : System.getProperties().entrySet()) {
            this.getContext().put((String)next.getKey(), (String)next.getValue());
        }
        int nodeCopies = 0;
        ArrayList<File> ret = new ArrayList<File>(files);
        IterableNodeList templates = XMLUtil.runXPath(this.getTemplateNodesXpath(), templateXml.getDocumentElement());
        for (int i = 0; i < files; ++i) {
            this.context.put("fileNum", Integer.toString(i + 1));
            for (FileTransformListener next : this.fileListeners) {
                next.beforeFile(templateXml, outputDir, this.context);
            }
            Node nextDoc = XMLUtil.transform(templateXml, this.getBaseXsl(), this.context);
            String parentXpath = XMLUtil.transformToString(nextDoc, this.getGetNodeParentXsl(), this.context);
            Node parent = XMLUtil.runXPath(parentXpath, nextDoc).item(0);
            for (int j = 0; j < nodecopiesPerFile; ++j) {
                Node nextNodeTemplate = templates.item(j % templates.getLength());
                this.incrementFileNodeCount(nextNodeTemplate.getNodeName());
                this.incrementFullNodeCount(nextNodeTemplate.getNodeName());
                for (Map.Entry<String, Integer> entry : this.nodeCounts.entrySet()) {
                    this.context.put(entry.getKey(), entry.getValue().toString());
                }
                this.context.put("all-file", Integer.toString(j + 1));
                this.context.put("all-full", Integer.toString(nodeCopies + 1));
                for (NodeTransformListener nodeTransformListener : this.nodeListeners) {
                    nodeTransformListener.beforeTransform(nextNodeTemplate, this.context);
                }
                Node nextResult = XMLUtil.transform(nextNodeTemplate, this.getTransformTemplateNodeXsl(), this.context);
                for (NodeTransformListener next : this.nodeListeners) {
                    next.afterTransform(nextNodeTemplate, parent, this.context);
                }
                parent.getOwnerDocument().adoptNode(nextResult);
                parent.appendChild(nextResult);
                ++nodeCopies;
            }
            Node finalXml = XMLUtil.transform(nextDoc, this.getFinalizeFileXsl(), this.context);
            String fileName = XMLUtil.transformToString(finalXml, this.getGetFilenameXsl(), this.context);
            Document finalDoc = XMLUtil.emptyDocument();
            finalDoc.adoptNode(finalXml);
            finalDoc.appendChild(finalXml);
            File file = new File(outputDir, fileName);
            XMLUtil.writeDocument(finalDoc, file);
            for (FileTransformListener next : this.fileListeners) {
                next.afterFile(finalXml.getOwnerDocument(), file, this.context);
            }
            this.resetFileCounters();
            ret.add(file);
        }
        return ret;
    }

    private void incrementFileNodeCount(String nodeName) {
        this.incrementNodeCount(nodeName + "-file");
    }

    private void incrementFullNodeCount(String nodeName) {
        this.incrementNodeCount(nodeName + "-full");
    }

    private void incrementNodeCount(String counterName) {
        Integer count = this.nodeCounts.get(counterName);
        int ret = 1;
        if (count != null) {
            ret = count + 1;
        }
        this.nodeCounts.put(counterName, ret);
    }

    private void resetFileCounters() {
        HashMap<String, Integer> newCounters = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> next : this.nodeCounts.entrySet()) {
            if (next.getKey().endsWith("-file")) {
                newCounters.put(next.getKey(), 0);
                continue;
            }
            newCounters.put(next.getKey(), next.getValue());
        }
        this.nodeCounts = newCounters;
    }
}

