/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.xmlutils;

import com.nitorcreations.xmlutils.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utils {
    static SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static HashMap<String, String> entityToChar;

    public static String fixName(String name) {
        name = Utils.trimNewlines(name);
        String[] splitName = name.split("-");
        StringBuffer ret = new StringBuffer();
        for (String next : splitName) {
            ret.append(next.trim()).append("-");
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    public static Document getTidyURLDocument(String urlStr) throws IOException, SAXException {
        URL url = new URL(urlStr);
        URLConnection conn = url.openConnection();
        return Utils.getTidyDocument(conn.getInputStream());
    }

    public static Document getTidyPostDocument(String urlString, Map<String, String> postProperties) throws IOException, SAXException {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        StringBuilder content = new StringBuilder();
        for (Map.Entry<String, String> next : postProperties.entrySet()) {
            content.append(URLEncoder.encode(next.getKey(), "utf-8")).append("=").append(URLEncoder.encode(next.getValue(), "utf-8")).append("&");
        }
        content.setLength(content.length() - 1);
        printout.writeBytes(content.toString());
        printout.flush();
        printout.close();
        return Utils.getTidyDocument(urlConn.getInputStream());
    }

    public static Document getTidyDocument(InputStream in) throws IOException, SAXException {
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("ISO-8859-1");
        tidy.setShowWarnings(false);
        tidy.setNumEntities(true);
        tidy.setXmlOut(true);
        tidy.setXHTML(true);
        tidy.setXmlTags(false);
        tidy.setWraplen(180);
        tidy.setFixComments(true);
        tidy.setQuiet(true);
        tidy.setErrout(new PrintWriter(new ByteArrayOutputStream()));
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048000);
        tidy.parse(in, (OutputStream)out);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        dbf.setValidating(false);
        String xml = new String(out.toByteArray(), "ISO-8859-15");
        xml = Utils.removeEntities(xml);
        Pattern p = Pattern.compile("(\\<\\!\\[[ie].*?\\]\\>)|(\\<script.*?\\<\\/script\\>)|(\\<style.*?\\<\\/style\\>)", 42);
        xml = p.matcher(xml).replaceAll("");
        ByteArrayInputStream bin = new ByteArrayInputStream(xml.getBytes("utf8"));
        try {
            db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = db.parse(bin);
        return doc;
    }

    public static String trimNewlines(String source) {
        StringBuilder ret = new StringBuilder();
        block4: for (char next : source.toCharArray()) {
            switch (next) {
                case '\r': {
                    ret.append(" ");
                    continue block4;
                }
                case '\n': {
                    ret.append(" ");
                    continue block4;
                }
                default: {
                    ret.append(next);
                }
            }
        }
        return ret.toString().trim();
    }

    protected static String removeEntities(String hasEntities) {
        StringBuffer ret = new StringBuffer();
        boolean inEsc = false;
        StringBuffer currEsc = new StringBuffer();
        for (char c : hasEntities.toCharArray()) {
            if (inEsc) {
                if (c == ';') {
                    inEsc = false;
                    String esc = currEsc.toString();
                    currEsc.setLength(0);
                    String repl = entityToChar.get(esc);
                    if (repl == null || repl.length() <= 0) continue;
                    ret.append(repl);
                    continue;
                }
                currEsc.append(c);
                if (currEsc.length() <= 6) continue;
                inEsc = false;
                ret.append("&").append(currEsc.toString());
                currEsc.setLength(0);
                continue;
            }
            if (c == '&') {
                inEsc = true;
                continue;
            }
            ret.append(c);
        }
        if (inEsc) {
            ret.append("&").append(currEsc.toString());
        }
        return ret.toString();
    }

    public static int getColSpan(Node cell) {
        Node colspan = cell.getAttributes().getNamedItem("colspan");
        int csVal = 0;
        if (colspan != null) {
            csVal = Integer.parseInt(colspan.getTextContent());
        }
        return csVal;
    }

    public static String getClassAttribute(Node cell) {
        return XMLUtil.getAttribute(cell, "class");
    }

    public static String getUrlAttribute(String url, String attr) {
        String[] splitAttrs;
        String attrs = url.split("\\?", 2)[1];
        for (String nextAttr : splitAttrs = attrs.split("&")) {
            if (!nextAttr.startsWith(attr + "=")) continue;
            String ret = nextAttr.substring(attr.length() + 1);
            try {
                return URLDecoder.decode(ret, "utf8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static Node addChannel(Document feed, String channelName, String channelUrl, String channelLang) {
        Element channel = feed.createElement("channel");
        Element channelTitle = feed.createElement("title");
        Element channelLink = feed.createElement("link");
        Element channelLanguage = feed.createElement("language");
        channelTitle.appendChild(feed.createTextNode(channelName));
        channelLink.appendChild(feed.createTextNode(channelUrl));
        channelLanguage.appendChild(feed.createTextNode(channelLang));
        channel.appendChild(channelTitle);
        channel.appendChild(channelLink);
        channel.appendChild(channelLanguage);
        feed.getDocumentElement().appendChild(channel);
        return channel;
    }

    public static void appendRssItem(Node channel, String title, String link, String description, Date time) {
        Document feed = channel.getOwnerDocument();
        Element itemNode = feed.createElement("item");
        Element titleNode = feed.createElement("title");
        Element linkNode = feed.createElement("link");
        Element descNode = feed.createElement("description");
        Element dateNode = feed.createElement("dc:date");
        channel.appendChild(itemNode);
        itemNode.appendChild(titleNode);
        itemNode.appendChild(linkNode);
        itemNode.appendChild(descNode);
        itemNode.appendChild(dateNode);
        titleNode.appendChild(feed.createTextNode(title));
        linkNode.appendChild(feed.createTextNode(link));
        descNode.appendChild(feed.createCDATASection(description));
        dateNode.setTextContent(dayFormat.format(time));
    }

    static {
        dayFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        entityToChar = new HashMap();
        entityToChar.put("amp", "&amp;");
        entityToChar.put("nbsp", "\u00a0");
        entityToChar.put("iexcl", "\u00a1");
        entityToChar.put("cent", "\u00a2");
        entityToChar.put("pound", "\u00a3");
        entityToChar.put("curren", "\u00a4");
        entityToChar.put("yen", "\u00a5");
        entityToChar.put("brvbar", "\u00a6");
        entityToChar.put("sect", "\u00a7");
        entityToChar.put("uml", "\u00a8");
        entityToChar.put("copy", "\u00a9");
        entityToChar.put("ordf", "\u00aa");
        entityToChar.put("laquo", "\u00ab");
        entityToChar.put("not", "\u00ac");
        entityToChar.put("shy", "\u00ad");
        entityToChar.put("reg", "\u00ae");
        entityToChar.put("macr", "\u00af");
        entityToChar.put("deg", "\u00b0");
        entityToChar.put("plusmn", "\u00b1");
        entityToChar.put("sup2", "\u00b2");
        entityToChar.put("sup3", "\u00b3");
        entityToChar.put("acute", "\u00b4");
        entityToChar.put("micro", "\u00b5");
        entityToChar.put("para", "\u00b6");
        entityToChar.put("middot", "\u00b7");
        entityToChar.put("cedil", "\u00b8");
        entityToChar.put("sup1", "\u00b9");
        entityToChar.put("ordm", "\u00ba");
        entityToChar.put("raquo", "\u00bb");
        entityToChar.put("frac14", "\u00bc");
        entityToChar.put("frac12", "\u00bd");
        entityToChar.put("frac34", "\u00be");
        entityToChar.put("iquest", "\u00bf");
        entityToChar.put("Agrave", "\u00c0");
        entityToChar.put("Aacute", "\u00c1");
        entityToChar.put("Acirc", "\u00c2");
        entityToChar.put("Atilde", "\u00c3");
        entityToChar.put("Auml", "\u00c4");
        entityToChar.put("Aring", "\u00c5");
        entityToChar.put("AElig", "\u00c6");
        entityToChar.put("Ccedil", "\u00c7");
        entityToChar.put("Egrave", "\u00c8");
        entityToChar.put("Eacute", "\u00c9");
        entityToChar.put("Ecirc", "\u00ca");
        entityToChar.put("Euml", "\u00cb");
        entityToChar.put("Igrave", "\u00cc");
        entityToChar.put("Iacute", "\u00cd");
        entityToChar.put("Icirc", "\u00ce");
        entityToChar.put("Iuml", "\u00cf");
        entityToChar.put("ETH", "\u00d0");
        entityToChar.put("Ntilde", "\u00d1");
        entityToChar.put("Ograve", "\u00d2");
        entityToChar.put("Oacute", "\u00d3");
        entityToChar.put("Ocirc", "\u00d4");
        entityToChar.put("Otilde", "\u00d5");
        entityToChar.put("Ouml", "\u00d6");
        entityToChar.put("times", "\u00d7");
        entityToChar.put("Oslash", "\u00d8");
        entityToChar.put("Ugrave", "\u00d9");
        entityToChar.put("Uacute", "\u00da");
        entityToChar.put("Ucirc", "\u00db");
        entityToChar.put("Uuml", "\u00dc");
        entityToChar.put("Yacute", "\u00dd");
        entityToChar.put("THORN", "\u00de");
        entityToChar.put("szlig", "\u00df");
        entityToChar.put("agrave", "\u00e0");
        entityToChar.put("aacute", "\u00e1");
        entityToChar.put("acirc", "\u00e2");
        entityToChar.put("atilde", "\u00e3");
        entityToChar.put("auml", "\u00e4");
        entityToChar.put("aring", "\u00e5");
        entityToChar.put("aelig", "\u00e6");
        entityToChar.put("ccedil", "\u00e7");
        entityToChar.put("egrave", "\u00e8");
        entityToChar.put("eacute", "\u00e9");
        entityToChar.put("ecirc", "\u00ea");
        entityToChar.put("euml", "\u00eb");
        entityToChar.put("igrave", "\u00ec");
        entityToChar.put("iacute", "\u00ed");
        entityToChar.put("icirc", "\u00ee");
        entityToChar.put("iuml", "\u00ef");
        entityToChar.put("eth", "\u00f0");
        entityToChar.put("ntilde", "\u00f1");
        entityToChar.put("ograve", "\u00f2");
        entityToChar.put("oacute", "\u00f3");
        entityToChar.put("ocirc", "\u00f4");
        entityToChar.put("otilde", "\u00f5");
        entityToChar.put("ouml", "\u00f6");
        entityToChar.put("divide", "\u00f7");
        entityToChar.put("oslash", "\u00f8");
        entityToChar.put("ugrave", "\u00f9");
        entityToChar.put("uacute", "\u00fa");
        entityToChar.put("ucirc", "\u00fb");
        entityToChar.put("uuml", "\u00fc");
        entityToChar.put("yacute", "\u00fd");
        entityToChar.put("thorn", "\u00fe");
        entityToChar.put("yuml", "\u00ff");
    }
}

