/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.logging;

import com.nitorcreations.logging.AccessLogServerAdapter;
import com.nitorcreations.willow.messages.AbstractMessage;
import com.nitorcreations.willow.messages.AccessLogEntry;
import com.nitorcreations.willow.messages.WebSocketTransmitter;
import java.net.URISyntaxException;
import java.security.Principal;

public class WillowAccessLogHelper {
    private WebSocketTransmitter transmitter;
    private final long flushInterval;
    private final String url;

    public WillowAccessLogHelper(long flushInterval, String url) throws URISyntaxException {
        this.flushInterval = flushInterval;
        this.url = url;
    }

    public void queue(AccessLogServerAdapter req) {
        if (this.transmitter == null) {
            try {
                this.transmitter = WebSocketTransmitter.getSingleton((long)this.flushInterval, (String)this.url);
                this.transmitter.start();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid logging url", e);
            }
        }
        AccessLogEntry msg = new AccessLogEntry();
        msg.setRemoteAddr(req.getAddress());
        Principal p = req.getPrincipal();
        if (p != null) {
            msg.setAuthentication(p.getName());
        }
        msg.setTimestamp(req.getTimeStamp());
        msg.setMethod(req.getMethod());
        msg.setUri(req.getRequestURI());
        msg.setProtocol(req.getProtocol());
        int status = req.getStatus();
        if (status <= 0) {
            status = 404;
        }
        msg.setStatus(status);
        msg.setResponseLength(req.getResponseLength());
        msg.setDuration(req.getDuration());
        msg.setReferrer(req.getReferer());
        msg.setAgent(req.getUserAgent());
        this.transmitter.queue((AbstractMessage)msg);
    }
}

