/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.operation;

import com.ninja_squad.dbsetup.bind.BinderConfiguration;
import com.ninja_squad.dbsetup.operation.Operation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CompositeOperation
implements Operation {
    private static final Operation NOP = new Operation(){

        @Override
        public void execute(Connection connection, BinderConfiguration configuration) {
        }

        public String toString() {
            return "NOP";
        }
    };
    private final List<Operation> operations;

    private CompositeOperation(List<? extends Operation> operations) {
        this.operations = new ArrayList<Operation>(operations);
    }

    public static Operation sequenceOf(Operation ... operations) {
        return CompositeOperation.sequenceOf(Arrays.asList(operations));
    }

    public static Operation sequenceOf(@Nonnull List<? extends Operation> operations) {
        if (operations.isEmpty()) {
            return NOP;
        }
        if (operations.size() == 1) {
            return operations.get(0);
        }
        return new CompositeOperation(operations);
    }

    @Override
    public void execute(Connection connection, BinderConfiguration configuration) throws SQLException {
        for (Operation operation : this.operations) {
            operation.execute(connection, configuration);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Operation operation : this.operations) {
            if (!first) {
                builder.append('\n');
            } else {
                first = false;
            }
            builder.append(operation);
        }
        return builder.toString();
    }

    public int hashCode() {
        return ((Object)this.operations).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CompositeOperation other = (CompositeOperation)o;
        return ((Object)this.operations).equals(other.operations);
    }
}

