/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.generator;

import com.ninja_squad.dbsetup.generator.ValueGenerator;
import com.ninja_squad.dbsetup.util.Preconditions;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public final class DateSequenceValueGenerator
implements ValueGenerator<Date> {
    private static final int MIN_NUMBER_OF_CHARS_FOR_TIMESTAMP = 19;
    private Calendar next;
    private int increment;
    private CalendarField unit;

    DateSequenceValueGenerator() {
        this(DateSequenceValueGenerator.today(), 1, CalendarField.DAY);
    }

    private DateSequenceValueGenerator(Calendar next, int increment, CalendarField unit) {
        this.next = next;
        this.increment = increment;
        this.unit = unit;
    }

    private static Calendar today() {
        Calendar result = Calendar.getInstance();
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        return result;
    }

    public DateSequenceValueGenerator startingAt(@Nonnull Date startDate, @Nonnull TimeZone timeZone) {
        Preconditions.checkNotNull(startDate, "startDate may not be null");
        Preconditions.checkNotNull(timeZone, "timeZone may not be null");
        this.next = Calendar.getInstance(timeZone);
        this.next.setTime(startDate);
        return this;
    }

    public DateSequenceValueGenerator startingAt(@Nonnull Date startDate) {
        return this.startingAt(startDate, TimeZone.getDefault());
    }

    public DateSequenceValueGenerator startingAt(@Nonnull Calendar startDate) {
        Preconditions.checkNotNull(startDate, "startDate may not be null");
        this.next = (Calendar)startDate.clone();
        return this;
    }

    public DateSequenceValueGenerator startingAt(@Nonnull String startDate) {
        Preconditions.checkNotNull(startDate, "startDate may not be null");
        if (startDate.length() >= 19) {
            return this.startingAt(Timestamp.valueOf(startDate));
        }
        return this.startingAt(java.sql.Date.valueOf(startDate));
    }

    public DateSequenceValueGenerator incrementingBy(int increment, @Nonnull CalendarField unit) {
        Preconditions.checkNotNull((Object)unit, "unit may not be null");
        this.increment = increment;
        this.unit = unit;
        return this;
    }

    @Override
    public Date nextValue() {
        Date result = this.next.getTime();
        this.next.add(this.unit.getField(), this.increment);
        return result;
    }

    public String toString() {
        return "DateSequenceValueGenerator[next=" + this.next + ", increment=" + this.increment + ", unit=" + (Object)((Object)this.unit) + "]";
    }

    public static enum CalendarField {
        YEAR(1),
        MONTH(2),
        DAY(5),
        HOUR(10),
        MINUTE(12),
        SECOND(13),
        MILLISECOND(14);

        private int field;

        private CalendarField(int field) {
            this.field = field;
        }

        private int getField() {
            return this.field;
        }
    }
}

