/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.destination;

import com.ninja_squad.dbsetup.destination.Destination;
import com.ninja_squad.dbsetup.util.Preconditions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DriverManagerDestination
implements Destination {
    private final String url;
    private final String user;
    private final String password;

    public DriverManagerDestination(@Nonnull String url, String user, String password) {
        Preconditions.checkNotNull(url, "url may not be null");
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public static DriverManagerDestination with(@Nonnull String url, String user, String password) {
        return new DriverManagerDestination(url, user, password);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    public String toString() {
        return "DriverManagerDestination [url=" + this.url + ", user=" + this.user + ", password=" + this.password + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.url.hashCode();
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DriverManagerDestination other = (DriverManagerDestination)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (!this.url.equals(other.url)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

