/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup;

import com.ninja_squad.dbsetup.operation.CompositeOperation;
import com.ninja_squad.dbsetup.operation.DeleteAll;
import com.ninja_squad.dbsetup.operation.Insert;
import com.ninja_squad.dbsetup.operation.Operation;
import com.ninja_squad.dbsetup.operation.SqlOperation;
import com.ninja_squad.dbsetup.operation.Truncate;
import java.util.List;
import javax.annotation.Nonnull;

public final class Operations {
    private Operations() {
    }

    public static DeleteAll deleteAllFrom(@Nonnull String table) {
        return DeleteAll.from(table);
    }

    public static Operation deleteAllFrom(String ... tables) {
        return DeleteAll.from(tables);
    }

    public static Operation deleteAllFrom(@Nonnull List<String> tables) {
        return DeleteAll.from(tables);
    }

    public static Truncate truncate(@Nonnull String table) {
        return Truncate.table(table);
    }

    public static Operation truncate(String ... tables) {
        return Truncate.tables(tables);
    }

    public static Operation truncate(@Nonnull List<String> tables) {
        return Truncate.tables(tables);
    }

    public static SqlOperation sql(@Nonnull String sqlStatement) {
        return SqlOperation.of(sqlStatement);
    }

    public static Operation sql(String ... sqlStatements) {
        return SqlOperation.of(sqlStatements);
    }

    public static Operation sql(@Nonnull List<String> sqlStatements) {
        return SqlOperation.of(sqlStatements);
    }

    public static Insert.Builder insertInto(@Nonnull String table) {
        return Insert.into(table);
    }

    public static Operation sequenceOf(Operation ... operations) {
        return CompositeOperation.sequenceOf(operations);
    }

    public static Operation sequenceOf(@Nonnull List<? extends Operation> operations) {
        return CompositeOperation.sequenceOf(operations);
    }
}

