/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.Request;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.ning.http.client.providers.grizzly.StatusHandler;
import com.ning.http.client.uri.Uri;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.ProtocolHandler;

final class HttpTransactionContext {
    private static final Attribute<HttpTransactionContext> REQUEST_STATE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpTransactionContext.class.getName());
    final AtomicInteger redirectCount = new AtomicInteger(0);
    final int maxRedirectCount;
    final boolean redirectsAllowed;
    final GrizzlyAsyncHttpProvider provider;
    final Request request;
    Uri requestUri;
    final AsyncHandler handler;
    private final Connection connection;
    GrizzlyAsyncHttpProvider.BodyHandler bodyHandler;
    StatusHandler statusHandler;
    StatusHandler.InvocationStatus invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
    GrizzlyResponseFuture future;
    HttpResponsePacket responsePacket;
    GrizzlyResponseStatus responseStatus;
    String lastRedirectURI;
    AtomicLong totalBodyWritten = new AtomicLong();
    AsyncHandler.STATE currentState;
    Uri wsRequestURI;
    boolean isWSRequest;
    HandShake handshake;
    ProtocolHandler protocolHandler;
    WebSocket webSocket;
    boolean establishingTunnel;
    private final CloseListener listener = new CloseListener<Closeable, CloseType>(){

        public void onClosed(Closeable closeable, CloseType type) throws IOException {
            if (HttpTransactionContext.this.isGracefullyFinishResponseOnClose()) {
                FilterChain fc = (FilterChain)HttpTransactionContext.this.connection.getProcessor();
                fc.fireEventUpstream(HttpTransactionContext.this.connection, (FilterChainEvent)new GrizzlyAsyncHttpProvider.GracefulCloseEvent(HttpTransactionContext.this), null);
            } else if (CloseType.REMOTELY.equals((Object)type)) {
                HttpTransactionContext.this.abort(AsyncHttpProviderUtils.REMOTELY_CLOSED_EXCEPTION);
            }
        }
    };

    private static void set(Connection c, HttpTransactionContext httpTxContext) {
        c.addCloseListener(httpTxContext.listener);
        REQUEST_STATE_ATTR.set((AttributeStorage)c, (Object)httpTxContext);
    }

    static HttpTransactionContext cleanupTransaction(Connection c) {
        HttpTransactionContext httpTxContext = (HttpTransactionContext)REQUEST_STATE_ATTR.remove((AttributeStorage)c);
        c.removeCloseListener(httpTxContext.listener);
        return httpTxContext;
    }

    static HttpTransactionContext currentTransaction(Connection c) {
        return (HttpTransactionContext)REQUEST_STATE_ATTR.get((AttributeStorage)c);
    }

    public static HttpTransactionContext startTransaction(Connection connection, GrizzlyAsyncHttpProvider provider, GrizzlyResponseFuture future, Request request, AsyncHandler handler) {
        HttpTransactionContext ctx = new HttpTransactionContext(provider, connection, future, request, handler);
        HttpTransactionContext.set(connection, ctx);
        return ctx;
    }

    private HttpTransactionContext(GrizzlyAsyncHttpProvider provider, Connection connection, GrizzlyResponseFuture future, Request request, AsyncHandler handler) {
        this.provider = provider;
        this.connection = connection;
        this.future = future;
        this.request = request;
        this.handler = handler;
        this.redirectsAllowed = provider.getClientConfig().isFollowRedirect();
        this.maxRedirectCount = provider.getClientConfig().getMaxRedirects();
        this.requestUri = request.getUri();
    }

    HttpTransactionContext cloneAndStartTransactionFor(Connection connection) {
        HttpTransactionContext newContext = HttpTransactionContext.startTransaction(connection, this.provider, this.future, this.request, this.handler);
        newContext.invocationStatus = this.invocationStatus;
        newContext.bodyHandler = this.bodyHandler;
        newContext.currentState = this.currentState;
        newContext.statusHandler = this.statusHandler;
        newContext.lastRedirectURI = this.lastRedirectURI;
        newContext.redirectCount.set(this.redirectCount.get());
        return newContext;
    }

    HttpTransactionContext cloneAndStartTransactionFor(Connection connection, Request request) {
        HttpTransactionContext newContext = HttpTransactionContext.startTransaction(connection, this.provider, this.future, request, this.handler);
        newContext.invocationStatus = this.invocationStatus;
        newContext.bodyHandler = this.bodyHandler;
        newContext.currentState = this.currentState;
        newContext.statusHandler = this.statusHandler;
        newContext.lastRedirectURI = this.lastRedirectURI;
        newContext.redirectCount.set(this.redirectCount.get());
        return newContext;
    }

    boolean isGracefullyFinishResponseOnClose() {
        HttpResponsePacket response = this.responsePacket;
        return response != null && !response.getProcessingState().isKeepAlive() && !response.isChunked() && response.getContentLength() == -1L;
    }

    void abort(Throwable t) {
        if (this.future != null) {
            this.future.abort(t);
        }
    }

    void done() {
        this.done(null);
    }

    void done(Object result) {
        if (this.future != null) {
            this.future.done(result);
        }
    }

    boolean isTunnelEstablished(Connection c) {
        return c.getAttributes().getAttribute("tunnel-established") != null;
    }

    void tunnelEstablished(Connection c) {
        c.getAttributes().setAttribute("tunnel-established", (Object)Boolean.TRUE);
    }
}

