/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.channel.pool;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.channel.pool.ChannelPool;
import com.ning.http.client.providers.netty.channel.pool.ChannelPoolPartitionSelector;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.util.DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultChannelPool
implements ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultChannelPool.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<IdleChannel>> partitions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ChannelCreation> channelId2Creation = new ConcurrentHashMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Timer nettyTimer;
    private final boolean sslConnectionPoolEnabled;
    private final int maxConnectionTTL;
    private final boolean maxConnectionTTLDisabled;
    private final long maxIdleTime;
    private final boolean maxIdleTimeDisabled;
    private final long cleanerPeriod;

    public DefaultChannelPool(AsyncHttpClientConfig config, Timer hashedWheelTimer) {
        this(config.getPooledConnectionIdleTimeout(), config.getConnectionTTL(), config.isAllowPoolingSslConnections(), hashedWheelTimer);
    }

    public DefaultChannelPool(long maxIdleTime, int maxConnectionTTL, boolean sslConnectionPoolEnabled, Timer nettyTimer) {
        this.sslConnectionPoolEnabled = sslConnectionPoolEnabled;
        this.maxIdleTime = maxIdleTime;
        this.maxConnectionTTL = maxConnectionTTL;
        this.maxConnectionTTLDisabled = maxConnectionTTL <= 0;
        this.nettyTimer = nettyTimer;
        this.maxIdleTimeDisabled = maxIdleTime <= 0L;
        this.cleanerPeriod = Math.min(this.maxConnectionTTLDisabled ? Long.MAX_VALUE : (long)maxConnectionTTL, this.maxIdleTimeDisabled ? Long.MAX_VALUE : maxIdleTime);
        if (!this.maxConnectionTTLDisabled || !this.maxIdleTimeDisabled) {
            this.scheduleNewIdleChannelDetector(new IdleChannelDetector());
        }
    }

    private void scheduleNewIdleChannelDetector(TimerTask task) {
        this.nettyTimer.newTimeout(task, this.cleanerPeriod, TimeUnit.MILLISECONDS);
    }

    private boolean isTTLExpired(Channel channel, long now) {
        if (this.maxConnectionTTLDisabled) {
            return false;
        }
        ChannelCreation creation = this.channelId2Creation.get(channel.getId());
        return creation != null && now - creation.creationTime >= (long)this.maxConnectionTTL;
    }

    private ConcurrentLinkedQueue<IdleChannel> getPartition(String partitionId) {
        ConcurrentLinkedQueue newPartition;
        ConcurrentLinkedQueue<IdleChannel> partition = this.partitions.get(partitionId);
        if (partition == null && (partition = this.partitions.putIfAbsent(partitionId, newPartition = new ConcurrentLinkedQueue())) == null) {
            partition = newPartition;
        }
        return partition;
    }

    @Override
    public boolean offer(Channel channel, String partition) {
        if (this.isClosed.get() || !this.sslConnectionPoolEnabled && channel.getPipeline().get(SslHandler.class) != null) {
            return false;
        }
        long now = DateUtils.millisTime();
        if (this.isTTLExpired(channel, now)) {
            return false;
        }
        boolean added = this.getPartition(partition).add(new IdleChannel(channel, now));
        if (added) {
            this.channelId2Creation.putIfAbsent(channel.getId(), new ChannelCreation(now, partition));
        }
        return added;
    }

    @Override
    public Channel poll(String partitionId) {
        IdleChannel idleChannel = null;
        ConcurrentLinkedQueue<IdleChannel> partition = this.partitions.get(partitionId);
        if (partition != null) {
            while (idleChannel == null && (idleChannel = partition.poll()) != null) {
                if (Channels.isChannelValid(idleChannel.channel)) continue;
                idleChannel = null;
                LOGGER.trace("Channel not connected or not opened, probably remotely closed!");
            }
        }
        return idleChannel != null ? idleChannel.channel : null;
    }

    @Override
    public boolean removeAll(Channel channel) {
        ChannelCreation creation = this.channelId2Creation.remove(channel.getId());
        return !this.isClosed.get() && creation != null && this.partitions.get(creation.poolKey).remove(channel);
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed.get();
    }

    @Override
    public void destroy() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        for (ConcurrentLinkedQueue<IdleChannel> partition : this.partitions.values()) {
            for (IdleChannel idleChannel : partition) {
                this.close(idleChannel.channel);
            }
        }
        this.partitions.clear();
        this.channelId2Creation.clear();
    }

    private void close(Channel channel) {
        Channels.setDiscard(channel);
        this.channelId2Creation.remove(channel.getId());
        Channels.silentlyCloseChannel(channel);
    }

    private void flushPartition(String partitionId, ConcurrentLinkedQueue<IdleChannel> partition) {
        if (partition != null) {
            this.partitions.remove(partitionId);
            for (IdleChannel idleChannel : partition) {
                this.close(idleChannel.channel);
            }
        }
    }

    @Override
    public void flushPartition(String partitionId) {
        this.flushPartition(partitionId, this.partitions.get(partitionId));
    }

    @Override
    public void flushPartitions(ChannelPoolPartitionSelector selector) {
        for (Map.Entry<String, ConcurrentLinkedQueue<IdleChannel>> partitionsEntry : this.partitions.entrySet()) {
            String partitionId = partitionsEntry.getKey();
            if (!selector.select(partitionId)) continue;
            this.flushPartition(partitionId, partitionsEntry.getValue());
        }
    }

    private final class IdleChannelDetector
    implements TimerTask {
        private IdleChannelDetector() {
        }

        private boolean isIdleTimeoutExpired(IdleChannel idleChannel, long now) {
            return !DefaultChannelPool.this.maxIdleTimeDisabled && now - idleChannel.start >= DefaultChannelPool.this.maxIdleTime;
        }

        private List<IdleChannel> expiredChannels(ConcurrentLinkedQueue<IdleChannel> partition, long now) {
            List<IdleChannel> idleTimeoutChannels = null;
            for (IdleChannel idleChannel : partition) {
                if (!DefaultChannelPool.this.isTTLExpired(idleChannel.channel, now) && !this.isIdleTimeoutExpired(idleChannel, now) && Channels.isChannelValid(idleChannel.channel)) continue;
                LOGGER.debug("Adding Candidate expired Channel {}", (Object)idleChannel.channel);
                if (idleTimeoutChannels == null) {
                    idleTimeoutChannels = new ArrayList<IdleChannel>();
                }
                idleTimeoutChannels.add(idleChannel);
            }
            return idleTimeoutChannels != null ? idleTimeoutChannels : Collections.emptyList();
        }

        private boolean isChannelCloseable(Channel channel) {
            NettyResponseFuture future;
            Object attribute = Channels.getAttribute(channel);
            if (attribute instanceof NettyResponseFuture && !(future = (NettyResponseFuture)attribute).isDone()) {
                LOGGER.error("Future not in appropriate state %s, not closing", (Object)future);
                return false;
            }
            return true;
        }

        private final List<IdleChannel> closeChannels(List<IdleChannel> candidates) {
            List<IdleChannel> closedChannels = null;
            for (int i = 0; i < candidates.size(); ++i) {
                IdleChannel idleChannel = candidates.get(i);
                if (this.isChannelCloseable(idleChannel.channel)) {
                    LOGGER.debug("Closing Idle Channel {}", (Object)idleChannel.channel);
                    DefaultChannelPool.this.close(idleChannel.channel);
                    if (closedChannels == null) continue;
                    closedChannels.add(idleChannel);
                    continue;
                }
                if (closedChannels != null) continue;
                closedChannels = new ArrayList<IdleChannel>(candidates.size());
                for (int j = 0; j < i; ++j) {
                    closedChannels.add(candidates.get(j));
                }
            }
            return closedChannels != null ? closedChannels : candidates;
        }

        public void run(Timeout timeout) throws Exception {
            if (DefaultChannelPool.this.isClosed.get()) {
                return;
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    for (String key : DefaultChannelPool.this.partitions.keySet()) {
                        LOGGER.debug("Entry count for : {} : {}", (Object)key, (Object)((ConcurrentLinkedQueue)DefaultChannelPool.this.partitions.get(key)).size());
                    }
                }
                long start = DateUtils.millisTime();
                int closedCount = 0;
                int totalCount = 0;
                for (ConcurrentLinkedQueue partition : DefaultChannelPool.this.partitions.values()) {
                    List<IdleChannel> closedChannels;
                    if (LOGGER.isDebugEnabled()) {
                        totalCount += partition.size();
                    }
                    if ((closedChannels = this.closeChannels(this.expiredChannels(partition, start))).isEmpty()) continue;
                    for (IdleChannel closedChannel : closedChannels) {
                        DefaultChannelPool.this.channelId2Creation.remove(closedChannel.channel.getId());
                    }
                    partition.removeAll(closedChannels);
                    closedCount += closedChannels.size();
                }
                long duration = DateUtils.millisTime() - start;
                LOGGER.debug("Closed {} connections out of {} in {}ms", new Object[]{closedCount, totalCount, duration});
            }
            catch (Throwable t) {
                LOGGER.error("uncaught exception!", t);
            }
            DefaultChannelPool.this.scheduleNewIdleChannelDetector(timeout.getTask());
        }
    }

    private static final class IdleChannel {
        final Channel channel;
        final long start;

        IdleChannel(Channel channel, long start) {
            if (channel == null) {
                throw new NullPointerException("channel");
            }
            this.channel = channel;
            this.start = start;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IdleChannel && this.channel.equals(((IdleChannel)IdleChannel.class.cast((Object)o)).channel);
        }

        public int hashCode() {
            return this.channel.hashCode();
        }
    }

    private static final class ChannelCreation {
        final long creationTime;
        final String poolKey;

        ChannelCreation(long creationTime, String poolKey) {
            this.creationTime = creationTime;
            this.poolKey = poolKey;
        }
    }
}

