/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.uri;

import com.ning.http.client.uri.UriParser;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class Uri {
    private final String scheme;
    private final String userInfo;
    private final String host;
    private final int port;
    private final String query;
    private final String path;
    private String url;

    public static Uri create(String originalUrl) {
        return Uri.create(null, originalUrl);
    }

    public static Uri create(Uri context, String originalUrl) {
        UriParser parser = new UriParser();
        parser.parse(context, originalUrl);
        return new Uri(parser.scheme, parser.userInfo, parser.host, parser.port, parser.path, parser.query);
    }

    public Uri(String scheme, String userInfo, String host, int port, String path, String query) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public URI toJavaNetURI() throws URISyntaxException {
        return new URI(this.toUrl());
    }

    public String toUrl() {
        if (this.url == null) {
            StringBuilder sb = StringUtils.stringBuilder();
            sb.append(this.scheme).append("://");
            if (this.userInfo != null) {
                sb.append(this.userInfo).append('@');
            }
            sb.append(this.host);
            if (this.port != -1) {
                sb.append(':').append(this.port);
            }
            if (this.path != null) {
                sb.append(this.path);
            }
            if (this.query != null) {
                sb.append('?').append(this.query);
            }
            this.url = sb.toString();
        }
        return this.url;
    }

    public String toRelativeUrl() {
        StringBuilder sb = StringUtils.stringBuilder();
        if (MiscUtils.isNonEmpty(this.path)) {
            sb.append(this.path);
        } else {
            sb.append('/');
        }
        if (this.query != null) {
            sb.append('?').append(this.query);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toUrl();
    }

    public Uri withNewScheme(String newScheme) {
        return new Uri(newScheme, this.userInfo, this.host, this.port, this.path, this.query);
    }

    public Uri withNewQuery(String newQuery) {
        return new Uri(this.scheme, this.userInfo, this.host, this.port, this.path, newQuery);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Uri other = (Uri)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.userInfo == null ? other.userInfo != null : !this.userInfo.equals(other.userInfo));
    }
}

