/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.channel;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ConnectionPoolPartitioning;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.providers.netty.Callback;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.channel.CleanupChannelGroup;
import com.ning.http.client.providers.netty.channel.SslInitializer;
import com.ning.http.client.providers.netty.channel.pool.ChannelPool;
import com.ning.http.client.providers.netty.channel.pool.ChannelPoolPartitionSelector;
import com.ning.http.client.providers.netty.channel.pool.DefaultChannelPool;
import com.ning.http.client.providers.netty.channel.pool.NoopChannelPool;
import com.ning.http.client.providers.netty.chmv8.ConcurrentHashMapV8;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.handler.HttpProtocol;
import com.ning.http.client.providers.netty.handler.Processor;
import com.ning.http.client.providers.netty.handler.WebSocketProtocol;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.ning.http.client.providers.netty.util.HttpUtils;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    public static final String HTTP_HANDLER = "httpHandler";
    public static final String SSL_HANDLER = "sslHandler";
    public static final String HTTP_PROCESSOR = "httpProcessor";
    public static final String WS_PROCESSOR = "wsProcessor";
    public static final String DEFLATER_HANDLER = "deflater";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunkedWriter";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    private final AsyncHttpClientConfig config;
    private final NettyAsyncHttpProviderConfig nettyConfig;
    private final SSLEngineFactory sslEngineFactory;
    private final ChannelPool channelPool;
    private final boolean maxTotalConnectionsEnabled;
    private final Semaphore freeChannels;
    private final ChannelGroup openChannels;
    private final boolean maxConnectionsPerHostEnabled;
    private final ConcurrentHashMapV8<Object, Semaphore> freeChannelsPerHost;
    private final ConcurrentHashMapV8<Integer, Object> channelId2PartitionKey;
    private final ConcurrentHashMapV8.Fun<Object, Semaphore> semaphoreComputer;
    private final long handshakeTimeout;
    private final Timer nettyTimer;
    private final IOException tooManyConnections;
    private final IOException tooManyConnectionsPerHost;
    private final IOException poolAlreadyClosed;
    private final ClientSocketChannelFactory socketChannelFactory;
    private final boolean allowReleaseSocketChannelFactory;
    private final ClientBootstrap plainBootstrap;
    private final ClientBootstrap secureBootstrap;
    private final ClientBootstrap webSocketBootstrap;
    private final ClientBootstrap secureWebSocketBootstrap;
    private Processor wsProcessor;

    public ChannelManager(final AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, Timer nettyTimer) {
        this.config = config;
        this.nettyConfig = nettyConfig;
        this.nettyTimer = nettyTimer;
        this.sslEngineFactory = nettyConfig.getSslEngineFactory() != null ? nettyConfig.getSslEngineFactory() : new SSLEngineFactory.DefaultSSLEngineFactory(config);
        ChannelPool channelPool = nettyConfig.getChannelPool();
        if (channelPool == null && config.isAllowPoolingConnections()) {
            channelPool = new DefaultChannelPool(config, nettyTimer);
        } else if (channelPool == null) {
            channelPool = new NoopChannelPool();
        }
        this.channelPool = channelPool;
        this.tooManyConnections = MiscUtils.buildStaticIOException(String.format("Too many connections %s", config.getMaxConnections()));
        this.tooManyConnectionsPerHost = MiscUtils.buildStaticIOException(String.format("Too many connections per host %s", config.getMaxConnectionsPerHost()));
        this.poolAlreadyClosed = MiscUtils.buildStaticIOException("Pool is already closed");
        this.maxTotalConnectionsEnabled = config.getMaxConnections() > 0;
        boolean bl = this.maxConnectionsPerHostEnabled = config.getMaxConnectionsPerHost() > 0;
        if (this.maxTotalConnectionsEnabled) {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient"){

                public boolean remove(Object o) {
                    boolean removed = super.remove(o);
                    if (removed) {
                        Semaphore freeChannelsForHost;
                        Object partitionKey;
                        ChannelManager.this.freeChannels.release();
                        if (ChannelManager.this.maxConnectionsPerHostEnabled && (partitionKey = ChannelManager.this.channelId2PartitionKey.remove(((Channel)Channel.class.cast(o)).getId())) != null && (freeChannelsForHost = (Semaphore)ChannelManager.this.freeChannelsPerHost.get(partitionKey)) != null) {
                            freeChannelsForHost.release();
                        }
                    }
                    return removed;
                }
            };
            this.freeChannels = new Semaphore(config.getMaxConnections());
        } else {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient");
            this.freeChannels = null;
        }
        if (this.maxConnectionsPerHostEnabled) {
            this.freeChannelsPerHost = new ConcurrentHashMapV8();
            this.channelId2PartitionKey = new ConcurrentHashMapV8();
            this.semaphoreComputer = new ConcurrentHashMapV8.Fun<Object, Semaphore>(){

                @Override
                public Semaphore apply(Object partitionKey) {
                    return new Semaphore(config.getMaxConnectionsPerHost());
                }
            };
        } else {
            this.freeChannelsPerHost = null;
            this.channelId2PartitionKey = null;
            this.semaphoreComputer = null;
        }
        this.handshakeTimeout = nettyConfig.getHandshakeTimeout();
        if (nettyConfig.getSocketChannelFactory() != null) {
            this.socketChannelFactory = nettyConfig.getSocketChannelFactory();
            this.allowReleaseSocketChannelFactory = false;
        } else {
            ExecutorService e = nettyConfig.getBossExecutorService();
            if (e == null) {
                e = Executors.newCachedThreadPool();
            }
            int numWorkers = config.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
            LOGGER.trace("Number of application's worker threads is {}", (Object)numWorkers);
            this.socketChannelFactory = new NioClientSocketChannelFactory((Executor)e, (Executor)config.executorService(), numWorkers);
            this.allowReleaseSocketChannelFactory = true;
        }
        this.plainBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.webSocketBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureWebSocketBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        DefaultChannelFuture.setUseDeadLockChecker((boolean)nettyConfig.isUseDeadLockChecker());
        if (config.getConnectTimeout() > 0) {
            nettyConfig.addProperty("connectTimeoutMillis", (Object)config.getConnectTimeout());
        }
        for (Map.Entry<String, Object> entry : nettyConfig.propertiesSet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.plainBootstrap.setOption(key, value);
            this.webSocketBootstrap.setOption(key, value);
            this.secureBootstrap.setOption(key, value);
            this.secureWebSocketBootstrap.setOption(key, value);
        }
    }

    public void configureBootstraps(NettyRequestSender requestSender, AtomicBoolean closed) {
        HttpProtocol httpProtocol = new HttpProtocol(this, this.config, this.nettyConfig, requestSender);
        final Processor httpProcessor = new Processor(this.config, this, requestSender, httpProtocol);
        WebSocketProtocol wsProtocol = new WebSocketProtocol(this, this.config, this.nettyConfig, requestSender);
        this.wsProcessor = new Processor(this.config, this, requestSender, wsProtocol);
        this.plainBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec());
                pipeline.addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor());
                pipeline.addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast(ChannelManager.HTTP_PROCESSOR, (ChannelHandler)httpProcessor);
                if (ChannelManager.this.nettyConfig.getHttpAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.nettyConfig.getHttpAdditionalPipelineInitializer().initPipeline(pipeline);
                }
                return pipeline;
            }
        });
        this.webSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec());
                pipeline.addLast(ChannelManager.WS_PROCESSOR, (ChannelHandler)ChannelManager.this.wsProcessor);
                if (ChannelManager.this.nettyConfig.getWsAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.nettyConfig.getWsAdditionalPipelineInitializer().initPipeline(pipeline);
                }
                return pipeline;
            }
        });
        this.secureBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(ChannelManager.SSL_HANDLER, (ChannelHandler)new SslInitializer(ChannelManager.this));
                pipeline.addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec());
                pipeline.addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor());
                pipeline.addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast(ChannelManager.HTTP_PROCESSOR, (ChannelHandler)httpProcessor);
                if (ChannelManager.this.nettyConfig.getHttpsAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.nettyConfig.getHttpsAdditionalPipelineInitializer().initPipeline(pipeline);
                }
                return pipeline;
            }
        });
        this.secureWebSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(ChannelManager.SSL_HANDLER, (ChannelHandler)new SslInitializer(ChannelManager.this));
                pipeline.addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec());
                pipeline.addLast(ChannelManager.WS_PROCESSOR, (ChannelHandler)ChannelManager.this.wsProcessor);
                if (ChannelManager.this.nettyConfig.getWssAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.nettyConfig.getWssAdditionalPipelineInitializer().initPipeline(pipeline);
                }
                return pipeline;
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.nettyConfig.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                protected String getTargetContentEncoding(String contentEncoding) throws Exception {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, boolean keepAlive, Object partitionKey) {
        if (channel.isConnected() && keepAlive && channel.isReadable()) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            this.channelPool.offer(channel, partitionKey);
            if (this.maxConnectionsPerHostEnabled) {
                this.channelId2PartitionKey.putIfAbsent(channel.getId(), partitionKey);
            }
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(Uri uri, ProxyServer proxy, ConnectionPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public boolean removeAll(Channel connection) {
        return this.channelPool.removeAll(connection);
    }

    private boolean tryAcquireGlobal() {
        return !this.maxTotalConnectionsEnabled || this.freeChannels.tryAcquire();
    }

    private Semaphore getFreeConnectionsForHost(Object partitionKey) {
        return this.freeChannelsPerHost.computeIfAbsent(partitionKey, this.semaphoreComputer);
    }

    private boolean tryAcquirePerHost(Object partitionKey) {
        return !this.maxConnectionsPerHostEnabled || this.getFreeConnectionsForHost(partitionKey).tryAcquire();
    }

    public void preemptChannel(Object partitionKey) throws IOException {
        if (!this.channelPool.isOpen()) {
            throw this.poolAlreadyClosed;
        }
        if (!this.tryAcquireGlobal()) {
            throw this.tooManyConnections;
        }
        if (!this.tryAcquirePerHost(partitionKey)) {
            if (this.maxTotalConnectionsEnabled) {
                this.freeChannels.release();
            }
            throw this.tooManyConnectionsPerHost;
        }
    }

    public void close() {
        this.channelPool.destroy();
        this.openChannels.close();
        for (Channel channel : this.openChannels) {
            Object attribute = Channels.getAttribute(channel);
            if (!(attribute instanceof NettyResponseFuture)) continue;
            NettyResponseFuture future = (NettyResponseFuture)attribute;
            future.cancelTimeouts();
        }
        this.config.executorService().shutdown();
        if (this.allowReleaseSocketChannelFactory) {
            this.socketChannelFactory.releaseExternalResources();
            this.plainBootstrap.releaseExternalResources();
            this.secureBootstrap.releaseExternalResources();
            this.webSocketBootstrap.releaseExternalResources();
            this.secureWebSocketBootstrap.releaseExternalResources();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        try {
            this.removeAll(channel);
            Channels.setDiscard(channel);
            Channels.silentlyCloseChannel(channel);
        }
        catch (Throwable t) {
            LOGGER.debug("Error closing a connection", t);
        }
        this.openChannels.remove((Object)channel);
    }

    public void abortChannelPreemption(Object partitionKey) {
        if (this.maxTotalConnectionsEnabled) {
            this.freeChannels.release();
        }
        if (this.maxConnectionsPerHostEnabled) {
            this.getFreeConnectionsForHost(partitionKey).release();
        }
    }

    public void registerOpenChannel(Channel channel, Object partitionKey) {
        this.openChannels.add((Object)channel);
        if (this.maxConnectionsPerHostEnabled) {
            this.channelId2PartitionKey.put(channel.getId(), partitionKey);
        }
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.nettyConfig.getHttpClientCodecMaxInitialLineLength(), this.nettyConfig.getHttpClientCodecMaxHeaderSize(), this.nettyConfig.getHttpClientCodecMaxChunkSize());
    }

    public SslHandler createSslHandler(String peerHost, int peerPort) throws GeneralSecurityException, IOException {
        SSLEngine sslEngine = this.sslEngineFactory.newSSLEngine(peerHost, peerPort);
        SslHandler sslHandler = this.handshakeTimeout > 0L ? new SslHandler(sslEngine, SslHandler.getDefaultBufferPool(), false, this.nettyTimer, this.handshakeTimeout) : new SslHandler(sslEngine);
        sslHandler.setCloseOnSSLException(true);
        return sslHandler;
    }

    public static SslHandler getSslHandler(ChannelPipeline pipeline) {
        return (SslHandler)pipeline.get(SSL_HANDLER);
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    public void upgradeProtocol(ChannelPipeline pipeline, String scheme, String host, int port) throws IOException, GeneralSecurityException {
        if (pipeline.get(HTTP_HANDLER) != null) {
            pipeline.remove(HTTP_HANDLER);
        }
        if (HttpUtils.isSecure(scheme)) {
            if (ChannelManager.isSslHandlerConfigured(pipeline)) {
                pipeline.addAfter(SSL_HANDLER, HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
            } else {
                pipeline.addFirst(HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
                pipeline.addFirst(SSL_HANDLER, (ChannelHandler)this.createSslHandler(host, port));
            }
        } else {
            pipeline.addFirst(HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
        }
        if (HttpUtils.isWebSocket(scheme)) {
            pipeline.addAfter(HTTP_PROCESSOR, WS_PROCESSOR, (ChannelHandler)this.wsProcessor);
            pipeline.remove(HTTP_PROCESSOR);
        }
    }

    public void verifyChannelPipeline(ChannelPipeline pipeline, String scheme) throws IOException, GeneralSecurityException {
        boolean sslHandlerConfigured = ChannelManager.isSslHandlerConfigured(pipeline);
        if (HttpUtils.isSecure(scheme)) {
            if (!sslHandlerConfigured) {
                pipeline.addFirst(SSL_HANDLER, (ChannelHandler)new SslInitializer(this));
            }
        } else if (sslHandlerConfigured) {
            pipeline.remove(SSL_HANDLER);
        }
    }

    public ClientBootstrap getBootstrap(String scheme, boolean useProxy, boolean useSSl) {
        return scheme.startsWith("ws") && !useProxy ? (useSSl ? this.secureWebSocketBootstrap : this.webSocketBootstrap) : (useSSl ? this.secureBootstrap : this.plainBootstrap);
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_HANDLER, WS_ENCODER_HANDLER, (ChannelHandler)new WebSocket08FrameEncoder(true));
        pipeline.remove(HTTP_HANDLER);
        pipeline.addBefore(WS_PROCESSOR, WS_DECODER_HANDLER, (ChannelHandler)new WebSocket08FrameDecoder(false, false, (long)this.nettyConfig.getWebSocketMaxFrameSize()));
        pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, (ChannelHandler)new WebSocketFrameAggregator(this.nettyConfig.getWebSocketMaxBufferSize()));
    }

    public final Callback newDrainCallback(NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final Object partitionKey) {
        return new Callback(future){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, keepAlive, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future) {
        this.drainChannelAndOffer(channel, future, future.isKeepAlive(), future.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future, boolean keepAlive, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future, channel, keepAlive, partitionKey));
    }

    public void flushPartition(String partitionId) {
        this.channelPool.flushPartition(partitionId);
    }

    public void flushPartitions(ChannelPoolPartitionSelector selector) {
        this.channelPool.flushPartitions(selector);
    }
}

