/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieUtil;
import java.nio.CharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieDecoder.class);

    public static Cookie decode(String header) {
        char c;
        if (header == null) {
            throw new NullPointerException("header");
        }
        int headerLen = header.length();
        if (headerLen == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int i = 0;
        while (i != headerLen && (c = header.charAt(i)) != ',') {
            int valueEnd;
            int valueBegin;
            int nameEnd;
            int nameBegin;
            block15: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                nameEnd = i;
                valueBegin = -1;
                valueEnd = -1;
                if (i != headerLen) {
                    do {
                        char curChar;
                        if ((curChar = header.charAt(i)) == ';') {
                            nameEnd = i;
                            valueEnd = -1;
                            valueBegin = -1;
                        } else {
                            if (curChar != '=') continue;
                            nameEnd = i++;
                            if (i == headerLen) {
                                valueEnd = 0;
                                valueBegin = 0;
                            } else {
                                valueBegin = i;
                                int semiPos = header.indexOf(59, i);
                                i = semiPos > 0 ? semiPos : headerLen;
                                valueEnd = i;
                            }
                        }
                        break block15;
                    } while (++i != headerLen);
                    nameEnd = headerLen;
                    valueEnd = -1;
                    valueBegin = -1;
                }
            }
            if (valueEnd > 0 && header.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (cookieBuilder == null) {
                if (nameBegin == -1 || nameBegin == nameEnd) {
                    LOGGER.debug("Skipping cookie with null name");
                    return null;
                }
                if (valueBegin == -1) {
                    LOGGER.debug("Skipping cookie with null value");
                    return null;
                }
                CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
                CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
                if (unwrappedValue == null) {
                    LOGGER.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)unwrappedValue);
                    return null;
                }
                String name = header.substring(nameBegin, nameEnd);
                boolean wrap = unwrappedValue.length() != valueEnd - valueBegin;
                cookieBuilder = new CookieBuilder(header, name, unwrappedValue.toString(), wrap);
                continue;
            }
            cookieBuilder.appendAttribute(header, nameBegin, nameEnd, valueBegin, valueEnd);
        }
        return cookieBuilder.cookie();
    }

    private static class CookieBuilder {
        private static final String PATH = "Path";
        private static final String EXPIRES = "Expires";
        private static final String MAX_AGE = "Max-Age";
        private static final String DOMAIN = "Domain";
        private static final String SECURE = "Secure";
        private static final String HTTPONLY = "HTTPOnly";
        private final String header;
        private final String name;
        private final String value;
        private final boolean wrap;
        private String domain;
        private String path;
        private long maxAge = Long.MIN_VALUE;
        private int expiresStart;
        private int expiresEnd;
        private boolean secure;
        private boolean httpOnly;

        public CookieBuilder(String header, String name, String value, boolean wrap) {
            this.header = header;
            this.name = name;
            this.value = value;
            this.wrap = wrap;
        }

        public Cookie cookie() {
            return new Cookie(this.name, this.value, this.wrap, this.domain, this.path, this.mergeMaxAgeAndExpires(), this.secure, this.httpOnly);
        }

        private long mergeMaxAgeAndExpires() {
            if (this.maxAge != Long.MIN_VALUE) {
                return this.maxAge;
            }
            String expires = this.computeValue(this.expiresStart, this.expiresEnd);
            if (expires != null) {
                return CookieUtil.computeExpiresAsMaxAge(expires);
            }
            return Long.MIN_VALUE;
        }

        public void appendAttribute(String header, int keyStart, int keyEnd, int valueBegin, int valueEnd) {
            this.setCookieAttribute(keyStart, keyEnd, valueBegin, valueEnd);
        }

        private void setCookieAttribute(int keyStart, int keyEnd, int valueBegin, int valueEnd) {
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(keyStart, valueBegin, valueEnd);
            } else if (length == 6) {
                this.parse6(keyStart, valueBegin, valueEnd);
            } else if (length == 7) {
                this.parse7(keyStart, valueBegin, valueEnd);
            } else if (length == 8) {
                this.parse8(keyStart, valueBegin, valueEnd);
            }
        }

        private void parse4(int nameStart, int valueBegin, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, PATH, 0, 4)) {
                this.path = this.computeValue(valueBegin, valueEnd);
            }
        }

        private void parse6(int nameStart, int valueBegin, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, DOMAIN, 0, 5)) {
                this.domain = this.computeValue(valueBegin, valueEnd);
            } else if (this.header.regionMatches(true, nameStart, SECURE, 0, 5)) {
                this.secure = true;
            }
        }

        private void parse7(int nameStart, int valueBegin, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, EXPIRES, 0, 7)) {
                this.expiresStart = valueBegin;
                this.expiresEnd = valueEnd;
            } else if (this.header.regionMatches(true, nameStart, MAX_AGE, 0, 7)) {
                try {
                    this.maxAge = Math.max(Integer.valueOf(this.computeValue(valueBegin, valueEnd)), 0);
                }
                catch (NumberFormatException e1) {
                    // empty catch block
                }
            }
        }

        private void parse8(int nameStart, int valueBegin, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, HTTPONLY, 0, 8)) {
                this.httpOnly = true;
            }
        }

        private String computeValue(int valueBegin, int valueEnd) {
            if (valueBegin == -1 || valueBegin == valueEnd) {
                return null;
            }
            while (valueBegin < valueEnd && this.header.charAt(valueBegin) <= ' ') {
                ++valueBegin;
            }
            while (valueBegin < valueEnd && this.header.charAt(valueEnd - 1) <= ' ') {
                --valueEnd;
            }
            return valueBegin == valueEnd ? null : this.header.substring(valueBegin, valueEnd);
        }
    }
}

