/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieUtil;
import java.nio.CharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieDecoder.class);

    public static Cookie decode(String header) {
        char c;
        if (header == null) {
            throw new NullPointerException("header");
        }
        int headerLen = header.length();
        if (headerLen == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int i = 0;
        while (i != headerLen && (c = header.charAt(i)) != ',') {
            int valueEnd;
            int valueBegin;
            int nameEnd;
            int nameBegin;
            block15: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                nameEnd = i;
                valueBegin = -1;
                valueEnd = -1;
                if (i != headerLen) {
                    do {
                        char curChar;
                        if ((curChar = header.charAt(i)) == ';') {
                            nameEnd = i;
                            valueEnd = -1;
                            valueBegin = -1;
                        } else {
                            if (curChar != '=') continue;
                            nameEnd = i++;
                            if (i == headerLen) {
                                valueEnd = 0;
                                valueBegin = 0;
                            } else {
                                valueBegin = i;
                                int semiPos = header.indexOf(59, i);
                                i = semiPos > 0 ? semiPos : headerLen;
                                valueEnd = i;
                            }
                        }
                        break block15;
                    } while (++i != headerLen);
                    nameEnd = headerLen;
                    valueEnd = -1;
                    valueBegin = -1;
                }
            }
            if (valueEnd > 0 && header.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (cookieBuilder == null) {
                if (nameBegin == -1 || nameBegin == nameEnd) {
                    LOGGER.debug("Skipping cookie with null name");
                    return null;
                }
                if (valueBegin == -1) {
                    LOGGER.debug("Skipping cookie with null value");
                    return null;
                }
                CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
                CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
                if (unwrappedValue == null) {
                    LOGGER.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)unwrappedValue);
                    return null;
                }
                String name = header.substring(nameBegin, nameEnd);
                boolean wrap = unwrappedValue.length() != valueEnd - valueBegin;
                cookieBuilder = new CookieBuilder(name, unwrappedValue.toString(), wrap);
                continue;
            }
            cookieBuilder.appendAttribute(header, nameBegin, nameEnd, valueBegin, valueEnd);
        }
        return cookieBuilder.cookie();
    }

    private static class CookieBuilder {
        private static final String PATH = "Path";
        private static final String EXPIRES = "Expires";
        private static final String MAX_AGE = "Max-Age";
        private static final String DOMAIN = "Domain";
        private static final String SECURE = "Secure";
        private static final String HTTPONLY = "HTTPOnly";
        private final String name;
        private final String value;
        private final boolean wrap;
        private String domain;
        private String path;
        private int maxAge = Integer.MIN_VALUE;
        private String expires;
        private boolean secure;
        private boolean httpOnly;

        public CookieBuilder(String name, String value, boolean wrap) {
            this.name = name;
            this.value = value;
            this.wrap = wrap;
        }

        public Cookie cookie() {
            return new Cookie(this.name, this.value, this.wrap, this.domain, this.path, CookieUtil.computeExpires(this.expires), this.maxAge, this.secure, this.httpOnly);
        }

        public void appendAttribute(String header, int keyStart, int keyEnd, int valueBegin, int valueEnd) {
            this.setCookieAttribute(header, keyStart, keyEnd, valueBegin, valueEnd);
        }

        private void setCookieAttribute(String header, int keyStart, int keyEnd, int valueBegin, int valueEnd) {
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(header, keyStart, valueBegin, valueEnd);
            } else if (length == 6) {
                this.parse6(header, keyStart, valueBegin, valueEnd);
            } else if (length == 7) {
                this.parse7(header, keyStart, valueBegin, valueEnd);
            } else if (length == 8) {
                this.parse8(header, keyStart, valueBegin, valueEnd);
            }
        }

        private void parse4(String header, int nameStart, int valueBegin, int valueEnd) {
            if (header.regionMatches(true, nameStart, PATH, 0, 4)) {
                this.path = this.computeValue(header, valueBegin, valueEnd);
            }
        }

        private void parse6(String header, int nameStart, int valueBegin, int valueEnd) {
            if (header.regionMatches(true, nameStart, DOMAIN, 0, 5)) {
                this.domain = this.computeValue(header, valueBegin, valueEnd);
            } else if (header.regionMatches(true, nameStart, SECURE, 0, 5)) {
                this.secure = true;
            }
        }

        private void parse7(String header, int nameStart, int valueBegin, int valueEnd) {
            if (header.regionMatches(true, nameStart, EXPIRES, 0, 7)) {
                this.expires = this.computeValue(header, valueBegin, valueEnd);
            } else if (header.regionMatches(true, nameStart, MAX_AGE, 0, 7)) {
                try {
                    this.maxAge = Math.max(Integer.valueOf(this.computeValue(header, valueBegin, valueEnd)), 0);
                }
                catch (NumberFormatException e1) {
                    // empty catch block
                }
            }
        }

        private void parse8(String header, int nameStart, int valueBegin, int valueEnd) {
            if (header.regionMatches(true, nameStart, HTTPONLY, 0, 8)) {
                this.httpOnly = true;
            }
        }

        private String computeValue(String header, int valueBegin, int valueEnd) {
            if (valueBegin == -1 || valueBegin == valueEnd) {
                return null;
            }
            String trimmed = header.substring(valueBegin, valueEnd).trim();
            return trimmed.isEmpty() ? null : trimmed;
        }
    }
}

