/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.client.providers.grizzly.ConnectionManager;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.GrizzlyResponseHeaders;
import com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import com.ning.http.client.providers.grizzly.StatusHandler;
import com.ning.http.client.providers.grizzly.Utils;
import com.ning.http.client.providers.grizzly.events.ContinueEvent;
import com.ning.http.client.providers.grizzly.events.GracefulCloseEvent;
import com.ning.http.client.providers.grizzly.events.SSLSwitchingEvent;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import com.ning.http.client.providers.netty.util.HttpUtils;
import com.ning.http.client.uri.Uri;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AhcEventFilter
extends HttpClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AhcEventFilter.class);
    private static final Map<Integer, StatusHandler> HANDLER_MAP = new HashMap<Integer, StatusHandler>(8);
    private static IOException maximumPooledConnectionExceededReason;
    private final GrizzlyAsyncHttpProvider provider;
    private static final byte[] CLOSE_BYTES;
    private static final byte[] KEEPALIVE_BYTES;

    AhcEventFilter(GrizzlyAsyncHttpProvider provider, int maxHerdersSizeProperty) {
        super(maxHerdersSizeProperty);
        this.provider = provider;
        HANDLER_MAP.put(HttpStatus.UNAUTHORIZED_401.getStatusCode(), AuthorizationHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.MOVED_PERMANENTLY_301.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.FOUND_302.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.SEE_OTHER_303.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.TEMPORARY_REDIRECT_307.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.PERMANENT_REDIRECT_308.getStatusCode(), RedirectHandler.INSTANCE);
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == GracefulCloseEvent.class) {
            GracefulCloseEvent closeEvent = (GracefulCloseEvent)event;
            HttpResponsePacket response = closeEvent.getHttpTxContext().responsePacket;
            response.getProcessingState().getHttpContext().attach(ctx);
            this.onHttpPacketParsed((HttpHeader)response, ctx);
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        ctx.getCloseable().closeWithReason(Exceptions.makeIOException((Throwable)error));
    }

    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(content.getHttpHeader());
        AsyncHandler handler = context.getAsyncHandler();
        if (handler != null && context.currentState != AsyncHandler.STATE.ABORT) {
            try {
                context.currentState = handler.onBodyPartReceived(new GrizzlyResponseBodyPart(content, ctx.getConnection()));
            }
            catch (Exception e) {
                handler.onThrowable(e);
            }
        }
    }

    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
        AsyncHandler handler = context.getAsyncHandler();
        if (handler instanceof TransferCompletionHandler) {
            ((TransferCompletionHandler)handler).onHeaderWriteCompleted();
        }
    }

    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(content.getHttpHeader());
        AsyncHandler handler = context.getAsyncHandler();
        if (handler instanceof TransferCompletionHandler) {
            int written = content.getContent().remaining();
            long total = context.totalBodyWritten.addAndGet(written);
            ((TransferCompletionHandler)handler).onContentWriteProgress(written, total, content.getHttpHeader().getContentLength());
        }
    }

    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        super.onInitialLineParsed(httpHeader, ctx);
        if (httpHeader.isSkipRemainder()) {
            return;
        }
        HttpResponsePacket responsePacket = (HttpResponsePacket)httpHeader;
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
        int status = responsePacket.getStatus();
        if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(status)) {
            return;
        }
        if (HttpStatus.CONINTUE_100.statusMatches(status)) {
            ctx.notifyUpstream((FilterChainEvent)new ContinueEvent(context));
            return;
        }
        StatusHandler sh = context.statusHandler;
        context.statusHandler = null;
        if (sh != null && !sh.handlesStatus(status)) {
            context.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
        }
        boolean isRedirectAllowed = AhcEventFilter.isRedirectAllowed(context);
        if (context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE) {
            if (HANDLER_MAP.containsKey(status)) {
                context.statusHandler = HANDLER_MAP.get(status);
            }
            if (context.statusHandler instanceof RedirectHandler && !isRedirectAllowed) {
                context.statusHandler = null;
            }
        }
        if (isRedirectAllowed) {
            if (AhcEventFilter.isRedirect(status)) {
                if (context.statusHandler == null) {
                    context.statusHandler = RedirectHandler.INSTANCE;
                }
                context.redirectCount.incrementAndGet();
                if (AhcEventFilter.redirectCountExceeded(context)) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(new MaxRedirectException());
                }
            } else if (context.redirectCount.get() > 0) {
                context.redirectCount.set(0);
            }
        }
        GrizzlyResponseStatus responseStatus = new GrizzlyResponseStatus(responsePacket, context.getAhcRequest().getUri(), this.provider.getClientConfig());
        context.responsePacket = responsePacket;
        context.responseStatus = responseStatus;
        if (context.statusHandler != null) {
            return;
        }
        if (context.currentState != AsyncHandler.STATE.ABORT) {
            try {
                AsyncHandler handler = context.getAsyncHandler();
                if (handler != null) {
                    context.currentState = handler.onStatusReceived(responseStatus);
                    if (context.isWSRequest && context.currentState == AsyncHandler.STATE.ABORT) {
                        httpHeader.setSkipRemainder(true);
                        try {
                            context.done(handler.onCompleted());
                        }
                        catch (Throwable e) {
                            context.abort(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                httpHeader.setSkipRemainder(true);
                context.abort(e);
            }
        }
    }

    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setSkipRemainder(true);
        HttpTransactionContext.currentTransaction(httpHeader).abort(t);
    }

    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setSkipRemainder(true);
        HttpTransactionContext.currentTransaction(httpHeader).abort(t);
    }

    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        block20: {
            boolean result;
            super.onHttpHeaderParsed(httpHeader, buffer, ctx);
            LOGGER.debug("RESPONSE: {}", (Object)httpHeader);
            HttpResponsePacket responsePacket = (HttpResponsePacket)httpHeader;
            boolean isKeepAlive = AhcEventFilter.checkKeepAlive(responsePacket);
            responsePacket.getProcessingState().setKeepAlive(isKeepAlive);
            if (httpHeader.isSkipRemainder()) {
                return false;
            }
            HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
            if (context.establishingTunnel) {
                httpHeader.setExpectContent(false);
                return false;
            }
            AsyncHandler handler = context.getAsyncHandler();
            List<ResponseFilter> filters = this.provider.getClientConfig().getResponseFilters();
            GrizzlyResponseHeaders responseHeaders = new GrizzlyResponseHeaders((HttpResponsePacket)httpHeader);
            if (!filters.isEmpty()) {
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(context.getAhcRequest()).responseHeaders(responseHeaders).responseStatus(context.responseStatus).build();
                try {
                    for (ResponseFilter f : filters) {
                        fc = f.filter(fc);
                    }
                }
                catch (Exception e) {
                    context.abort(e);
                }
                if (fc.replayRequest()) {
                    httpHeader.setSkipRemainder(true);
                    Request newRequest = fc.getRequest();
                    AsyncHandler newHandler = fc.getAsyncHandler();
                    try {
                        GrizzlyResponseFuture responseFuture = context.future;
                        ConnectionManager m = context.provider.getConnectionManager();
                        Connection c = m.openConnectionSync(newRequest, responseFuture);
                        HttpTransactionContext newContext = context.cloneAndStartTransactionFor(c, newRequest);
                        responseFuture.setAsyncHandler(newHandler);
                        responseFuture.setHttpTransactionCtx(newContext);
                        try {
                            this.provider.execute(newContext);
                        }
                        catch (IOException ioe) {
                            newContext.abort(ioe);
                        }
                    }
                    catch (Exception e) {
                        context.abort(e);
                    }
                    return false;
                }
            }
            if (context.statusHandler != null && context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE && !(result = context.statusHandler.handleStatus((HttpResponsePacket)httpHeader, context, ctx))) {
                httpHeader.setSkipRemainder(true);
                return false;
            }
            if (context.isWSRequest) {
                try {
                    context.protocolHandler.setConnection(ctx.getConnection());
                    GrizzlyWebSocketAdapter webSocketAdapter = AhcEventFilter.createWebSocketAdapter(context);
                    context.webSocket = webSocketAdapter;
                    WebSocket ws = webSocketAdapter.getGrizzlyWebSocket();
                    if (context.currentState == AsyncHandler.STATE.UPGRADE) {
                        httpHeader.setChunked(false);
                        ws.onConnect();
                        WebSocketHolder.set((Connection)ctx.getConnection(), (ProtocolHandler)context.protocolHandler, (WebSocket)ws);
                        ((WebSocketUpgradeHandler)context.getAsyncHandler()).onSuccess(context.webSocket);
                        int wsTimeout = this.provider.getClientConfig().getWebSocketTimeout();
                        IdleTimeoutFilter.setCustomTimeout((Connection)ctx.getConnection(), (long)(wsTimeout <= 0 ? IdleTimeoutFilter.FOREVER : (long)wsTimeout), (TimeUnit)TimeUnit.MILLISECONDS);
                        context.done(handler.onCompleted());
                        break block20;
                    }
                    httpHeader.setSkipRemainder(true);
                    ((WebSocketUpgradeHandler)context.getAsyncHandler()).onClose(context.webSocket, 1002, "WebSocket protocol error: unexpected HTTP response status during handshake.");
                    context.done();
                }
                catch (Throwable e) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(e);
                }
            } else if (context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    context.currentState = handler.onHeadersReceived(responseHeaders);
                }
                catch (Exception e) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(e);
                }
            }
        }
        return false;
    }

    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        boolean result = super.onHttpPacketParsed(httpHeader, ctx);
        if (httpHeader.isSkipRemainder()) {
            AhcEventFilter.cleanup(httpHeader.getProcessingState().getHttpContext());
            return result;
        }
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
        if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(((HttpResponsePacket)httpHeader).getStatus())) {
            context.establishingTunnel = false;
            context.tunnelEstablished(connection);
            try {
                this.provider.execute(context);
                return result;
            }
            catch (IOException e) {
                context.abort(e);
                return result;
            }
        }
        AhcEventFilter.cleanup(httpHeader.getProcessingState().getHttpContext());
        AsyncHandler handler = context.getAsyncHandler();
        if (handler != null) {
            try {
                context.done(handler.onCompleted());
            }
            catch (Throwable e) {
                context.abort(e);
            }
        } else {
            context.done();
        }
        return result;
    }

    private static GrizzlyWebSocketAdapter createWebSocketAdapter(HttpTransactionContext context) {
        return GrizzlyWebSocketAdapter.newInstance(context.provider.getClientConfig().getAsyncHttpProviderConfig(), context.protocolHandler);
    }

    private static boolean isRedirectAllowed(HttpTransactionContext ctx) {
        Request r = ctx.getAhcRequest();
        return r.getFollowRedirect() != null ? r.getFollowRedirect() : ctx.redirectsAllowed;
    }

    private static void cleanup(HttpContext httpContext) {
        HttpTransactionContext context = HttpTransactionContext.cleanupTransaction(httpContext);
        if (!context.isReuseConnection()) {
            Connection c = (Connection)httpContext.getCloseable();
            ConnectionManager cm = context.provider.getConnectionManager();
            if (!(httpContext.getRequest().getProcessingState().isStayAlive() && cm.canReturnConnection(c) && cm.returnConnection(context.getAhcRequest(), c))) {
                if (maximumPooledConnectionExceededReason == null) {
                    maximumPooledConnectionExceededReason = new IOException("Maximum pooled connections exceeded");
                }
                c.closeWithReason(maximumPooledConnectionExceededReason);
            }
        }
    }

    private static boolean redirectCountExceeded(HttpTransactionContext context) {
        return context.redirectCount.get() > context.maxRedirectCount;
    }

    private static boolean isRedirect(int status) {
        return HttpStatus.MOVED_PERMANENTLY_301.statusMatches(status) || HttpStatus.FOUND_302.statusMatches(status) || HttpStatus.SEE_OTHER_303.statusMatches(status) || HttpStatus.TEMPORARY_REDIRECT_307.statusMatches(status) || HttpStatus.PERMANENT_REDIRECT_308.statusMatches(status);
    }

    private static boolean checkKeepAlive(HttpResponsePacket response) {
        boolean keepAlive;
        int statusCode = response.getStatus();
        boolean isExpectContent = response.isExpectContent();
        boolean bl = keepAlive = !AhcEventFilter.statusDropsConnection(statusCode) || !isExpectContent || !response.isChunked() || response.getContentLength() == -1L;
        if (keepAlive) {
            DataChunk cVal = response.getHeaders().getValue(Header.Connection);
            keepAlive = response.getProtocol().compareTo((Enum)Protocol.HTTP_1_1) < 0 ? cVal != null && cVal.equalsIgnoreCase(KEEPALIVE_BYTES) : cVal == null || !cVal.equalsIgnoreCase(CLOSE_BYTES);
        }
        return keepAlive;
    }

    private static boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 417 || status == 500 || status == 503 || status == 501 || status == 505;
    }

    private static Request newRequest(Uri uri, HttpResponsePacket response, HttpTransactionContext ctx, boolean asGet) {
        RequestBuilder builder = new RequestBuilder(ctx.getAhcRequest());
        if (asGet) {
            builder.setMethod("GET");
        }
        builder.setUrl(uri.toString());
        builder.resetQuery();
        for (String cookieStr : response.getHeaders().values(Header.Cookie)) {
            builder.addOrReplaceCookie(CookieDecoder.decode(cookieStr));
        }
        return builder.build();
    }

    static {
        CLOSE_BYTES = new byte[]{99, 108, 111, 115, 101};
        KEEPALIVE_BYTES = new byte[]{107, 101, 101, 112, 45, 97, 108, 105, 118, 101};
    }

    private static final class RedirectHandler
    implements StatusHandler {
        static final RedirectHandler INSTANCE = new RedirectHandler();

        private RedirectHandler() {
        }

        @Override
        public boolean handlesStatus(int statusCode) {
            return AhcEventFilter.isRedirect(statusCode);
        }

        @Override
        public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
            String redirectURL = responsePacket.getHeader(Header.Location);
            if (redirectURL == null) {
                throw new IllegalStateException("redirect received, but no location header was present");
            }
            Request req = httpTransactionContext.getAhcRequest();
            GrizzlyAsyncHttpProvider provider = httpTransactionContext.provider;
            Uri orig = httpTransactionContext.lastRedirectURI == null ? req.getUri() : Uri.create(req.getUri(), httpTransactionContext.lastRedirectURI);
            httpTransactionContext.lastRedirectURI = redirectURL;
            Uri uri = Uri.create(orig, redirectURL);
            if (uri.toUrl().equalsIgnoreCase(orig.toUrl())) {
                httpTransactionContext.statusHandler = null;
                httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                try {
                    httpTransactionContext.getAsyncHandler().onStatusReceived(httpTransactionContext.responseStatus);
                }
                catch (Exception e) {
                    httpTransactionContext.abort(e);
                }
                return true;
            }
            Request requestToSend = AhcEventFilter.newRequest(uri, responsePacket, httpTransactionContext, this.sendAsGet(responsePacket, httpTransactionContext));
            ConnectionManager m = provider.getConnectionManager();
            try {
                Connection c = m.openConnectionSync(requestToSend, httpTransactionContext.future);
                if (this.switchingSchemes(orig, uri)) {
                    try {
                        this.notifySchemeSwitch(ctx, c, uri);
                    }
                    catch (IOException ioe) {
                        httpTransactionContext.abort(ioe);
                    }
                }
                HttpTransactionContext newContext = httpTransactionContext.cloneAndStartTransactionFor(c, requestToSend);
                newContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                provider.execute(newContext);
                return false;
            }
            catch (Exception e) {
                httpTransactionContext.abort(e);
                httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                return true;
            }
        }

        private boolean sendAsGet(HttpResponsePacket response, HttpTransactionContext ctx) {
            int statusCode = response.getStatus();
            return statusCode >= 302 && statusCode <= 303 && (statusCode != 302 || !ctx.provider.getClientConfig().isStrict302Handling());
        }

        private boolean switchingSchemes(Uri oldUri, Uri newUri) {
            return !oldUri.getScheme().equals(newUri.getScheme());
        }

        private void notifySchemeSwitch(FilterChainContext ctx, Connection c, Uri uri) throws IOException {
            ctx.notifyDownstream((FilterChainEvent)new SSLSwitchingEvent("https".equals(uri.getScheme()), c));
        }
    }

    private static final class AuthorizationHandler
    implements StatusHandler {
        static final AuthorizationHandler INSTANCE = new AuthorizationHandler();

        private AuthorizationHandler() {
        }

        @Override
        public boolean handlesStatus(int statusCode) {
            return HttpStatus.UNAUTHORIZED_401.statusMatches(statusCode);
        }

        @Override
        public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
            List<String> authHeaders = AuthorizationHandler.listOf(responsePacket.getHeaders().values(Header.WWWAuthenticate));
            if (authHeaders.isEmpty()) {
                throw new IllegalStateException("401 response received, but no WWW-Authenticate header was present");
            }
            GrizzlyAsyncHttpProvider provider = httpTransactionContext.provider;
            Realm realm = httpTransactionContext.getAhcRequest().getRealm();
            if (realm == null) {
                realm = provider.getClientConfig().getRealm();
            }
            if (realm == null) {
                httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                AsyncHandler ah = httpTransactionContext.getAsyncHandler();
                if (ah != null) {
                    try {
                        ah.onStatusReceived(httpTransactionContext.responseStatus);
                    }
                    catch (Exception e) {
                        httpTransactionContext.abort(e);
                    }
                }
                return true;
            }
            Request req = httpTransactionContext.getAhcRequest();
            try {
                Connection c;
                Realm newRealm;
                boolean isContinueAuth;
                String ntlmAuthenticate = HttpUtils.getNTLM(authHeaders);
                if (ntlmAuthenticate != null) {
                    isContinueAuth = true;
                    newRealm = this.ntlmChallenge(ctx.getConnection(), ntlmAuthenticate, req, req.getHeaders(), realm);
                } else {
                    isContinueAuth = false;
                    String firstAuthHeader = authHeaders.get(0);
                    newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getScheme()).setUri(req.getUri()).setMethodName(req.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(firstAuthHeader).build();
                }
                responsePacket.setSkipRemainder(true);
                if (responsePacket.getProcessingState().isKeepAlive()) {
                    c = ctx.getConnection();
                    httpTransactionContext.reuseConnection();
                } else {
                    ConnectionManager m = provider.getConnectionManager();
                    c = m.openConnectionSync(req, httpTransactionContext.future);
                }
                Request nextRequest = ((RequestBuilder)new RequestBuilder(req).setHeaders(req.getHeaders()).setRealm(newRealm)).build();
                HttpTransactionContext newContext = httpTransactionContext.cloneAndStartTransactionFor(c, nextRequest);
                if (!isContinueAuth) {
                    newContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                }
                try {
                    provider.execute(newContext);
                    return false;
                }
                catch (IOException ioe) {
                    newContext.abort(ioe);
                    return false;
                }
            }
            catch (Exception e) {
                httpTransactionContext.abort(e);
                return false;
            }
        }

        private Realm ntlmChallenge(Connection c, String wwwAuth, Request request, FluentCaseInsensitiveStringsMap headers, Realm realm) throws NTLMEngineException {
            if (wwwAuth.equals("NTLM")) {
                String challengeHeader = NTLMEngine.INSTANCE.generateType1Msg();
                this.addNTLMAuthorizationHeader(headers, challengeHeader, false);
            } else {
                this.addType3NTLMAuthorizationHeader(wwwAuth, headers, realm, false);
                Utils.setNtlmEstablished(c);
            }
            return new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
        }

        private void addNTLMAuthorizationHeader(FluentCaseInsensitiveStringsMap headers, String challengeHeader, boolean proxyInd) {
            headers.add(this.authorizationHeaderName(proxyInd), "NTLM " + challengeHeader);
        }

        private void addType3NTLMAuthorizationHeader(String auth, FluentCaseInsensitiveStringsMap headers, Realm realm, boolean proxyInd) throws NTLMEngineException {
            headers.remove(this.authorizationHeaderName(proxyInd));
            if (MiscUtils.isNonEmpty(auth) && auth.startsWith("NTLM ")) {
                String serverChallenge = auth.substring("NTLM ".length()).trim();
                String challengeHeader = NTLMEngine.INSTANCE.generateType3Msg(realm.getPrincipal(), realm.getPassword(), realm.getNtlmDomain(), realm.getNtlmHost(), serverChallenge);
                this.addNTLMAuthorizationHeader(headers, challengeHeader, proxyInd);
            }
        }

        private String authorizationHeaderName(boolean proxyInd) {
            return proxyInd ? Header.ProxyAuthorization.toString() : Header.Authorization.toString();
        }

        private static List<String> listOf(Iterable<String> values) {
            ArrayList<String> list = new ArrayList<String>(2);
            for (String value : values) {
                list.add(value);
            }
            return list;
        }
    }
}

