/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Param;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.UpgradeHandler;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.multipart.MultipartBody;
import com.ning.http.client.multipart.MultipartUtils;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.providers.grizzly.AhcSSLEngineConfigurator;
import com.ning.http.client.providers.grizzly.ConnectionManager;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.GrizzlyResponseHeaders;
import com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.ning.http.client.providers.grizzly.HostnameVerifierListener;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import com.ning.http.client.providers.grizzly.StatusHandler;
import com.ning.http.client.providers.grizzly.SwitchingSSLFilter;
import com.ning.http.client.providers.grizzly.TransportCustomizer;
import com.ning.http.client.uri.Uri;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketByteListener;
import com.ning.http.client.ws.WebSocketCloseCodeReasonListener;
import com.ning.http.client.ws.WebSocketPingListener;
import com.ning.http.client.ws.WebSocketPongListener;
import com.ning.http.client.ws.WebSocketTextListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.ProxyUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.glassfish.grizzly.websockets.Version;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyAsyncHttpProvider.class);
    private static final boolean SEND_FILE_SUPPORT = false;
    private static final NTLMEngine ntlmEngine = new NTLMEngine();
    private static IOException maximumPooledConnectionExceededReason;
    private final BodyHandlerFactory bodyHandlerFactory = new BodyHandlerFactory();
    private final TCPNIOTransport clientTransport;
    private final AsyncHttpClientConfig clientConfig;
    private final GrizzlyAsyncHttpProviderConfig providerConfig;
    private final ConnectionManager connectionManager;
    DelayedExecutor.Resolver<Connection> resolver;
    private DelayedExecutor timeoutExecutor;

    public GrizzlyAsyncHttpProvider(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.providerConfig = clientConfig.getAsyncHttpProviderConfig() instanceof GrizzlyAsyncHttpProviderConfig ? (GrizzlyAsyncHttpProviderConfig)clientConfig.getAsyncHttpProviderConfig() : new GrizzlyAsyncHttpProviderConfig();
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        this.clientTransport = builder.build();
        this.initializeTransport(clientConfig);
        this.connectionManager = new ConnectionManager(this, this.clientTransport, this.providerConfig);
        try {
            this.clientTransport.start();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public <T> ListenableFuture<T> execute(final Request request, final AsyncHandler<T> handler) {
        if (this.clientTransport.isStopped()) {
            IOException e = new IOException("AsyncHttpClient has been closed.");
            handler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
        ProxyServer proxy = ProxyUtils.getProxyServer(this.clientConfig, request);
        final GrizzlyResponseFuture future = new GrizzlyResponseFuture(this, request, handler, proxy);
        CompletionHandler<Connection> connectHandler = new CompletionHandler<Connection>(){

            public void cancelled() {
                future.cancel(true);
            }

            public void failed(Throwable throwable) {
                future.abort(throwable);
            }

            public void completed(Connection c) {
                block5: {
                    try {
                        GrizzlyAsyncHttpProvider.this.execute(c, request, handler, future, true);
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            this.failed(e);
                        } else if (e instanceof IOException) {
                            this.failed(e);
                        }
                        if (!LOGGER.isWarnEnabled()) break block5;
                        LOGGER.warn(e.toString(), (Throwable)e);
                    }
                }
            }

            public void updated(Connection c) {
            }
        };
        try {
            this.connectionManager.doAsyncTrackedConnection(request, future, connectHandler);
        }
        catch (IOException ioe) {
            this.abort(future, ioe);
        }
        catch (RuntimeException re) {
            this.abort(future, re);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(e.toString(), (Throwable)e);
            }
            this.abort(future, e);
        }
        return future;
    }

    private void abort(GrizzlyResponseFuture<?> future, Throwable t) {
        if (!future.isDone()) {
            LOGGER.debug("Aborting Future {}\n", future);
            LOGGER.debug(t.getMessage(), t);
            future.abort(t);
        }
    }

    @Override
    public void close() {
        try {
            this.connectionManager.destroy();
            this.clientTransport.shutdownNow();
            ExecutorService service = this.clientConfig.executorService();
            if (service != null) {
                service.shutdown();
            }
            if (this.timeoutExecutor != null) {
                this.timeoutExecutor.stop();
                this.timeoutExecutor.getThreadPool().shutdownNow();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected <T> ListenableFuture<T> execute(Connection c, Request request, AsyncHandler<T> handler, GrizzlyResponseFuture<T> future, boolean forceTxContextExist) throws IOException {
        block5: {
            try {
                if (forceTxContextExist && HttpTransactionContext.currentTransaction(c) == null) {
                    HttpTransactionContext.startTransaction(c, this, future, request, handler);
                }
                c.write((Object)request, this.createWriteCompletionHandler(future));
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn(e.toString(), (Throwable)e);
            }
        }
        return future;
    }

    protected void initializeTransport(final AsyncHttpClientConfig clientConfig) {
        FilterChainBuilder fcb = FilterChainBuilder.stateless();
        fcb.add((Filter)new TransportFilter());
        final int timeout = clientConfig.getRequestTimeout();
        if (timeout > 0) {
            int delay = 500;
            if (timeout < delay) {
                delay = timeout - 10;
            }
            this.timeoutExecutor = IdleTimeoutFilter.createDefaultIdleDelayedExecutor((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
            this.timeoutExecutor.start();
            IdleTimeoutFilter.TimeoutResolver timeoutResolver = new IdleTimeoutFilter.TimeoutResolver(){

                public long getTimeout(FilterChainContext ctx) {
                    HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
                    if (context != null) {
                        if (context.isWSRequest) {
                            return clientConfig.getWebSocketTimeout();
                        }
                        long timeout2 = context.request.getRequestTimeout();
                        if (timeout2 > 0L) {
                            return timeout2;
                        }
                    }
                    return timeout;
                }
            };
            IdleTimeoutFilter timeoutFilter = new IdleTimeoutFilter(this.timeoutExecutor, timeoutResolver, new IdleTimeoutFilter.TimeoutHandler(){

                public void onTimeout(Connection connection) {
                    GrizzlyAsyncHttpProvider.this.timeout(connection);
                }
            });
            fcb.add((Filter)timeoutFilter);
            this.resolver = timeoutFilter.getResolver();
        }
        boolean defaultSecState = clientConfig.getSSLContext() != null;
        AhcSSLEngineConfigurator configurator = new AhcSSLEngineConfigurator(this.providerConfig.getSslEngineFactory() != null ? this.providerConfig.getSslEngineFactory() : new SSLEngineFactory.DefaultSSLEngineFactory(clientConfig));
        SwitchingSSLFilter sslFilter = new SwitchingSSLFilter(configurator, defaultSecState);
        if (clientConfig.getHostnameVerifier() != null) {
            sslFilter.addHandshakeListener(new HostnameVerifierListener());
        }
        fcb.add((Filter)sslFilter);
        AsyncHttpClientEventFilter eventFilter = new AsyncHttpClientEventFilter(this, (Integer)this.providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.MAX_HTTP_PACKET_HEADER_SIZE));
        AsyncHttpClientFilter clientFilter = new AsyncHttpClientFilter(clientConfig);
        ContentEncoding[] encodings = eventFilter.getContentEncodings();
        if (encodings.length > 0) {
            for (ContentEncoding encoding : encodings) {
                eventFilter.removeContentEncoding(encoding);
            }
        }
        eventFilter.addContentEncoding((ContentEncoding)new GZipContentEncoding(512, 512, (EncodingFilter)new ClientEncodingFilter()));
        fcb.add((Filter)eventFilter);
        fcb.add((Filter)clientFilter);
        this.clientTransport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(-2);
        this.clientTransport.setNIOChannelDistributor((NIOChannelDistributor)new RoundRobinConnectionDistributor((NIOTransport)this.clientTransport, false, false));
        int kernelThreadsCount = clientConfig.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
        this.clientTransport.setSelectorRunnersCount(kernelThreadsCount);
        this.clientTransport.setKernelThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(kernelThreadsCount).setMaxPoolSize(kernelThreadsCount).setPoolName("grizzly-ahc-kernel"));
        TransportCustomizer customizer = (TransportCustomizer)this.providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER);
        if (customizer != null) {
            customizer.customize(this.clientTransport, fcb);
        } else {
            this.doDefaultTransportConfig();
        }
        fcb.add((Filter)new WebSocketFilter());
        this.clientTransport.setProcessor((Processor)fcb.build());
    }

    void touchConnection(Connection c, Request request) {
        long perRequestTimeout = request.getRequestTimeout();
        if (perRequestTimeout > 0L) {
            long newTimeout = System.currentTimeMillis() + perRequestTimeout;
            if (this.resolver != null) {
                this.resolver.setTimeoutMillis((Object)c, newTimeout);
            }
        } else {
            long timeout = this.clientConfig.getRequestTimeout();
            if (timeout > 0L && this.resolver != null) {
                this.resolver.setTimeoutMillis((Object)c, System.currentTimeMillis() + timeout);
            }
        }
    }

    private static boolean configSendFileSupport() {
        return (!System.getProperty("os.name").equalsIgnoreCase("linux") || GrizzlyAsyncHttpProvider.linuxSendFileSupported()) && !System.getProperty("os.name").equalsIgnoreCase("HP-UX");
    }

    private static boolean linuxSendFileSupported() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6")) {
            int idx = version.indexOf(95);
            if (idx == -1) {
                return false;
            }
            int patchRev = Integer.parseInt(version.substring(idx + 1));
            return patchRev >= 18;
        }
        return version.startsWith("1.7") || version.startsWith("1.8");
    }

    private void doDefaultTransportConfig() {
        ExecutorService service = this.clientConfig.executorService();
        if (service != null) {
            this.clientTransport.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
            this.clientTransport.setWorkerThreadPool(service);
        } else {
            this.clientTransport.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
        }
    }

    private <T> CompletionHandler<WriteResult> createWriteCompletionHandler(final GrizzlyResponseFuture<T> future) {
        return new CompletionHandler<WriteResult>(){

            public void cancelled() {
                future.cancel(true);
            }

            public void failed(Throwable throwable) {
                future.abort(throwable);
            }

            public void completed(WriteResult result) {
            }

            public void updated(WriteResult result) {
            }
        };
    }

    void timeout(Connection c) {
        HttpTransactionContext context = HttpTransactionContext.cleanupTransaction(c);
        context.abort(new TimeoutException("Timeout exceeded"));
    }

    boolean sendRequest(HttpTransactionContext httpCtx, FilterChainContext ctx, HttpRequestPacket requestPacket, BodyHandler bodyHandler) throws IOException {
        Request request = httpCtx.request;
        AsyncHandler h = httpCtx.handler;
        if (h instanceof TransferCompletionHandler) {
            FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap(request.getHeaders());
            ((TransferCompletionHandler)TransferCompletionHandler.class.cast(h)).headers(map);
        }
        requestPacket.setConnection(ctx.getConnection());
        boolean isWriteComplete = true;
        if (bodyHandler != null) {
            httpCtx.bodyHandler = bodyHandler;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            isWriteComplete = bodyHandler.doHandle(ctx, request, requestPacket);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            ctx.write((Object)requestPacket, ctx.getTransportContext().getCompletionHandler());
        }
        return isWriteComplete;
    }

    public static void main(String[] args) {
        SecureRandom secureRandom = new SecureRandom();
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, secureRandom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).setSSLContext(sslContext).build();
        AsyncHttpClient client = new AsyncHttpClient(new GrizzlyAsyncHttpProvider(config), config);
        long start = System.currentTimeMillis();
        try {
            client.executeRequest(client.prepareGet("http://www.google.com").build()).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        LOGGER.debug("COMPLETE: " + (System.currentTimeMillis() - start) + "ms");
    }

    private static final class AHCWebSocketListenerAdapter
    implements WebSocketListener {
        private final com.ning.http.client.ws.WebSocketListener ahcListener;
        private final GrizzlyWebSocketAdapter webSocket;
        private final StringBuilder stringBuffer;
        private final ByteArrayOutputStream byteArrayOutputStream;

        AHCWebSocketListenerAdapter(com.ning.http.client.ws.WebSocketListener ahcListener, GrizzlyWebSocketAdapter webSocket) {
            this.ahcListener = ahcListener;
            this.webSocket = webSocket;
            if (webSocket.bufferFragments) {
                this.stringBuffer = new StringBuilder();
                this.byteArrayOutputStream = new ByteArrayOutputStream();
            } else {
                this.stringBuffer = null;
                this.byteArrayOutputStream = null;
            }
        }

        public void onClose(org.glassfish.grizzly.websockets.WebSocket gWebSocket, DataFrame dataFrame) {
            try {
                if (this.ahcListener instanceof WebSocketCloseCodeReasonListener) {
                    ClosingFrame cf = (ClosingFrame)ClosingFrame.class.cast(dataFrame);
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(this.ahcListener)).onClose(this.webSocket, cf.getCode(), cf.getReason());
                } else {
                    this.ahcListener.onClose(this.webSocket);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onConnect(org.glassfish.grizzly.websockets.WebSocket gWebSocket) {
            try {
                this.ahcListener.onOpen(this.webSocket);
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onMessage(org.glassfish.grizzly.websockets.WebSocket webSocket, String s) {
            try {
                if (this.ahcListener instanceof WebSocketTextListener) {
                    ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onMessage(s);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onMessage(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes) {
            try {
                if (this.ahcListener instanceof WebSocketByteListener) {
                    ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onMessage(bytes);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onPing(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes) {
            try {
                if (this.ahcListener instanceof WebSocketPingListener) {
                    ((WebSocketPingListener)WebSocketPingListener.class.cast(this.ahcListener)).onPing(bytes);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        public void onPong(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes) {
            try {
                if (this.ahcListener instanceof WebSocketPongListener) {
                    ((WebSocketPongListener)WebSocketPongListener.class.cast(this.ahcListener)).onPong(bytes);
                }
            }
            catch (Throwable e) {
                this.ahcListener.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFragment(org.glassfish.grizzly.websockets.WebSocket webSocket, String s, boolean last) {
            block6: {
                try {
                    if (!this.webSocket.bufferFragments) break block6;
                    GrizzlyWebSocketAdapter grizzlyWebSocketAdapter = this.webSocket;
                    synchronized (grizzlyWebSocketAdapter) {
                        this.stringBuffer.append(s);
                        if (last && this.ahcListener instanceof WebSocketTextListener) {
                            String message = this.stringBuffer.toString();
                            this.stringBuffer.setLength(0);
                            ((WebSocketTextListener)WebSocketTextListener.class.cast(this.ahcListener)).onMessage(message);
                        }
                    }
                }
                catch (Throwable e) {
                    this.ahcListener.onError(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFragment(org.glassfish.grizzly.websockets.WebSocket webSocket, byte[] bytes, boolean last) {
            block6: {
                try {
                    if (!this.webSocket.bufferFragments) break block6;
                    GrizzlyWebSocketAdapter grizzlyWebSocketAdapter = this.webSocket;
                    synchronized (grizzlyWebSocketAdapter) {
                        this.byteArrayOutputStream.write(bytes);
                        if (last && this.ahcListener instanceof WebSocketByteListener) {
                            byte[] bytesLocal = this.byteArrayOutputStream.toByteArray();
                            this.byteArrayOutputStream.reset();
                            ((WebSocketByteListener)WebSocketByteListener.class.cast(this.ahcListener)).onMessage(bytesLocal);
                        }
                    }
                }
                catch (Throwable e) {
                    this.ahcListener.onError(e);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AHCWebSocketListenerAdapter that = (AHCWebSocketListenerAdapter)o;
            if (this.ahcListener != null ? !this.ahcListener.equals(that.ahcListener) : that.ahcListener != null) {
                return false;
            }
            return !(this.webSocket != null ? !this.webSocket.equals(that.webSocket) : that.webSocket != null);
        }

        public int hashCode() {
            int result = this.ahcListener != null ? this.ahcListener.hashCode() : 0;
            result = 31 * result + (this.webSocket != null ? this.webSocket.hashCode() : 0);
            return result;
        }
    }

    private static final class GrizzlyWebSocketAdapter
    implements WebSocket {
        final SimpleWebSocket gWebSocket;
        final boolean bufferFragments;

        GrizzlyWebSocketAdapter(SimpleWebSocket gWebSocket, boolean bufferFragments) {
            this.gWebSocket = gWebSocket;
            this.bufferFragments = bufferFragments;
        }

        @Override
        public WebSocket sendMessage(byte[] message) {
            this.gWebSocket.send(message);
            return this;
        }

        @Override
        public WebSocket stream(byte[] fragment, boolean last) {
            if (MiscUtils.isNonEmpty(fragment)) {
                this.gWebSocket.stream(last, fragment, 0, fragment.length);
            }
            return this;
        }

        @Override
        public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
            if (MiscUtils.isNonEmpty(fragment)) {
                this.gWebSocket.stream(last, fragment, offset, len);
            }
            return this;
        }

        @Override
        public WebSocket sendMessage(String message) {
            this.gWebSocket.send(message);
            return this;
        }

        @Override
        public WebSocket stream(String fragment, boolean last) {
            this.gWebSocket.stream(last, fragment);
            return this;
        }

        @Override
        public WebSocket sendPing(byte[] payload) {
            this.gWebSocket.sendPing(payload);
            return this;
        }

        @Override
        public WebSocket sendPong(byte[] payload) {
            this.gWebSocket.sendPong(payload);
            return this;
        }

        @Override
        public WebSocket addWebSocketListener(com.ning.http.client.ws.WebSocketListener l) {
            this.gWebSocket.add((WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
            return this;
        }

        @Override
        public WebSocket removeWebSocketListener(com.ning.http.client.ws.WebSocketListener l) {
            this.gWebSocket.remove((WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
            return this;
        }

        @Override
        public boolean isOpen() {
            return this.gWebSocket.isConnected();
        }

        @Override
        public void close() {
            this.gWebSocket.close();
        }
    }

    private static final class BodyGeneratorBodyHandler
    extends BodyHandler {
        private BodyGeneratorBodyHandler() {
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return request.getBodyGenerator() != null;
        }

        @Override
        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            BodyGenerator generator = request.getBodyGenerator();
            Body bodyLocal = generator.createBody();
            long len = bodyLocal.getContentLength();
            if (len >= 0L) {
                requestPacket.setContentLengthLong(len);
            } else {
                requestPacket.setChunked(true);
            }
            MemoryManager mm = ctx.getMemoryManager();
            boolean last = false;
            while (!last) {
                Buffer buffer = mm.allocate(MAX_CHUNK_SIZE);
                buffer.allowBufferDispose(true);
                long readBytes = bodyLocal.read(buffer.toByteBuffer());
                if (readBytes > 0L) {
                    buffer.position((int)readBytes);
                    buffer.trim();
                } else {
                    buffer.dispose();
                    if (readBytes < 0L) {
                        last = true;
                        buffer = Buffers.EMPTY_BUFFER;
                    } else {
                        if (generator instanceof FeedableBodyGenerator) {
                            ((FeedableBodyGenerator)generator).initializeAsynchronousTransfer(ctx, requestPacket);
                            return false;
                        }
                        throw new IllegalStateException("BodyGenerator unexpectedly returned 0 bytes available");
                    }
                }
                HttpContent content = requestPacket.httpContentBuilder().content(buffer).last(last).build();
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class FileBodyHandler
    extends BodyHandler {
        private FileBodyHandler() {
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return request.getFile() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doHandle(FilterChainContext ctx, Request request, final HttpRequestPacket requestPacket) throws IOException {
            File f = request.getFile();
            requestPacket.setContentLengthLong(f.length());
            final HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
            if (!SEND_FILE_SUPPORT || requestPacket.isSecure()) {
                FileInputStream fis = new FileInputStream(request.getFile());
                MemoryManager mm = ctx.getMemoryManager();
                AtomicInteger written = new AtomicInteger();
                boolean last = false;
                try {
                    byte[] buf = new byte[MAX_CHUNK_SIZE];
                    while (!last) {
                        Buffer b = null;
                        int read = fis.read(buf);
                        if (read < 0) {
                            last = true;
                            b = Buffers.EMPTY_BUFFER;
                        }
                        if (b != Buffers.EMPTY_BUFFER) {
                            written.addAndGet(read);
                            b = Buffers.wrap((MemoryManager)mm, (byte[])buf, (int)0, (int)read);
                        }
                        HttpContent content = requestPacket.httpContentBuilder().content(b).last(last).build();
                        ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
                    }
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            ctx.write((Object)new FileTransfer(f), (CompletionHandler)new EmptyCompletionHandler<WriteResult>(){

                public void updated(WriteResult result) {
                    AsyncHandler handler = context.handler;
                    if (handler instanceof TransferCompletionHandler) {
                        long written = result.getWrittenSize();
                        long total = context.totalBodyWritten.addAndGet(written);
                        ((TransferCompletionHandler)handler).onContentWriteProgress(written, total, requestPacket.getContentLength());
                    }
                }
            });
            return true;
        }

        @Override
        protected long getContentLength(Request request) {
            return request.getContentLength() >= 0L ? request.getContentLength() : request.getFile().length();
        }
    }

    private static final class PartsBodyHandler
    extends BodyHandler {
        private PartsBodyHandler() {
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return MiscUtils.isNonEmpty(request.getParts());
        }

        @Override
        public boolean doHandle(final FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            List<Part> parts = request.getParts();
            final MultipartBody multipartBody = MultipartUtils.newMultipartBody(parts, request.getHeaders());
            long contentLength = multipartBody.getContentLength();
            String contentType = multipartBody.getContentType();
            requestPacket.setContentLengthLong(contentLength);
            requestPacket.setContentType(contentType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST(modified): contentLength={}, contentType={}", new Object[]{requestPacket.getContentLength(), requestPacket.getContentType()});
            }
            FeedableBodyGenerator generator = new FeedableBodyGenerator(){

                @Override
                public Body createBody() throws IOException {
                    return multipartBody;
                }
            };
            generator.setFeeder(new FeedableBodyGenerator.BaseFeeder(generator){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() throws IOException {
                    Body bodyLocal = this.feedableBodyGenerator.createBody();
                    try {
                        MemoryManager mm = ctx.getMemoryManager();
                        boolean last = false;
                        while (!last) {
                            Buffer buffer = mm.allocate(BodyHandler.MAX_CHUNK_SIZE);
                            buffer.allowBufferDispose(true);
                            long readBytes = bodyLocal.read(buffer.toByteBuffer());
                            if (readBytes > 0L) {
                                buffer.position((int)readBytes);
                                buffer.trim();
                            } else {
                                buffer.dispose();
                                if (readBytes < 0L) {
                                    last = true;
                                    buffer = Buffers.EMPTY_BUFFER;
                                } else {
                                    throw new IllegalStateException("MultipartBody unexpectedly returned 0 bytes available");
                                }
                            }
                            this.feed(buffer, last);
                        }
                    }
                    finally {
                        if (bodyLocal != null) {
                            try {
                                bodyLocal.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            generator.initializeAsynchronousTransfer(ctx, requestPacket);
            return false;
        }
    }

    private static final class StreamDataBodyHandler
    extends BodyHandler {
        private StreamDataBodyHandler() {
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return request.getStreamData() != null;
        }

        @Override
        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            int read;
            InputStream in;
            byte[] b;
            Buffer buffer;
            MemoryManager mm;
            block6: {
                mm = ctx.getMemoryManager();
                buffer = mm.allocate(512);
                b = new byte[512];
                in = request.getStreamData();
                try {
                    in.reset();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug(ioe.toString(), (Throwable)ioe);
                }
            }
            if (in.markSupported()) {
                in.mark(0);
            }
            while ((read = in.read(b)) != -1) {
                if (read > buffer.remaining()) {
                    buffer = mm.reallocate(buffer, buffer.capacity() + 512);
                }
                buffer.put(b, 0, read);
            }
            buffer.trim();
            if (buffer.hasRemaining()) {
                HttpContent content = requestPacket.httpContentBuilder().content(buffer).last(true).build();
                buffer.allowBufferDispose(false);
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class ParamsBodyHandler
    extends BodyHandler {
        private ParamsBodyHandler() {
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return MiscUtils.isNonEmpty(request.getFormParams());
        }

        @Override
        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            String charset;
            if (requestPacket.getContentType() == null) {
                requestPacket.setContentType("application/x-www-form-urlencoded");
            }
            if ((charset = request.getBodyEncoding()) == null) {
                charset = Charsets.ASCII_CHARSET.name();
            }
            if (MiscUtils.isNonEmpty(request.getFormParams())) {
                StringBuilder sb = new StringBuilder(128);
                for (Param param : request.getFormParams()) {
                    String name = URLEncoder.encode(param.getName(), charset);
                    String value = URLEncoder.encode(param.getValue(), charset);
                    sb.append(name).append('=').append(value).append('&');
                }
                sb.setLength(sb.length() - 1);
                byte[] data = sb.toString().getBytes(charset);
                MemoryManager mm = ctx.getMemoryManager();
                Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
                HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
                if (requestPacket.getContentLength() == -1L) {
                    requestPacket.setContentLengthLong((long)data.length);
                }
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private final class StringBodyHandler
    extends BodyHandler {
        private StringBodyHandler() {
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return request.getStringData() != null;
        }

        @Override
        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            String charset = request.getBodyEncoding();
            if (charset == null) {
                charset = Charsets.ASCII_CHARSET.name();
            }
            byte[] data = request.getStringData().getBytes(charset);
            MemoryManager mm = ctx.getMemoryManager();
            Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
            if (requestPacket.getContentLength() == -1L) {
                requestPacket.setContentLengthLong((long)data.length);
            }
            HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }
    }

    private final class ByteArrayBodyHandler
    extends BodyHandler {
        private ByteArrayBodyHandler() {
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return request.getByteData() != null;
        }

        @Override
        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            MemoryManager mm = ctx.getMemoryManager();
            byte[] data = request.getByteData();
            Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
            if (requestPacket.getContentLength() == -1L) {
                requestPacket.setContentLengthLong((long)data.length);
            }
            HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }

        @Override
        protected long getContentLength(Request request) {
            return request.getContentLength() >= 0L ? request.getContentLength() : (long)request.getByteData().length;
        }
    }

    private static final class ExpectHandler
    extends BodyHandler {
        private final BodyHandler delegate;
        private Request request;
        private HttpRequestPacket requestPacket;

        private ExpectHandler(BodyHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean handlesBodyType(Request request) {
            return this.delegate.handlesBodyType(request);
        }

        @Override
        public boolean doHandle(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            this.request = request;
            this.requestPacket = requestPacket;
            long contentLength = this.delegate.getContentLength(request);
            if (contentLength != -1L) {
                requestPacket.setContentLengthLong(contentLength);
            }
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }

        public void finish(FilterChainContext ctx) throws IOException {
            this.delegate.doHandle(ctx, this.request, this.requestPacket);
        }
    }

    private final class BodyHandlerFactory {
        private final BodyHandler[] HANDLERS;

        private BodyHandlerFactory() {
            this.HANDLERS = new BodyHandler[]{new StringBodyHandler(), new ByteArrayBodyHandler(), new ParamsBodyHandler(), new StreamDataBodyHandler(), new PartsBodyHandler(), new FileBodyHandler(), new BodyGeneratorBodyHandler()};
        }

        public BodyHandler getBodyHandler(Request request) {
            for (BodyHandler h : this.HANDLERS) {
                if (!h.handlesBodyType(request)) continue;
                return h;
            }
            return null;
        }
    }

    public static abstract class BodyHandler {
        public static int MAX_CHUNK_SIZE = 8192;

        public abstract boolean handlesBodyType(Request var1);

        public abstract boolean doHandle(FilterChainContext var1, Request var2, HttpRequestPacket var3) throws IOException;

        protected long getContentLength(Request request) {
            return request.getContentLength();
        }
    }

    private static final class ClientEncodingFilter
    implements EncodingFilter {
        private ClientEncodingFilter() {
        }

        public boolean applyEncoding(HttpHeader httpPacket) {
            return false;
        }

        public boolean applyDecoding(HttpHeader httpPacket) {
            HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
            DataChunk bc = httpResponse.getHeaders().getValue(Header.ContentEncoding);
            return bc != null && bc.indexOf("gzip", 0) != -1;
        }
    }

    private static final class AsyncHttpClientEventFilter
    extends HttpClientFilter {
        private final Map<Integer, StatusHandler> HANDLER_MAP = new HashMap<Integer, StatusHandler>();
        private final GrizzlyAsyncHttpProvider provider;

        AsyncHttpClientEventFilter(GrizzlyAsyncHttpProvider provider, int maxHerdersSizeProperty) {
            super(maxHerdersSizeProperty);
            this.provider = provider;
            this.HANDLER_MAP.put(HttpStatus.UNAUTHORIZED_401.getStatusCode(), AuthorizationHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.MOVED_PERMANENTLY_301.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.FOUND_302.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.SEE_OTHER_303.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.TEMPORARY_REDIRECT_307.getStatusCode(), RedirectHandler.INSTANCE);
            this.HANDLER_MAP.put(HttpStatus.PERMANENT_REDIRECT_308.getStatusCode(), RedirectHandler.INSTANCE);
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (event.type() == GracefulCloseEvent.class) {
                GracefulCloseEvent closeEvent = (GracefulCloseEvent)event;
                HttpResponsePacket response = closeEvent.getHttpTxContext().responsePacket;
                response.getProcessingState().getHttpContext().attach(ctx);
                this.onHttpPacketParsed((HttpHeader)response, ctx);
                return ctx.getStopAction();
            }
            return ctx.getInvokeAction();
        }

        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            HttpTransactionContext.currentTransaction(ctx.getConnection()).abort(error);
        }

        protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
            HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler != null && context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    context.currentState = handler.onBodyPartReceived(new GrizzlyResponseBodyPart(content, ctx.getConnection()));
                }
                catch (Exception e) {
                    handler.onThrowable(e);
                }
            }
        }

        protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
            HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler instanceof TransferCompletionHandler) {
                ((TransferCompletionHandler)handler).onHeaderWriteCompleted();
            }
        }

        protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
            HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
            AsyncHandler handler = context.handler;
            if (handler instanceof TransferCompletionHandler) {
                int written = content.getContent().remaining();
                long total = context.totalBodyWritten.addAndGet(written);
                ((TransferCompletionHandler)handler).onContentWriteProgress(written, total, content.getHttpHeader().getContentLength());
            }
        }

        protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            super.onInitialLineParsed(httpHeader, ctx);
            if (httpHeader.isSkipRemainder()) {
                return;
            }
            HttpResponsePacket responsePacket = (HttpResponsePacket)httpHeader;
            HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
            int status = responsePacket.getStatus();
            if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(status)) {
                return;
            }
            if (HttpStatus.CONINTUE_100.statusMatches(status)) {
                ctx.notifyUpstream((FilterChainEvent)new ContinueEvent(context));
                return;
            }
            if (context.statusHandler != null && !context.statusHandler.handlesStatus(status)) {
                context.statusHandler = null;
                context.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
            } else {
                context.statusHandler = null;
            }
            if (context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE) {
                if (this.HANDLER_MAP.containsKey(status)) {
                    context.statusHandler = this.HANDLER_MAP.get(status);
                }
                if (context.statusHandler instanceof RedirectHandler && !AsyncHttpClientEventFilter.isRedirectAllowed(context)) {
                    context.statusHandler = null;
                }
            }
            if (AsyncHttpClientEventFilter.isRedirectAllowed(context)) {
                if (AsyncHttpClientEventFilter.isRedirect(status)) {
                    if (context.statusHandler == null) {
                        context.statusHandler = RedirectHandler.INSTANCE;
                    }
                    context.redirectCount.incrementAndGet();
                    if (AsyncHttpClientEventFilter.redirectCountExceeded(context)) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(new MaxRedirectException());
                    }
                } else if (context.redirectCount.get() > 0) {
                    context.redirectCount.set(0);
                }
            }
            GrizzlyResponseStatus responseStatus = new GrizzlyResponseStatus(responsePacket, context.request.getUri(), this.provider.clientConfig);
            context.responsePacket = responsePacket;
            context.responseStatus = responseStatus;
            if (context.statusHandler != null) {
                return;
            }
            if (context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    AsyncHandler handler = context.handler;
                    if (handler != null) {
                        context.currentState = handler.onStatusReceived(responseStatus);
                        if (context.isWSRequest && context.currentState == AsyncHandler.STATE.ABORT) {
                            httpHeader.setSkipRemainder(true);
                            try {
                                context.done(handler.onCompleted());
                            }
                            catch (Throwable e) {
                                context.abort(e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(e);
                }
            }
        }

        protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
            httpHeader.setSkipRemainder(true);
            HttpTransactionContext.currentTransaction(ctx.getConnection()).abort(t);
        }

        protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
            httpHeader.setSkipRemainder(true);
            HttpTransactionContext.currentTransaction(ctx.getConnection()).abort(t);
        }

        protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            block20: {
                boolean result;
                super.onHttpHeadersParsed(httpHeader, ctx);
                LOGGER.debug("RESPONSE: {}", (Object)httpHeader);
                HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
                if (httpHeader.containsHeader(Header.Connection) && "close".equals(httpHeader.getHeader(Header.Connection))) {
                    ConnectionManager.markConnectionAsDoNotCache(ctx.getConnection());
                }
                if (httpHeader.isSkipRemainder() || context.establishingTunnel) {
                    return;
                }
                AsyncHandler handler = context.handler;
                List<ResponseFilter> filters = context.provider.clientConfig.getResponseFilters();
                GrizzlyResponseHeaders responseHeaders = new GrizzlyResponseHeaders((HttpResponsePacket)httpHeader);
                if (!filters.isEmpty()) {
                    FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(context.request).responseHeaders(responseHeaders).responseStatus(context.responseStatus).build();
                    try {
                        for (ResponseFilter f : filters) {
                            fc = f.filter(fc);
                        }
                    }
                    catch (Exception e) {
                        context.abort(e);
                    }
                    if (fc.replayRequest()) {
                        httpHeader.setSkipRemainder(true);
                        Request newRequest = fc.getRequest();
                        AsyncHandler newHandler = fc.getAsyncHandler();
                        try {
                            ConnectionManager m = context.provider.connectionManager;
                            Connection c = m.obtainConnection(newRequest, context.future);
                            HttpTransactionContext newContext = context.cloneAndStartTransactionFor(c);
                            context.future = null;
                            try {
                                context.provider.execute(c, newRequest, newHandler, context.future, false);
                            }
                            catch (IOException ioe) {
                                newContext.abort(ioe);
                            }
                        }
                        catch (Exception e) {
                            context.abort(e);
                        }
                        return;
                    }
                }
                if (context.statusHandler != null && context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE && !(result = context.statusHandler.handleStatus((HttpResponsePacket)httpHeader, context, ctx))) {
                    httpHeader.setSkipRemainder(true);
                    return;
                }
                if (context.isWSRequest) {
                    try {
                        context.protocolHandler.setConnection(ctx.getConnection());
                        GrizzlyWebSocketAdapter webSocketAdapter = AsyncHttpClientEventFilter.createWebSocketAdapter(context);
                        context.webSocket = webSocketAdapter;
                        SimpleWebSocket ws = webSocketAdapter.gWebSocket;
                        if (context.currentState == AsyncHandler.STATE.UPGRADE) {
                            httpHeader.setChunked(false);
                            ws.onConnect();
                            WebSocketHolder.set((Connection)ctx.getConnection(), (ProtocolHandler)context.protocolHandler, (org.glassfish.grizzly.websockets.WebSocket)ws);
                            ((WebSocketUpgradeHandler)context.handler).onSuccess(context.webSocket);
                            int wsTimeout = context.provider.clientConfig.getWebSocketTimeout();
                            IdleTimeoutFilter.setCustomTimeout((Connection)ctx.getConnection(), (long)(wsTimeout <= 0 ? IdleTimeoutFilter.FOREVER : (long)wsTimeout), (TimeUnit)TimeUnit.MILLISECONDS);
                            context.done(handler.onCompleted());
                            break block20;
                        }
                        httpHeader.setSkipRemainder(true);
                        ((WebSocketUpgradeHandler)context.handler).onClose(context.webSocket, 1002, "WebSocket protocol error: unexpected HTTP response status during handshake.");
                        context.done();
                    }
                    catch (Throwable e) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(e);
                    }
                } else if (context.currentState != AsyncHandler.STATE.ABORT) {
                    try {
                        context.currentState = handler.onHeadersReceived(responseHeaders);
                    }
                    catch (Exception e) {
                        httpHeader.setSkipRemainder(true);
                        context.abort(e);
                    }
                }
            }
        }

        protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
            super.onHttpHeaderParsed(httpHeader, buffer, ctx);
            HttpRequestPacket request = ((HttpResponsePacket)httpHeader).getRequest();
            if (Method.CONNECT.equals(request.getMethod())) {
                httpHeader.setExpectContent(false);
            }
            return false;
        }

        protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
            if (httpHeader.isSkipRemainder()) {
                this.clearResponse(ctx.getConnection());
                AsyncHttpClientEventFilter.cleanup(ctx, this.provider);
                return false;
            }
            boolean result = super.onHttpPacketParsed(httpHeader, ctx);
            HttpTransactionContext context = HttpTransactionContext.currentTransaction(ctx.getConnection());
            if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(((HttpResponsePacket)httpHeader).getStatus())) {
                context.establishingTunnel = false;
                Connection c = ctx.getConnection();
                context.tunnelEstablished(c);
                try {
                    context.provider.execute(c, context.request, context.handler, context.future, false);
                    return result;
                }
                catch (IOException e) {
                    context.abort(e);
                    return result;
                }
            }
            AsyncHttpClientEventFilter.cleanup(ctx, this.provider);
            AsyncHandler handler = context.handler;
            if (handler != null) {
                try {
                    context.done(handler.onCompleted());
                }
                catch (Throwable e) {
                    context.abort(e);
                }
            } else {
                context.done();
            }
            return result;
        }

        private static GrizzlyWebSocketAdapter createWebSocketAdapter(HttpTransactionContext context) {
            SimpleWebSocket ws = new SimpleWebSocket(context.protocolHandler, new WebSocketListener[0]);
            AsyncHttpProviderConfig<?, ?> config = context.provider.clientConfig.getAsyncHttpProviderConfig();
            boolean bufferFragments = true;
            if (config instanceof GrizzlyAsyncHttpProviderConfig) {
                bufferFragments = (Boolean)((GrizzlyAsyncHttpProviderConfig)config).getProperty(GrizzlyAsyncHttpProviderConfig.Property.BUFFER_WEBSOCKET_FRAGMENTS);
            }
            return new GrizzlyWebSocketAdapter(ws, bufferFragments);
        }

        private static boolean isRedirectAllowed(HttpTransactionContext ctx) {
            return ctx.request.getFollowRedirect() != null ? ctx.request.getFollowRedirect() : ctx.redirectsAllowed;
        }

        private static void cleanup(FilterChainContext ctx, GrizzlyAsyncHttpProvider provider) {
            Connection c = ctx.getConnection();
            HttpTransactionContext context = HttpTransactionContext.cleanupTransaction(c);
            if (!context.provider.connectionManager.canReturnConnection(c) || !context.provider.connectionManager.returnConnection(context.request, c)) {
                if (maximumPooledConnectionExceededReason == null) {
                    maximumPooledConnectionExceededReason = new IOException("Maximum pooled connections exceeded");
                }
                c.closeWithReason(maximumPooledConnectionExceededReason);
            }
        }

        private static boolean redirectCountExceeded(HttpTransactionContext context) {
            return context.redirectCount.get() > context.maxRedirectCount;
        }

        private static boolean isRedirect(int status) {
            return HttpStatus.MOVED_PERMANENTLY_301.statusMatches(status) || HttpStatus.FOUND_302.statusMatches(status) || HttpStatus.SEE_OTHER_303.statusMatches(status) || HttpStatus.TEMPORARY_REDIRECT_307.statusMatches(status) || HttpStatus.PERMANENT_REDIRECT_308.statusMatches(status);
        }

        private static Request newRequest(Uri uri, HttpResponsePacket response, HttpTransactionContext ctx, boolean asGet) {
            RequestBuilder builder = new RequestBuilder(ctx.request);
            if (asGet) {
                builder.setMethod("GET");
            }
            builder.setUrl(uri.toString());
            builder.resetQuery();
            for (String cookieStr : response.getHeaders().values(Header.Cookie)) {
                builder.addOrReplaceCookie(CookieDecoder.decode(cookieStr));
            }
            return builder.build();
        }

        private static final class RedirectHandler
        implements StatusHandler {
            static final RedirectHandler INSTANCE = new RedirectHandler();

            private RedirectHandler() {
            }

            @Override
            public boolean handlesStatus(int statusCode) {
                return AsyncHttpClientEventFilter.isRedirect(statusCode);
            }

            @Override
            public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
                String redirectURL = responsePacket.getHeader(Header.Location);
                if (redirectURL == null) {
                    throw new IllegalStateException("redirect received, but no location header was present");
                }
                Uri orig = httpTransactionContext.lastRedirectURI == null ? httpTransactionContext.request.getUri() : Uri.create(httpTransactionContext.request.getUri(), httpTransactionContext.lastRedirectURI);
                httpTransactionContext.lastRedirectURI = redirectURL;
                Uri uri = Uri.create(orig, redirectURL);
                if (uri.toUrl().equalsIgnoreCase(orig.toUrl())) {
                    httpTransactionContext.statusHandler = null;
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    try {
                        httpTransactionContext.handler.onStatusReceived(httpTransactionContext.responseStatus);
                    }
                    catch (Exception e) {
                        httpTransactionContext.abort(e);
                    }
                    return true;
                }
                Request requestToSend = AsyncHttpClientEventFilter.newRequest(uri, responsePacket, httpTransactionContext, this.sendAsGet(responsePacket, httpTransactionContext));
                ConnectionManager m = httpTransactionContext.provider.connectionManager;
                try {
                    Connection c = m.obtainConnection(requestToSend, httpTransactionContext.future);
                    if (this.switchingSchemes(orig, uri)) {
                        try {
                            this.notifySchemeSwitch(ctx, c, uri);
                        }
                        catch (IOException ioe) {
                            httpTransactionContext.abort(ioe);
                        }
                    }
                    HttpTransactionContext newContext = httpTransactionContext.cloneAndStartTransactionFor(c, requestToSend);
                    httpTransactionContext.future = null;
                    newContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    httpTransactionContext.provider.execute(c, requestToSend, newContext.handler, newContext.future, false);
                    return false;
                }
                catch (Exception e) {
                    httpTransactionContext.abort(e);
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                    return true;
                }
            }

            private boolean sendAsGet(HttpResponsePacket response, HttpTransactionContext ctx) {
                int statusCode = response.getStatus();
                return statusCode >= 302 && statusCode <= 303 && (statusCode != 302 || !ctx.provider.clientConfig.isStrict302Handling());
            }

            private boolean switchingSchemes(Uri oldUri, Uri newUri) {
                return !oldUri.getScheme().equals(newUri.getScheme());
            }

            private void notifySchemeSwitch(FilterChainContext ctx, Connection c, Uri uri) throws IOException {
                ctx.notifyDownstream((FilterChainEvent)new SwitchingSSLFilter.SSLSwitchingEvent("https".equals(uri.getScheme()), c));
            }
        }

        private static final class AuthorizationHandler
        implements StatusHandler {
            static final AuthorizationHandler INSTANCE = new AuthorizationHandler();

            private AuthorizationHandler() {
            }

            @Override
            public boolean handlesStatus(int statusCode) {
                return HttpStatus.UNAUTHORIZED_401.statusMatches(statusCode);
            }

            @Override
            public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
                String auth = responsePacket.getHeader(Header.WWWAuthenticate);
                if (auth == null) {
                    throw new IllegalStateException("401 response received, but no WWW-Authenticate header was present");
                }
                Realm realm = httpTransactionContext.request.getRealm();
                if (realm == null) {
                    realm = httpTransactionContext.provider.clientConfig.getRealm();
                }
                if (realm == null) {
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    if (httpTransactionContext.handler != null) {
                        try {
                            httpTransactionContext.handler.onStatusReceived(httpTransactionContext.responseStatus);
                        }
                        catch (Exception e) {
                            httpTransactionContext.abort(e);
                        }
                    }
                    return true;
                }
                responsePacket.setSkipRemainder(true);
                Request req = httpTransactionContext.request;
                realm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getScheme()).setUri(httpTransactionContext.request.getUri()).setMethodName(req.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(auth).build();
                String lowerCaseAuth = auth.toLowerCase(Locale.ENGLISH);
                if (lowerCaseAuth.startsWith("basic")) {
                    req.getHeaders().remove(Header.Authorization.toString());
                    req.getHeaders().add(Header.Authorization.toString(), AuthenticatorUtils.computeBasicAuthentication(realm));
                } else if (lowerCaseAuth.startsWith("digest")) {
                    req.getHeaders().remove(Header.Authorization.toString());
                    req.getHeaders().add(Header.Authorization.toString(), AuthenticatorUtils.computeDigestAuthentication(realm));
                } else {
                    throw new IllegalStateException("Unsupported authorization method: " + auth);
                }
                ConnectionManager m = httpTransactionContext.provider.connectionManager;
                try {
                    Connection c = m.obtainConnection(req, httpTransactionContext.future);
                    HttpTransactionContext newContext = httpTransactionContext.cloneAndStartTransactionFor(c);
                    httpTransactionContext.future = null;
                    newContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    try {
                        httpTransactionContext.provider.execute(c, req, httpTransactionContext.handler, httpTransactionContext.future, false);
                        return false;
                    }
                    catch (IOException ioe) {
                        newContext.abort(ioe);
                        return false;
                    }
                }
                catch (Exception e) {
                    httpTransactionContext.abort(e);
                    httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                    return false;
                }
            }
        }
    }

    private final class AsyncHttpClientFilter
    extends BaseFilter {
        private final AsyncHttpClientConfig config;

        AsyncHttpClientFilter(AsyncHttpClientConfig config) {
            this.config = config;
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            Object message = ctx.getMessage();
            if (message instanceof Request) {
                ctx.setMessage(null);
                if (!this.sendAsGrizzlyRequest((Request)message, ctx)) {
                    return ctx.getSuspendAction();
                }
            } else if (message instanceof Buffer) {
                return ctx.getInvokeAction();
            }
            return ctx.getStopAction();
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            Object type = event.type();
            if (type == ContinueEvent.class) {
                ContinueEvent continueEvent = (ContinueEvent)event;
                ((ExpectHandler)((ContinueEvent)continueEvent).context.bodyHandler).finish(ctx);
            }
            return ctx.getStopAction();
        }

        private boolean sendAsGrizzlyRequest(Request request, FilterChainContext ctx) throws IOException {
            HttpRequestPacket requestPacket;
            BodyHandler bodyHandler;
            boolean isEstablishingConnectTunnel;
            Connection connection = ctx.getConnection();
            HttpTransactionContext httpCtx = HttpTransactionContext.currentTransaction(connection);
            if (this.isUpgradeRequest(httpCtx.handler) && this.isWSRequest(httpCtx.requestUri)) {
                httpCtx.isWSRequest = true;
                this.convertToUpgradeRequest(httpCtx);
            }
            Request req = httpCtx.request;
            Method method = Method.valueOf((String)request.getMethod());
            Uri uri = req.getUri();
            boolean secure = "https".equals(uri.getScheme());
            ProxyServer proxy = ProxyUtils.getProxyServer(this.config, request);
            boolean useProxy = proxy != null;
            boolean bl = isEstablishingConnectTunnel = useProxy && (secure || httpCtx.isWSRequest) && !httpCtx.isTunnelEstablished(connection);
            if (isEstablishingConnectTunnel) {
                return this.establishConnectTunnel(proxy, httpCtx, uri, ctx);
            }
            HttpRequestPacket.Builder builder = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().protocol(Protocol.HTTP_1_1)).method(method);
            if (useProxy) {
                if (secure || httpCtx.isWSRequest) {
                    if (this.config.isUseRelativeURIsWithConnectProxies()) {
                        builder.uri(AsyncHttpProviderUtils.getNonEmptyPath(uri));
                        builder.query(uri.getQuery());
                    } else {
                        builder.uri(uri.toUrl());
                    }
                } else {
                    builder.uri(uri.toUrl());
                }
            } else {
                builder.uri(AsyncHttpProviderUtils.getNonEmptyPath(uri));
                builder.query(uri.getQuery());
            }
            BodyHandler bodyHandler2 = bodyHandler = this.isPayloadAllowed(method) ? GrizzlyAsyncHttpProvider.this.bodyHandlerFactory.getBodyHandler(request) : null;
            if (bodyHandler != null) {
                long contentLength = request.getContentLength();
                if (contentLength >= 0L) {
                    builder.contentLength(contentLength);
                    builder.chunked(false);
                } else {
                    builder.chunked(true);
                }
            }
            if (httpCtx.isWSRequest) {
                try {
                    URI wsURI = httpCtx.wsRequestURI.toJavaNetURI();
                    secure = "wss".equalsIgnoreCase(wsURI.getScheme());
                    httpCtx.protocolHandler = Version.RFC6455.createHandler(true);
                    httpCtx.handshake = httpCtx.protocolHandler.createClientHandShake(wsURI);
                    requestPacket = (HttpRequestPacket)httpCtx.handshake.composeHeaders().getHttpHeader();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid WS URI: " + httpCtx.wsRequestURI);
                }
            } else {
                requestPacket = builder.build();
            }
            requestPacket.setSecure(secure);
            ctx.notifyDownstream((FilterChainEvent)new SwitchingSSLFilter.SSLSwitchingEvent(secure, connection));
            this.copyHeaders(request, requestPacket);
            this.addCookies(request, requestPacket);
            this.addHostHeaderIfNeeded(request, uri, requestPacket);
            this.addServiceHeaders(requestPacket);
            this.addAcceptHeaders(requestPacket);
            this.addAuthorizationHeader(this.getRealm(request), requestPacket);
            if (useProxy) {
                this.addProxyHeaders(proxy, requestPacket);
            }
            return GrizzlyAsyncHttpProvider.this.sendRequest(httpCtx, ctx, requestPacket, this.wrapWithExpectHandlerIfNeeded(bodyHandler, requestPacket));
        }

        private boolean establishConnectTunnel(ProxyServer proxy, HttpTransactionContext httpCtx, Uri uri, FilterChainContext ctx) throws IOException {
            Connection connection = ctx.getConnection();
            HttpRequestPacket requestPacket = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().protocol(Protocol.HTTP_1_0)).method(Method.CONNECT).uri(AsyncHttpProviderUtils.getAuthority(uri)).build();
            httpCtx.establishingTunnel = true;
            ctx.notifyDownstream((FilterChainEvent)new SwitchingSSLFilter.SSLSwitchingEvent(false, connection));
            Request request = httpCtx.request;
            this.addHostHeaderIfNeeded(request, uri, requestPacket);
            this.addServiceHeaders(requestPacket);
            this.addAuthorizationHeader(this.getRealm(request), requestPacket);
            this.addProxyHeaders(proxy, requestPacket);
            return GrizzlyAsyncHttpProvider.this.sendRequest(httpCtx, ctx, requestPacket, null);
        }

        private BodyHandler wrapWithExpectHandlerIfNeeded(BodyHandler bodyHandler, HttpRequestPacket requestPacket) {
            if (bodyHandler == null) {
                return null;
            }
            MimeHeaders headers = requestPacket.getHeaders();
            int expectHeaderIdx = headers.indexOf(Header.Expect, 0);
            return expectHeaderIdx != -1 && headers.getValue(expectHeaderIdx).equalsIgnoreCase("100-Continue") ? new ExpectHandler(bodyHandler) : bodyHandler;
        }

        private boolean isPayloadAllowed(Method method) {
            return method.getPayloadExpectation() != Method.PayloadExpectation.NOT_ALLOWED;
        }

        private void addAuthorizationHeader(Realm realm, HttpRequestPacket requestPacket) {
            String authHeaderValue;
            if (realm != null && realm.getUsePreemptiveAuth() && (authHeaderValue = this.generateAuthHeader(realm)) != null) {
                requestPacket.addHeader(Header.Authorization, authHeaderValue);
            }
        }

        private void addProxyHeaders(ProxyServer proxy, HttpRequestPacket requestPacket) {
            if (!requestPacket.getHeaders().contains(Header.ProxyConnection)) {
                requestPacket.setHeader(Header.ProxyConnection, "keep-alive");
            }
            if (proxy.getPrincipal() != null) {
                requestPacket.setHeader(Header.ProxyAuthorization, AuthenticatorUtils.computeBasicAuthentication(proxy));
            }
        }

        private void addHostHeaderIfNeeded(Request request, Uri uri, HttpRequestPacket requestPacket) {
            if (!requestPacket.containsHeader(Header.Host)) {
                String host = request.getVirtualHost();
                if (host != null) {
                    requestPacket.addHeader(Header.Host, host);
                } else if (uri.getPort() == -1) {
                    requestPacket.addHeader(Header.Host, uri.getHost());
                } else {
                    requestPacket.addHeader(Header.Host, uri.getHost() + ':' + uri.getPort());
                }
            }
        }

        private Realm getRealm(Request request) {
            return request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        }

        private String generateAuthHeader(Realm realm) {
            try {
                switch (realm.getScheme()) {
                    case BASIC: {
                        return AuthenticatorUtils.computeBasicAuthentication(realm);
                    }
                    case DIGEST: {
                        return AuthenticatorUtils.computeDigestAuthentication(realm);
                    }
                    case NTLM: {
                        return ntlmEngine.generateType1Msg();
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isUpgradeRequest(AsyncHandler handler) {
            return handler instanceof UpgradeHandler;
        }

        private boolean isWSRequest(Uri requestUri) {
            return requestUri.getScheme().startsWith("ws");
        }

        private void convertToUpgradeRequest(HttpTransactionContext ctx) {
            Uri requestUri;
            ctx.wsRequestURI = requestUri = ctx.requestUri;
            ctx.requestUri = requestUri.withNewScheme("ws".equals(requestUri.getScheme()) ? "http" : "https");
        }

        private void copyHeaders(Request request, HttpRequestPacket requestPacket) {
            FluentCaseInsensitiveStringsMap map = request.getHeaders();
            if (MiscUtils.isNonEmpty(map)) {
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String headerName = entry.getKey();
                    List<String> headerValues = entry.getValue();
                    if (!MiscUtils.isNonEmpty(headerValues)) continue;
                    for (String headerValue : headerValues) {
                        requestPacket.addHeader(headerName, headerValue);
                    }
                }
            }
        }

        private void addServiceHeaders(HttpRequestPacket requestPacket) {
            MimeHeaders headers = requestPacket.getHeaders();
            if (!headers.contains(Header.Connection)) {
                requestPacket.addHeader(Header.Connection, "keep-alive");
            }
            if (!headers.contains(Header.UserAgent)) {
                requestPacket.addHeader(Header.UserAgent, this.config.getUserAgent());
            }
        }

        private void addAcceptHeaders(HttpRequestPacket requestPacket) {
            MimeHeaders headers = requestPacket.getHeaders();
            if (GrizzlyAsyncHttpProvider.this.clientConfig.isCompressionEnforced() && !headers.contains(Header.AcceptEncoding)) {
                requestPacket.addHeader(Header.AcceptEncoding, "gzip");
            }
            if (!headers.contains(Header.Accept)) {
                requestPacket.addHeader(Header.Accept, "*/*");
            }
        }

        private void addCookies(Request request, HttpRequestPacket requestPacket) {
            Collection<Cookie> cookies = request.getCookies();
            if (MiscUtils.isNonEmpty(cookies)) {
                StringBuilder sb = new StringBuilder(128);
                org.glassfish.grizzly.http.Cookie[] gCookies = new org.glassfish.grizzly.http.Cookie[cookies.size()];
                this.convertCookies(cookies, gCookies);
                CookieSerializerUtils.serializeClientCookies((StringBuilder)sb, (org.glassfish.grizzly.http.Cookie[])gCookies);
                requestPacket.addHeader(Header.Cookie, sb.toString());
            }
        }

        private void convertCookies(Collection<Cookie> cookies, org.glassfish.grizzly.http.Cookie[] gCookies) {
            int idx = 0;
            for (Cookie cookie : cookies) {
                gCookies[idx++] = new org.glassfish.grizzly.http.Cookie(cookie.getName(), cookie.getValue());
            }
        }
    }

    public static class GracefulCloseEvent
    implements FilterChainEvent {
        private final HttpTransactionContext httpTxContext;

        public GracefulCloseEvent(HttpTransactionContext httpTxContext) {
            this.httpTxContext = httpTxContext;
        }

        public HttpTransactionContext getHttpTxContext() {
            return this.httpTxContext;
        }

        public Object type() {
            return GracefulCloseEvent.class;
        }
    }

    private static final class ContinueEvent
    implements FilterChainEvent {
        private final HttpTransactionContext context;

        ContinueEvent(HttpTransactionContext context) {
            this.context = context;
        }

        public Object type() {
            return ContinueEvent.class;
        }
    }
}

