/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.providers.grizzly.ConnectionPool;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyConnectionPool;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.HostnameVerifierListener;
import com.ning.http.client.providers.grizzly.Utils;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.ProxyUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HostnameVerifier;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;

class ConnectionManager {
    private static final Attribute<Boolean> DO_NOT_CACHE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(ConnectionManager.class.getName());
    private final ConnectionPool pool;
    private final TCPNIOConnectorHandler connectionHandler;
    private final ConnectionMonitor connectionMonitor;
    private final GrizzlyAsyncHttpProvider provider;
    private final AsyncHttpClientConfig config;

    ConnectionManager(GrizzlyAsyncHttpProvider provider, TCPNIOTransport transport, GrizzlyAsyncHttpProviderConfig providerConfig) {
        ConnectionPool connectionPool;
        this.provider = provider;
        this.config = provider.getClientConfig();
        if (this.config.isAllowPoolingConnections()) {
            ConnectionPool providedPool = providerConfig != null ? providerConfig.getConnectionPool() : null;
            connectionPool = providedPool != null ? providedPool : new GrizzlyConnectionPool(this.config);
        } else {
            connectionPool = new NonCachingPool();
        }
        this.pool = connectionPool;
        this.connectionHandler = TCPNIOConnectorHandler.builder((TCPNIOTransport)transport).build();
        int maxConns = this.config.getMaxConnections();
        this.connectionMonitor = new ConnectionMonitor(maxConns);
    }

    static void markConnectionAsDoNotCache(Connection c) {
        DO_NOT_CACHE.set((AttributeStorage)c, (Object)Boolean.TRUE);
    }

    static boolean isConnectionCacheable(Connection c) {
        Boolean canCache = (Boolean)DO_NOT_CACHE.get((AttributeStorage)c);
        return canCache != null ? canCache : false;
    }

    void doAsyncTrackedConnection(Request request, GrizzlyResponseFuture requestFuture, CompletionHandler<Connection> connectHandler) throws IOException, ExecutionException, InterruptedException {
        Connection c = this.pool.poll(ConnectionManager.getPartitionId(request, requestFuture.getProxy()));
        if (c == null) {
            if (!this.connectionMonitor.acquire()) {
                throw new IOException("Max connections exceeded");
            }
            this.doAsyncConnect(request, requestFuture, connectHandler);
        } else {
            this.provider.touchConnection(c, request);
            connectHandler.completed((Object)c);
        }
    }

    Connection obtainConnection(Request request, GrizzlyResponseFuture requestFuture) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        Connection c = this.obtainConnection0(request, requestFuture);
        DO_NOT_CACHE.set((AttributeStorage)c, (Object)Boolean.TRUE);
        return c;
    }

    void doAsyncConnect(Request request, GrizzlyResponseFuture requestFuture, CompletionHandler<Connection> connectHandler) throws IOException, ExecutionException, InterruptedException {
        ProxyServer proxy = requestFuture.getProxy();
        Uri uri = request.getUri();
        String host = proxy != null ? proxy.getHost() : uri.getHost();
        int port = proxy != null ? proxy.getPort() : uri.getPort();
        CompletionHandler<Connection> completionHandler = this.createConnectionCompletionHandler(request, requestFuture, connectHandler);
        HostnameVerifier verifier = this.config.getHostnameVerifier();
        if (Utils.isSecure(uri) && verifier != null) {
            completionHandler = HostnameVerifierListener.wrapWithHostnameVerifierHandler(completionHandler, verifier, uri.getHost());
        }
        if (request.getLocalAddress() != null) {
            this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host, ConnectionManager.getPort(uri, port)), (SocketAddress)new InetSocketAddress(request.getLocalAddress(), 0), completionHandler);
        } else {
            this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host, ConnectionManager.getPort(uri, port)), completionHandler);
        }
    }

    private Connection obtainConnection0(Request request, GrizzlyResponseFuture requestFuture) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        Uri uri = request.getUri();
        ProxyServer proxy = requestFuture.getProxy();
        String host = proxy != null ? proxy.getHost() : uri.getHost();
        int port = proxy != null ? proxy.getPort() : uri.getPort();
        int cTimeout = this.config.getConnectTimeout();
        FutureImpl future = Futures.createSafeFuture();
        CompletionHandler ch = Futures.toCompletionHandler((FutureImpl)future, this.createConnectionCompletionHandler(request, requestFuture, null));
        if (cTimeout > 0) {
            this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host, ConnectionManager.getPort(uri, port)), ch);
            return (Connection)future.get((long)cTimeout, TimeUnit.MILLISECONDS);
        }
        this.connectionHandler.connect((SocketAddress)new InetSocketAddress(host, ConnectionManager.getPort(uri, port)), ch);
        return (Connection)future.get();
    }

    boolean returnConnection(Request request, Connection c) {
        boolean result;
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        boolean bl = result = DO_NOT_CACHE.get((AttributeStorage)c) == null && this.pool.offer(ConnectionManager.getPartitionId(request, proxyServer), c);
        if (result && this.provider.resolver != null) {
            this.provider.resolver.setTimeoutMillis((Object)c, IdleTimeoutFilter.FOREVER.longValue());
        }
        return result;
    }

    boolean canReturnConnection(Connection c) {
        return DO_NOT_CACHE.get((AttributeStorage)c) != null || this.pool.canCacheConnection();
    }

    void destroy() {
        this.pool.destroy();
    }

    CompletionHandler<Connection> createConnectionCompletionHandler(final Request request, final GrizzlyResponseFuture future, final CompletionHandler<Connection> wrappedHandler) {
        return new CompletionHandler<Connection>(){

            public void cancelled() {
                if (wrappedHandler != null) {
                    wrappedHandler.cancelled();
                } else {
                    future.cancel(true);
                }
            }

            public void failed(Throwable throwable) {
                if (wrappedHandler != null) {
                    wrappedHandler.failed(throwable);
                } else {
                    future.abort(throwable);
                }
            }

            public void completed(Connection connection) {
                future.setConnection(connection);
                ConnectionManager.this.provider.touchConnection(connection, request);
                if (wrappedHandler != null) {
                    connection.addCloseListener((Connection.CloseListener)ConnectionManager.this.connectionMonitor);
                    wrappedHandler.completed((Object)connection);
                }
            }

            public void updated(Connection result) {
                if (wrappedHandler != null) {
                    wrappedHandler.updated((Object)result);
                }
            }
        };
    }

    private static String getPartitionId(Request request, ProxyServer proxyServer) {
        return request.getConnectionPoolPartitioning().getPartitionId(request.getUri(), proxyServer);
    }

    private static int getPort(Uri uri, int p) {
        int port = p;
        if (port == -1) {
            String protocol = uri.getScheme().toLowerCase(Locale.ENGLISH);
            if ("http".equals(protocol) || "ws".equals(protocol)) {
                port = 80;
            } else if ("https".equals(protocol) || "wss".equals(protocol)) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown protocol: " + protocol);
            }
        }
        return port;
    }

    private static final class NonCachingPool
    implements ConnectionPool {
        private NonCachingPool() {
        }

        @Override
        public boolean offer(String uri, Connection connection) {
            return false;
        }

        @Override
        public Connection poll(String uri) {
            return null;
        }

        @Override
        public boolean removeAll(Connection connection) {
            return false;
        }

        @Override
        public boolean canCacheConnection() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    private static class ConnectionMonitor
    implements Connection.CloseListener {
        private final Semaphore connections;

        ConnectionMonitor(int maxConnections) {
            this.connections = maxConnections != -1 ? new Semaphore(maxConnections) : null;
        }

        public boolean acquire() {
            return this.connections == null || this.connections.tryAcquire();
        }

        public void onClosed(Connection connection, Connection.CloseType closeType) throws IOException {
            if (this.connections != null) {
                this.connections.release();
            }
        }
    }
}

