/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.listenable.AbstractListenableFuture;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.utils.Futures;

final class GrizzlyResponseFuture<V>
extends AbstractListenableFuture<V>
implements CompletionHandler<V> {
    private final AsyncHandler handler;
    private final GrizzlyAsyncHttpProvider provider;
    private final Request request;
    private final ProxyServer proxy;
    private Connection connection;
    private final FutureImpl<V> delegate;

    GrizzlyResponseFuture(GrizzlyAsyncHttpProvider provider, Request request, AsyncHandler handler, ProxyServer proxy) {
        this.provider = provider;
        this.request = request;
        this.handler = handler;
        this.proxy = proxy;
        this.delegate = Futures.createSafeFuture();
        this.delegate.addCompletionHandler((CompletionHandler)this);
    }

    @Override
    public void done() {
        this.done(null);
    }

    public void done(V result) {
        this.delegate.result(result);
    }

    @Override
    public void abort(Throwable t) {
        this.delegate.failure(t);
    }

    @Override
    public void touch() {
        this.provider.touchConnection(this.connection, this.request);
    }

    public boolean getAndSetWriteHeaders(boolean writeHeaders) {
        return writeHeaders;
    }

    public boolean getAndSetWriteBody(boolean writeBody) {
        return writeBody;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.delegate.get(timeout, unit);
    }

    public void cancelled() {
        if (this.handler != null) {
            try {
                this.handler.onThrowable(new CancellationException());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.runListeners();
    }

    public void failed(Throwable t) {
        if (this.handler != null) {
            try {
                this.handler.onThrowable(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.closeConnection();
        this.runListeners();
    }

    public void completed(V result) {
        this.runListeners();
    }

    public void updated(V result) {
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    private void closeConnection() {
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.closeSilently();
        }
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }
}

