/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.uri;

import com.ning.http.client.uri.UriComponentsParser;
import com.ning.http.util.MiscUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class UriComponents {
    private final String scheme;
    private final String userInfo;
    private final String host;
    private final int port;
    private final String query;
    private final String path;

    public static UriComponents create(String originalUrl) {
        return UriComponents.create(null, originalUrl);
    }

    public static UriComponents create(UriComponents context, String originalUrl) {
        UriComponentsParser parser = new UriComponentsParser();
        parser.parse(context, originalUrl);
        return new UriComponents(parser.scheme, parser.userInfo, parser.host, parser.port, parser.path, parser.query);
    }

    public UriComponents(String scheme, String userInfo, String host, int port, String path, String query) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.toUrl());
    }

    public String toUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.scheme).append("://");
        if (this.userInfo != null) {
            sb.append(this.userInfo).append('@');
        }
        sb.append(this.host);
        if (this.port != -1) {
            sb.append(':').append(this.port);
        }
        if (this.path != null) {
            sb.append(this.path);
        }
        if (this.query != null) {
            sb.append('?').append(this.query);
        }
        return sb.toString();
    }

    public String toRelativeUrl() {
        StringBuilder sb = new StringBuilder();
        if (MiscUtils.isNonEmpty(this.path)) {
            sb.append(this.path);
        } else {
            sb.append('/');
        }
        if (this.query != null) {
            sb.append('?').append(this.query);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toUrl();
    }

    public UriComponents withNewScheme(String newScheme) {
        return new UriComponents(newScheme, this.userInfo, this.host, this.port, this.path, this.query);
    }

    public UriComponents withNewQuery(String newQuery) {
        return new UriComponents(this.scheme, this.userInfo, this.host, this.port, this.path, newQuery);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriComponents other = (UriComponents)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.userInfo == null ? other.userInfo != null : !this.userInfo.equals(other.userInfo));
    }
}

