/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Param;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.cookie.CookieEncoder;
import com.ning.http.client.generators.FileBodyGenerator;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.request.NettyRequest;
import com.ning.http.client.providers.netty.request.body.NettyBody;
import com.ning.http.client.providers.netty.request.body.NettyBodyBody;
import com.ning.http.client.providers.netty.request.body.NettyByteArrayBody;
import com.ning.http.client.providers.netty.request.body.NettyFileBody;
import com.ning.http.client.providers.netty.request.body.NettyInputStreamBody;
import com.ning.http.client.providers.netty.request.body.NettyMultipartBody;
import com.ning.http.client.providers.netty.spnego.SpnegoEngine;
import com.ning.http.client.providers.netty.util.HttpUtils;
import com.ning.http.client.providers.netty.ws.WebSocketUtils;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;

public final class NettyRequestFactory {
    public static final String GZIP_DEFLATE = "gzip,deflate";
    private final AsyncHttpClientConfig config;
    private final NettyAsyncHttpProviderConfig nettyConfig;

    public NettyRequestFactory(AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig) {
        this.config = config;
        this.nettyConfig = nettyConfig;
    }

    private String requestUri(UriComponents uri, ProxyServer proxyServer, HttpMethod method) {
        if (method == HttpMethod.CONNECT) {
            return AsyncHttpProviderUtils.getAuthority(uri);
        }
        if (!(proxyServer == null || HttpUtils.useProxyConnect(uri) && this.config.isUseRelativeURIsWithConnectProxies())) {
            return uri.toString();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath(uri);
        if (MiscUtils.isNonEmpty(uri.getQuery())) {
            return path + "?" + uri.getQuery();
        }
        return path;
    }

    private String hostHeader(Request request, UriComponents uri) {
        String host = request.getVirtualHost() != null ? request.getVirtualHost() : uri.getHost();
        return request.getVirtualHost() != null || uri.getPort() == -1 ? host : host + ":" + uri.getPort();
    }

    private String authorizationHeader(Request request, UriComponents uri, ProxyServer proxyServer, Realm realm) throws IOException {
        String authorizationHeader = null;
        if (realm != null && realm.getUsePreemptiveAuth()) {
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    try {
                        authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm);
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                case NTLM: {
                    String domain = proxyServer != null && proxyServer.getNtlmDomain() != null ? proxyServer.getNtlmDomain() : realm.getNtlmDomain();
                    try {
                        String msg = NTLMEngine.INSTANCE.generateType1Msg("NTLM " + domain, realm.getNtlmHost());
                        authorizationHeader = "NTLM " + msg;
                        break;
                    }
                    catch (NTLMEngineException e) {
                        throw new IOException(e);
                    }
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request.getVirtualHost() != null ? request.getVirtualHost() : uri.getHost());
                    try {
                        authorizationHeader = "Negotiate " + SpnegoEngine.INSTANCE.generateToken(host);
                        break;
                    }
                    catch (Throwable e) {
                        throw new IOException(e);
                    }
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return authorizationHeader;
    }

    private String proxyAuthorizationHeader(Request request, ProxyServer proxyServer, HttpMethod method) throws IOException {
        String proxyAuthorization = null;
        if (method == HttpMethod.CONNECT) {
            Object auth = request.getHeaders().get("Proxy-Authorization");
            if (HttpUtils.isNTLM((List<String>)auth)) {
                proxyAuthorization = (String)auth.get(0);
            }
        } else if (proxyServer != null && proxyServer.getPrincipal() != null) {
            if (MiscUtils.isNonEmpty(proxyServer.getNtlmDomain())) {
                Object auth = request.getHeaders().get("Proxy-Authorization");
                if (!HttpUtils.isNTLM((List<String>)auth)) {
                    try {
                        String msg = NTLMEngine.INSTANCE.generateType1Msg(proxyServer.getNtlmDomain(), proxyServer.getHost());
                        proxyAuthorization = "NTLM " + msg;
                    }
                    catch (NTLMEngineException e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                }
            } else {
                proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyServer);
            }
        }
        return proxyAuthorization;
    }

    private byte[] computeBodyFromParams(List<Param> params, Charset bodyCharset) {
        StringBuilder sb = new StringBuilder();
        for (Param param : params) {
            UTF8UrlEncoder.appendEncoded(sb, param.getName());
            sb.append("=");
            UTF8UrlEncoder.appendEncoded(sb, param.getValue());
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString().getBytes(bodyCharset);
    }

    private NettyBody body(Request request, HttpMethod method) throws IOException {
        NettyBody nettyBody = null;
        if (method != HttpMethod.CONNECT) {
            Charset bodyCharset;
            Charset charset = bodyCharset = request.getBodyEncoding() == null ? AsyncHttpProviderUtils.DEFAULT_CHARSET : Charset.forName(request.getBodyEncoding());
            if (request.getByteData() != null) {
                nettyBody = new NettyByteArrayBody(request.getByteData());
            } else if (request.getStringData() != null) {
                nettyBody = new NettyByteArrayBody(request.getStringData().getBytes(bodyCharset));
            } else if (request.getStreamData() != null) {
                nettyBody = new NettyInputStreamBody(request.getStreamData());
            } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
                String contentType = null;
                if (!request.getHeaders().containsKey("Content-Type")) {
                    contentType = "application/x-www-form-urlencoded";
                }
                nettyBody = new NettyByteArrayBody(this.computeBodyFromParams(request.getFormParams(), bodyCharset), contentType);
            } else if (MiscUtils.isNonEmpty(request.getParts())) {
                nettyBody = new NettyMultipartBody(request.getParts(), request.getHeaders(), this.nettyConfig);
            } else if (request.getFile() != null) {
                nettyBody = new NettyFileBody(request.getFile(), this.nettyConfig);
            } else if (request.getBodyGenerator() instanceof FileBodyGenerator) {
                FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request.getBodyGenerator();
                nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.nettyConfig);
            } else if (request.getBodyGenerator() instanceof InputStreamBodyGenerator) {
                nettyBody = new NettyInputStreamBody(((InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request.getBodyGenerator())).getInputStream());
            } else if (request.getBodyGenerator() != null) {
                nettyBody = new NettyBodyBody(request.getBodyGenerator().createBody(), this.nettyConfig);
            }
        }
        return nettyBody;
    }

    public NettyRequest newNettyRequest(Request request, UriComponents uri, boolean forceConnect, ProxyServer proxyServer) throws IOException {
        String proxyAuthorizationHeader;
        Realm realm;
        String authorizationHeader;
        NettyRequest nettyRequest;
        DefaultHttpRequest httpRequest;
        HttpMethod method = forceConnect ? HttpMethod.CONNECT : HttpMethod.valueOf((String)request.getMethod());
        HttpVersion httpVersion = method == HttpMethod.CONNECT ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, method);
        NettyBody body = this.body(request, method);
        if (body instanceof NettyByteArrayBody) {
            byte[] bytes = ((NettyByteArrayBody)NettyByteArrayBody.class.cast(body)).getBytes();
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            httpRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])bytes));
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, body);
        }
        if (method != HttpMethod.CONNECT) {
            for (Map.Entry<String, List<String>> header : request.getHeaders()) {
                httpRequest.headers().set(header.getKey(), (Iterable)header.getValue());
            }
            if (MiscUtils.isNonEmpty(request.getCookies())) {
                httpRequest.headers().set("Cookie", (Object)CookieEncoder.encode(request.getCookies()));
            }
            if (this.config.isCompressionEnabled()) {
                httpRequest.headers().set("Accept-Encoding", (Object)GZIP_DEFLATE);
            }
        }
        if (body != null) {
            if (body.getContentLength() > 0L) {
                httpRequest.headers().set("Content-Length", (Object)body.getContentLength());
            } else {
                httpRequest.headers().set("Transfer-Encoding", (Object)"chunked");
            }
            if (body.getContentType() != null) {
                httpRequest.headers().set("Content-Type", (Object)body.getContentType());
            }
        }
        boolean webSocket = HttpUtils.isWebSocket(uri.getScheme());
        if (method != HttpMethod.CONNECT && webSocket) {
            String origin = "http://" + uri.getHost() + ":" + (uri.getPort() == -1 ? (HttpUtils.isSecure(uri.getScheme()) ? 443 : 80) : uri.getPort());
            httpRequest.headers().set("Upgrade", (Object)"WebSocket").set("Connection", (Object)"Upgrade").set("Origin", (Object)origin).set("Sec-WebSocket-Key", (Object)WebSocketUtils.getKey()).set("Sec-WebSocket-Version", (Object)"13");
        } else if (!httpRequest.headers().contains("Connection")) {
            httpRequest.headers().set("Connection", (Object)AsyncHttpProviderUtils.keepAliveHeaderValue(this.config));
        }
        String hostHeader = this.hostHeader(request, uri);
        if (hostHeader != null) {
            httpRequest.headers().set("Host", (Object)hostHeader);
        }
        if ((authorizationHeader = this.authorizationHeader(request, uri, proxyServer, realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm())) != null) {
            httpRequest.headers().add("Authorization", (Object)authorizationHeader);
        }
        if ((proxyAuthorizationHeader = this.proxyAuthorizationHeader(request, proxyServer, method)) != null) {
            httpRequest.headers().set("Proxy-Authorization", (Object)proxyAuthorizationHeader);
        }
        if (!httpRequest.headers().contains("Accept")) {
            httpRequest.headers().set("Accept", (Object)"*/*");
        }
        if (!httpRequest.headers().contains("User-Agent") && this.config.getUserAgent() != null) {
            httpRequest.headers().set("User-Agent", (Object)this.config.getUserAgent());
        }
        return nettyRequest;
    }
}

