/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.handler;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.providers.netty.DiscardEvent;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.handler.Protocol;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.ning.http.client.providers.netty.response.NettyResponseBodyPart;
import com.ning.http.client.providers.netty.response.NettyResponseHeaders;
import com.ning.http.client.providers.netty.response.NettyResponseStatus;
import com.ning.http.client.providers.netty.ws.NettyWebSocket;
import com.ning.http.client.providers.netty.ws.WebSocketUtils;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.util.StandardCharsets;
import java.io.IOException;
import java.util.Locale;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;

public final class WebSocketProtocol
extends Protocol {
    public WebSocketProtocol(ChannelManager channelManager, AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, NettyRequestSender requestSender) {
        super(channelManager, config, nettyConfig, requestSender);
    }

    private void invokeOnSucces(Channel channel, WebSocketUpgradeHandler h) {
        if (!h.touchSuccess()) {
            try {
                h.onSuccess(new NettyWebSocket(channel));
            }
            catch (Exception ex) {
                this.logger.warn("onSuccess unexpected exception", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        WebSocketUpgradeHandler handler = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(future.getAsyncHandler());
        Request request = future.getRequest();
        if (e instanceof HttpResponse) {
            boolean headerOK;
            boolean statusReceived;
            NettyResponseHeaders responseHeaders;
            HttpResponse response = (HttpResponse)e;
            NettyResponseStatus status = new NettyResponseStatus(future.getURI(), this.config, response);
            if (this.exitAfterProcessingFilters(channel, future, handler, status, responseHeaders = new NettyResponseHeaders(response.headers()))) {
                return;
            }
            future.setHttpHeaders(response.headers());
            if (this.exitAfterHandlingRedirect(channel, future, response, request, response.getStatus().getCode())) {
                return;
            }
            boolean validStatus = response.getStatus().equals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS);
            boolean validUpgrade = response.headers().get("Upgrade") != null;
            String c = response.headers().get("Connection");
            if (c == null) {
                c = response.headers().get("Connection".toLowerCase(Locale.ENGLISH));
            }
            boolean validConnection = c != null && c.equalsIgnoreCase("Upgrade");
            status = new NettyResponseStatus(future.getURI(), this.config, response);
            boolean bl = statusReceived = handler.onStatusReceived(status) == AsyncHandler.STATE.UPGRADE;
            if (!statusReceived) {
                try {
                    handler.onCompleted();
                }
                finally {
                    future.done();
                }
                return;
            }
            boolean bl2 = headerOK = handler.onHeadersReceived(responseHeaders) == AsyncHandler.STATE.CONTINUE;
            if (!(headerOK && validStatus && validUpgrade && validConnection)) {
                this.requestSender.abort(future, new IOException("Invalid handshake response"));
                return;
            }
            String accept = response.headers().get("Sec-WebSocket-Accept");
            String key = WebSocketUtils.getAcceptKey(future.getNettyRequest().getHttpRequest().headers().get("Sec-WebSocket-Key"));
            if (accept == null || !accept.equals(key)) {
                this.requestSender.abort(future, new IOException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, key)));
            }
            this.channelManager.upgradePipelineForWebSockets(channel.getPipeline());
            this.invokeOnSucces(channel, handler);
            future.done();
        } else if (e instanceof WebSocketFrame) {
            final WebSocketFrame frame = (WebSocketFrame)e;
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(handler.onCompleted());
            this.invokeOnSucces(channel, handler);
            if (webSocket != null) {
                if (frame instanceof CloseWebSocketFrame) {
                    Channels.setDiscard(channel);
                    CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame);
                    webSocket.onClose(closeFrame.getStatusCode(), closeFrame.getReasonText());
                } else if (frame.getBinaryData() != null) {
                    HttpChunk webSocketChunk = new HttpChunk(){
                        private ChannelBuffer content;
                        {
                            this.content = frame.getBinaryData();
                        }

                        public boolean isLast() {
                            return false;
                        }

                        public ChannelBuffer getContent() {
                            return this.content;
                        }

                        public void setContent(ChannelBuffer content) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    NettyResponseBodyPart rp = new NettyResponseBodyPart(null, webSocketChunk, true);
                    handler.onBodyPartReceived(rp);
                    if (frame instanceof BinaryWebSocketFrame) {
                        webSocket.onBinaryFragment(rp.getBodyPartBytes(), frame.isFinalFragment());
                    } else {
                        webSocket.onTextFragment(frame.getBinaryData().toString(StandardCharsets.UTF_8), frame.isFinalFragment());
                    }
                }
            } else {
                this.logger.debug("UpgradeHandler returned a null NettyWebSocket ");
            }
        } else {
            this.logger.error("Invalid message {}", e);
        }
    }

    @Override
    public void onError(Channel channel, Throwable e) {
        try {
            Object attribute = Channels.getAttribute(channel);
            this.logger.warn("onError {}", e);
            if (!(attribute instanceof NettyResponseFuture)) {
                return;
            }
            NettyResponseFuture nettyResponse = (NettyResponseFuture)attribute;
            WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
            if (webSocket != null) {
                webSocket.onError(e.getCause());
                webSocket.close();
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }

    @Override
    public void onClose(Channel channel) {
        this.logger.trace("onClose {}");
        Object attribute = Channels.getAttribute(channel);
        if (!(attribute instanceof NettyResponseFuture)) {
            return;
        }
        try {
            NettyResponseFuture nettyResponse = (NettyResponseFuture)NettyResponseFuture.class.cast(attribute);
            WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
            this.logger.trace("Connection was closed abnormally (that is, with no close frame being sent).");
            if (attribute != DiscardEvent.INSTANCE && webSocket != null) {
                webSocket.close(1006, "Connection was closed abnormally (that is, with no close frame being sent).");
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }
}

