/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request.body;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.jboss.netty.channel.FileRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizedFileRegion
implements FileRegion {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimizedFileRegion.class);
    private final FileChannel file;
    private final RandomAccessFile raf;
    private final long position;
    private final long count;
    private long byteWritten;

    public OptimizedFileRegion(RandomAccessFile raf, long position, long count) {
        this.raf = raf;
        this.file = raf.getChannel();
        this.position = position;
        this.count = count;
    }

    public long getPosition() {
        return this.position;
    }

    public long getCount() {
        return this.count;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long count = this.count - position;
        if (count < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
        }
        if (count == 0L) {
            return 0L;
        }
        long bw = this.file.transferTo(this.position + position, count, target);
        this.byteWritten += bw;
        if (this.byteWritten == this.raf.length()) {
            this.releaseExternalResources();
        }
        return bw;
    }

    public void releaseExternalResources() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close a file.", (Throwable)e);
        }
        try {
            this.raf.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close a file.", (Throwable)e);
        }
    }
}

