/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request.body;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Body;
import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.request.ProgressListener;
import com.ning.http.client.providers.netty.request.body.BodyChunkedInput;
import com.ning.http.client.providers.netty.request.body.BodyFileRegion;
import com.ning.http.client.providers.netty.request.body.NettyBody;
import java.io.IOException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyBodyBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyBodyBody.class);
    private final Body body;
    private final NettyAsyncHttpProviderConfig nettyConfig;

    public NettyBodyBody(Body body, NettyAsyncHttpProviderConfig nettyConfig) {
        this.body = body;
        this.nettyConfig = nettyConfig;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future, AsyncHttpClientConfig config) throws IOException {
        ChannelFuture writeFuture;
        boolean ssl;
        boolean bl = ssl = channel.getPipeline().get(SslHandler.class) != null;
        if (ssl || !(this.body instanceof RandomAccessBody) || this.nettyConfig.isDisableZeroCopy()) {
            BodyChunkedInput bodyChunkedInput = new BodyChunkedInput(this.body);
            writeFuture = channel.write((Object)bodyChunkedInput);
        } else {
            BodyFileRegion bodyFileRegion = new BodyFileRegion((RandomAccessBody)this.body);
            writeFuture = channel.write((Object)bodyFileRegion);
        }
        writeFuture.addListener((ChannelFutureListener)new ProgressListener(config, future.getAsyncHandler(), future, false){

            @Override
            public void operationComplete(ChannelFuture cf) {
                try {
                    NettyBodyBody.this.body.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                }
                super.operationComplete(cf);
            }
        });
    }
}

