/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ConnectionPoolPartitioning;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.request.NettyConnectListener;
import com.ning.http.client.providers.netty.request.NettyRequest;
import com.ning.http.client.providers.netty.request.NettyRequestFactory;
import com.ning.http.client.providers.netty.request.ProgressListener;
import com.ning.http.client.providers.netty.request.timeout.ReadTimeoutTimerTask;
import com.ning.http.client.providers.netty.request.timeout.RequestTimeoutTimerTask;
import com.ning.http.client.providers.netty.request.timeout.TimeoutsHolder;
import com.ning.http.client.providers.netty.util.HttpUtils;
import com.ning.http.client.uri.Uri;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.ProxyUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRequestSender.class);
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final Timer nettyTimer;
    private final AtomicBoolean closed;
    private final NettyRequestFactory requestFactory;
    private final IOException tooManyConnections;

    public NettyRequestSender(AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, ChannelManager channelManager, Timer nettyTimer, AtomicBoolean closed) {
        this.config = config;
        this.channelManager = channelManager;
        this.nettyTimer = nettyTimer;
        this.closed = closed;
        this.requestFactory = new NettyRequestFactory(config, nettyConfig);
        this.tooManyConnections = new IOException(String.format("Too many connections %s", config.getMaxConnections()));
        this.tooManyConnections.setStackTrace(new StackTraceElement[0]);
    }

    public <T> ListenableFuture<T> sendRequest(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache) throws IOException {
        boolean useProxy;
        if (this.closed.get()) {
            throw new IOException("Closed");
        }
        Uri uri = request.getUri();
        if (uri.getScheme().startsWith("ws") && !this.validateWebSocketRequest(request, asyncHandler)) {
            throw new IOException("WebSocket method must be a GET");
        }
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        boolean resultOfAConnect = future != null && future.getNettyRequest() != null && future.getNettyRequest().getHttpRequest().getMethod() == HttpMethod.CONNECT;
        boolean bl = useProxy = proxyServer != null && !resultOfAConnect;
        if (useProxy && HttpUtils.useProxyConnect(uri)) {
            if (future != null && future.isConnectAllowed()) {
                return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, reclaimCache, uri, proxyServer, true, true);
            }
            return this.sendRequestThroughSslProxy(request, asyncHandler, future, reclaimCache, uri, proxyServer);
        }
        return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, reclaimCache, uri, proxyServer, useProxy, false);
    }

    private <T> ListenableFuture<T> sendRequestWithCertainForceConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache, Uri uri, ProxyServer proxyServer, boolean useProxy, boolean forceConnect) throws IOException {
        NettyResponseFuture<T> newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, uri, proxyServer, forceConnect);
        Channel channel = this.getCachedChannel(future, uri, request.getConnectionPoolPartitioning(), proxyServer, asyncHandler);
        if (Channels.isChannelValid(channel)) {
            return this.sendRequestWithCachedChannel(request, uri, proxyServer, newFuture, asyncHandler, channel);
        }
        return this.sendRequestWithNewChannel(request, uri, proxyServer, useProxy, newFuture, asyncHandler, reclaimCache);
    }

    private <T> ListenableFuture<T> sendRequestThroughSslProxy(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache, Uri uri, ProxyServer proxyServer) throws IOException {
        NettyResponseFuture<T> newFuture = null;
        int i = 0;
        if (i < 3) {
            Channel channel = this.getCachedChannel(future, uri, request.getConnectionPoolPartitioning(), proxyServer, asyncHandler);
            if (Channels.isChannelValid(channel) && newFuture == null) {
                newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, uri, proxyServer, false);
            }
            if (Channels.isChannelValid(channel)) {
                return this.sendRequestWithCachedChannel(request, uri, proxyServer, newFuture, asyncHandler, channel);
            }
        }
        newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, uri, proxyServer, true);
        return this.sendRequestWithNewChannel(request, uri, proxyServer, true, newFuture, asyncHandler, reclaimCache);
    }

    private <T> NettyResponseFuture<T> newNettyRequestAndResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> originalFuture, Uri uri, ProxyServer proxy, boolean forceConnect) throws IOException {
        NettyRequest nettyRequest = this.requestFactory.newNettyRequest(request, uri, forceConnect, proxy);
        if (originalFuture == null) {
            return this.newNettyResponseFuture(uri, request, asyncHandler, nettyRequest, proxy);
        }
        originalFuture.setNettyRequest(nettyRequest);
        originalFuture.setRequest(request);
        return originalFuture;
    }

    private Channel getCachedChannel(NettyResponseFuture<?> future, Uri uri, ConnectionPoolPartitioning poolKeyGen, ProxyServer proxyServer, AsyncHandler<?> asyncHandler) {
        if (future != null && future.reuseChannel() && Channels.isChannelValid(future.channel())) {
            return future.channel();
        }
        return this.pollAndVerifyCachedChannel(uri, proxyServer, poolKeyGen, asyncHandler);
    }

    private <T> ListenableFuture<T> sendRequestWithCachedChannel(Request request, Uri uri, ProxyServer proxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, Channel channel) throws IOException {
        if (asyncHandler instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onConnectionPooled();
        }
        future.setState(NettyResponseFuture.STATE.POOLED);
        future.attachChannel(channel, false);
        LOGGER.debug("Using cached Channel {}\n for request \n{}\n", (Object)channel, (Object)future.getNettyRequest().getHttpRequest());
        Channels.setAttribute(channel, future);
        try {
            this.writeRequest(future, channel);
        }
        catch (Exception ex) {
            LOGGER.debug("writeRequest failure", (Throwable)ex);
            if (ex.getMessage() != null && ex.getMessage().contains("SSLEngine")) {
                LOGGER.debug("SSLEngine failure", (Throwable)ex);
                future = null;
            }
            try {
                asyncHandler.onThrowable(ex);
            }
            catch (Throwable t) {
                LOGGER.warn("doConnect.writeRequest()", t);
            }
            IOException ioe = new IOException(ex.getMessage());
            ioe.initCause(ex);
            throw ioe;
        }
        return future;
    }

    private <T> ListenableFuture<T> sendRequestWithNewChannel(Request request, Uri uri, ProxyServer proxy, boolean useProxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, boolean reclaimCache) throws IOException {
        boolean useSSl = HttpUtils.isSecure(uri) && !useProxy;
        HttpHeaders headers = future.getNettyRequest().getHttpRequest().headers();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        HttpMethod method = future.getNettyRequest().getHttpRequest().getMethod();
        this.requestFactory.addAuthorizationHeader(headers, this.requestFactory.firstRequestOnlyAuthorizationHeader(request, uri, proxy, realm));
        this.requestFactory.setProxyAuthorizationHeader(headers, this.requestFactory.firstRequestOnlyProxyAuthorizationHeader(request, proxy, method));
        ClientBootstrap bootstrap = this.channelManager.getBootstrap(request.getUri().getScheme(), useProxy, useSSl);
        boolean channelPreempted = false;
        String poolKey = null;
        try {
            if (!reclaimCache) {
                if (this.config.getMaxConnectionsPerHost() > 0) {
                    poolKey = this.channelManager.getPartitionId(future);
                }
                if (!this.channelManager.preemptChannel(poolKey)) {
                    throw this.tooManyConnections;
                }
                channelPreempted = true;
            }
            if (asyncHandler instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onOpenConnection();
            }
            ChannelFuture channelFuture = this.connect(request, uri, proxy, useProxy, bootstrap);
            channelFuture.addListener(new NettyConnectListener<T>(this.config, future, this, this.channelManager, channelPreempted, poolKey));
        }
        catch (Throwable t) {
            if (channelPreempted) {
                this.channelManager.abortChannelPreemption(poolKey);
            }
            this.abort(null, future, t.getCause() == null ? t : t.getCause());
        }
        return future;
    }

    private <T> NettyResponseFuture<T> newNettyResponseFuture(Uri uri, Request request, AsyncHandler<T> asyncHandler, NettyRequest nettyRequest, ProxyServer proxyServer) {
        NettyResponseFuture<T> future = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, this.config.getMaxRequestRetry(), request.getConnectionPoolPartitioning(), proxyServer);
        String expectHeader = request.getHeaders().getFirstValue("Expect");
        if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
            future.setDontWriteBodyBecauseExpectContinue(true);
        }
        return future;
    }

    public <T> void writeRequest(NettyResponseFuture<T> future, Channel channel) {
        NettyRequest nettyRequest = future.getNettyRequest();
        HttpRequest httpRequest = nettyRequest.getHttpRequest();
        AsyncHandler<T> handler = future.getAsyncHandler();
        if (!Channels.isChannelValid(channel)) {
            return;
        }
        try {
            if (handler instanceof TransferCompletionHandler) {
                this.configureTransferAdapter(handler, httpRequest);
            }
            if (!future.isHeadersAlreadyWrittenOnContinue()) {
                try {
                    if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                        ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onSendRequest(nettyRequest);
                    }
                    channel.write((Object)httpRequest).addListener((ChannelFutureListener)new ProgressListener(this.config, future.getAsyncHandler(), future, true));
                }
                catch (Throwable cause) {
                    LOGGER.debug(cause.getMessage(), cause);
                    Channels.silentlyCloseChannel(channel);
                    return;
                }
            }
            if (!future.isDontWriteBodyBecauseExpectContinue() && !httpRequest.getMethod().equals((Object)HttpMethod.CONNECT) && nettyRequest.getBody() != null) {
                nettyRequest.getBody().write(channel, future, this.config);
            }
            if (Channels.isChannelValid(channel)) {
                this.scheduleTimeouts(future);
            }
        }
        catch (Throwable ioe) {
            Channels.silentlyCloseChannel(channel);
        }
    }

    private InetSocketAddress remoteAddress(Request request, Uri uri, ProxyServer proxy, boolean useProxy) {
        if (request.getInetAddress() != null) {
            return new InetSocketAddress(request.getInetAddress(), AsyncHttpProviderUtils.getDefaultPort(uri));
        }
        if (!useProxy || ProxyUtils.avoidProxy(proxy, uri.getHost())) {
            return new InetSocketAddress(uri.getHost(), AsyncHttpProviderUtils.getDefaultPort(uri));
        }
        return new InetSocketAddress(proxy.getHost(), proxy.getPort());
    }

    private ChannelFuture connect(Request request, Uri uri, ProxyServer proxy, boolean useProxy, ClientBootstrap bootstrap) {
        InetSocketAddress remoteAddress = this.remoteAddress(request, uri, proxy, useProxy);
        if (request.getLocalAddress() != null) {
            return bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)new InetSocketAddress(request.getLocalAddress(), 0));
        }
        return bootstrap.connect((SocketAddress)remoteAddress);
    }

    private void configureTransferAdapter(AsyncHandler<?> handler, HttpRequest httpRequest) {
        FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
        for (Map.Entry entries : httpRequest.headers()) {
            h.add((String)entries.getKey(), (String)entries.getValue());
        }
        ((TransferCompletionHandler)TransferCompletionHandler.class.cast(handler)).headers(h);
    }

    private void scheduleTimeouts(NettyResponseFuture<?> nettyResponseFuture) {
        int readTimeoutValue;
        nettyResponseFuture.touch();
        int requestTimeoutInMs = AsyncHttpProviderUtils.requestTimeout(this.config, nettyResponseFuture.getRequest());
        TimeoutsHolder timeoutsHolder = new TimeoutsHolder();
        if (requestTimeoutInMs != -1) {
            Timeout requestTimeout;
            timeoutsHolder.requestTimeout = requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(nettyResponseFuture, this, timeoutsHolder, requestTimeoutInMs), requestTimeoutInMs);
        }
        if ((readTimeoutValue = this.config.getReadTimeout()) != -1 && readTimeoutValue < requestTimeoutInMs) {
            Timeout readTimeout;
            timeoutsHolder.readTimeout = readTimeout = this.newTimeout(new ReadTimeoutTimerTask(nettyResponseFuture, this, timeoutsHolder, requestTimeoutInMs, readTimeoutValue), readTimeoutValue);
        }
        nettyResponseFuture.setTimeoutsHolder(timeoutsHolder);
    }

    public Timeout newTimeout(TimerTask task, long delay) {
        return this.nettyTimer.newTimeout(task, delay, TimeUnit.MILLISECONDS);
    }

    public void abort(Channel channel, NettyResponseFuture<?> future, Throwable t) {
        if (channel != null) {
            this.channelManager.closeChannel(channel);
        }
        if (!future.isDone()) {
            LOGGER.debug("Aborting Future {}\n", future);
            LOGGER.debug(t.getMessage(), t);
            future.abort(t);
        }
    }

    public boolean retry(NettyResponseFuture<?> future) {
        if (this.isClosed()) {
            return false;
        }
        if (future.canBeReplayed()) {
            future.setState(NettyResponseFuture.STATE.RECONNECTED);
            LOGGER.debug("Trying to recover request {}\n", (Object)future.getNettyRequest().getHttpRequest());
            if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
            }
            try {
                this.sendNextRequest(future.getRequest(), future);
                return true;
            }
            catch (IOException iox) {
                future.setState(NettyResponseFuture.STATE.CLOSED);
                future.abort(iox);
                LOGGER.error("Remotely closed, unable to recover", (Throwable)iox);
                return false;
            }
        }
        LOGGER.debug("Unable to recover future {}\n", future);
        return false;
    }

    public boolean applyIoExceptionFiltersAndReplayRequest(NettyResponseFuture<?> future, IOException e, Channel channel) throws IOException {
        boolean replayed = false;
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(e).build();
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(channel, future, efe);
            }
        }
        if (fc.replayRequest() && future.canBeReplayed()) {
            this.replayRequest(future, fc, channel);
            replayed = true;
        }
        return replayed;
    }

    public <T> void sendNextRequest(Request request, NettyResponseFuture<T> future) throws IOException {
        this.sendRequest(request, future.getAsyncHandler(), future, true);
    }

    private boolean validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        return request.getMethod().equals(HttpMethod.GET.getName()) && asyncHandler instanceof WebSocketUpgradeHandler;
    }

    public Channel pollAndVerifyCachedChannel(Uri uri, ProxyServer proxy, ConnectionPoolPartitioning connectionPoolPartitioning, AsyncHandler<?> asyncHandler) {
        Channel channel;
        if (asyncHandler instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onPoolConnection();
        }
        if ((channel = this.channelManager.poll(uri, proxy, connectionPoolPartitioning)) != null) {
            LOGGER.debug("Using cached Channel {}\n for uri {}\n", (Object)channel, (Object)uri);
            try {
                this.channelManager.verifyChannelPipeline(channel.getPipeline(), uri.getScheme());
            }
            catch (Exception ex) {
                LOGGER.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return channel;
    }

    public void replayRequest(NettyResponseFuture<?> future, FilterContext fc, Channel channel) throws IOException {
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setState(NettyResponseFuture.STATE.NEW);
        future.touch();
        LOGGER.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, future);
        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
        }
        this.channelManager.drainChannel(channel, future);
        this.sendNextRequest(newRequest, future);
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

