/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.Base64;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.StandardCharsets;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public final class AuthenticatorUtils {
    public static String computeBasicAuthentication(Realm realm) throws UnsupportedEncodingException {
        String s = realm.getPrincipal() + ":" + realm.getPassword();
        return "Basic " + Base64.encode(s.getBytes(realm.getEncoding()));
    }

    public static String computeBasicAuthentication(ProxyServer proxyServer) throws UnsupportedEncodingException {
        String s = proxyServer.getPrincipal() + ":" + proxyServer.getPassword();
        return "Basic " + Base64.encode(s.getBytes(proxyServer.getEncoding()));
    }

    private static String computeRealmURI(Realm realm) {
        Uri uri = realm.getUri();
        if (realm.isTargetProxy()) {
            return "/";
        }
        if (realm.isUseAbsoluteURI()) {
            return realm.isOmitQuery() && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath(uri);
        return realm.isOmitQuery() || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    public static String computeDigestAuthentication(Realm realm) throws NoSuchAlgorithmException {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", AuthenticatorUtils.computeRealmURI(realm), true);
        AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (MiscUtils.isNonEmpty(realm.getOpaque())) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
        AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
        AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        builder.setLength(builder.length() - 2);
        return new String(builder.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    private static StringBuilder append(StringBuilder builder, String name, String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        return builder.append(", ");
    }
}

