/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request.body;

import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.util.StandardCharsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class FeedableBodyGenerator
implements BodyGenerator {
    private static final byte[] END_PADDING = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ZERO = "0".getBytes(StandardCharsets.US_ASCII);
    private final Queue<BodyPart> queue = new ConcurrentLinkedQueue<BodyPart>();
    private final AtomicInteger queueSize = new AtomicInteger();
    private FeedListener listener;

    @Override
    public Body createBody() throws IOException {
        return new PushBody();
    }

    public void feed(ByteBuffer buffer, boolean isLast) throws IOException {
        this.queue.offer(new BodyPart(buffer, isLast));
        this.queueSize.incrementAndGet();
        if (this.listener != null) {
            this.listener.onContentAdded();
        }
    }

    public void setListener(FeedListener listener) {
        this.listener = listener;
    }

    private static final class BodyPart {
        private final boolean isLast;
        private final ByteBuffer buffer;

        public BodyPart(ByteBuffer buffer, boolean isLast) {
            this.buffer = buffer;
            this.isLast = isLast;
        }
    }

    private final class PushBody
    implements Body {
        private final int ONGOING = 0;
        private final int CLOSING = 1;
        private final int FINISHED = 2;
        private int finishState = 0;

        private PushBody() {
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public long read(ByteBuffer buffer) throws IOException {
            BodyPart nextPart = (BodyPart)FeedableBodyGenerator.this.queue.peek();
            if (nextPart == null) {
                switch (this.finishState) {
                    case 0: {
                        return 0L;
                    }
                    case 1: {
                        buffer.put(ZERO);
                        buffer.put(END_PADDING);
                        this.finishState = 2;
                        return buffer.position();
                    }
                    case 2: {
                        buffer.put(END_PADDING);
                        return -1L;
                    }
                }
            }
            int capacity = buffer.remaining() - 10;
            int size = Math.min(nextPart.buffer.remaining(), capacity);
            buffer.put(Integer.toHexString(size).getBytes(StandardCharsets.US_ASCII));
            buffer.put(END_PADDING);
            for (int i = 0; i < size; ++i) {
                buffer.put(nextPart.buffer.get());
            }
            buffer.put(END_PADDING);
            if (!nextPart.buffer.hasRemaining()) {
                if (nextPart.isLast) {
                    this.finishState = 1;
                }
                FeedableBodyGenerator.this.queue.remove();
            }
            return size;
        }

        @Override
        public void close() {
        }
    }

    public static interface FeedListener {
        public void onContentAdded();
    }
}

