/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.channel.pool.ChannelPoolPartitionSelector;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider {
    static final Logger LOGGER = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ChannelManager channelManager;
    private final NettyAsyncHttpProviderConfig nettyConfig;
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    private final NettyRequestSender requestSender;

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.config = config;
        this.nettyConfig = config.getAsyncHttpProviderConfig() instanceof NettyAsyncHttpProviderConfig ? (NettyAsyncHttpProviderConfig)config.getAsyncHttpProviderConfig() : new NettyAsyncHttpProviderConfig();
        this.allowStopNettyTimer = this.nettyConfig.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer() : this.nettyConfig.getNettyTimer();
        this.channelManager = new ChannelManager(config, this.nettyConfig, this.nettyTimer);
        this.requestSender = new NettyRequestSender(config, this.nettyConfig, this.channelManager, this.nettyTimer, this.closed);
        this.channelManager.configureBootstraps(this.requestSender, this.closed);
    }

    private Timer newNettyTimer() {
        HashedWheelTimer timer = new HashedWheelTimer();
        timer.start();
        return timer;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channelManager.close();
                this.config.executorService().shutdown();
                if (this.allowStopNettyTimer) {
                    this.nettyTimer.stop();
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on close", t);
            }
        }
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.requestSender.sendRequest(request, asyncHandler, null, false);
    }

    public void flushChannelPoolPartition(String partitionId) {
        this.channelManager.flushPartition(partitionId);
    }

    public void flushChannelPoolPartitions(ChannelPoolPartitionSelector selector) {
        this.channelManager.flushPartitions(selector);
    }
}

