/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslUtils {
    private SSLContext looseTrustManagerSSLContext = this.looseTrustManagerSSLContext();

    public static SslUtils getInstance() {
        return SingletonHolder.instance;
    }

    public SSLEngine createClientSSLEngine(AsyncHttpClientConfig config, String peerHost, int peerPort) throws GeneralSecurityException, IOException {
        SSLContext sslContext = config.getSSLContext();
        if (sslContext == null) {
            sslContext = SslUtils.getInstance().getSSLContext(config.isAcceptAnyCertificate());
        }
        SSLEngine sslEngine = sslContext.createSSLEngine(peerHost, peerPort);
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }

    public SSLContext getSSLContext(boolean acceptAnyCertificate) throws GeneralSecurityException, IOException {
        return acceptAnyCertificate ? this.looseTrustManagerSSLContext : SSLContext.getInstance("Default");
    }

    private SSLContext looseTrustManagerSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new LooseTrustManager()}, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static class LooseTrustManager
    implements X509TrustManager {
        LooseTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    private static class SingletonHolder {
        public static final SslUtils instance = new SslUtils();

        private SingletonHolder() {
        }
    }
}

