/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ProxyServerSelector;
import com.ning.http.client.Request;
import com.ning.http.client.uri.UriComponents;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyUtils {
    private static final Logger log = LoggerFactory.getLogger(ProxyUtils.class);
    private static final String PROPERTY_PREFIX = "com.ning.http.client.AsyncHttpClientConfig.proxy.";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String PROXY_PROTOCOL = "com.ning.http.client.AsyncHttpClientConfig.proxy.protocol";
    public static final String PROXY_NONPROXYHOSTS = "http.nonProxyHosts";
    public static final String PROXY_USER = "com.ning.http.client.AsyncHttpClientConfig.proxy.user";
    public static final String PROXY_PASSWORD = "com.ning.http.client.AsyncHttpClientConfig.proxy.password";

    private ProxyUtils() {
    }

    public static ProxyServer getProxyServer(AsyncHttpClientConfig config, Request request) {
        ProxyServerSelector selector;
        ProxyServer proxyServer = request.getProxyServer();
        if (proxyServer == null && (selector = config.getProxyServerSelector()) != null) {
            proxyServer = selector.select(request.getURI());
        }
        return ProxyUtils.avoidProxy(proxyServer, request) ? null : proxyServer;
    }

    public static boolean avoidProxy(ProxyServer proxyServer, Request request) {
        return ProxyUtils.avoidProxy(proxyServer, request.getURI().getHost());
    }

    private static boolean matchNonProxyHost(String targetHost, String nonProxyHost) {
        if (nonProxyHost.length() > 1) {
            if (nonProxyHost.charAt(0) == '*') {
                return targetHost.regionMatches(true, targetHost.length() - nonProxyHost.length() + 1, nonProxyHost, 1, nonProxyHost.length() - 1);
            }
            if (nonProxyHost.charAt(nonProxyHost.length() - 1) == '*') {
                return targetHost.regionMatches(true, 0, nonProxyHost, 0, nonProxyHost.length() - 1);
            }
        }
        return nonProxyHost.equalsIgnoreCase(targetHost);
    }

    public static boolean avoidProxy(ProxyServer proxyServer, String hostname) {
        if (proxyServer != null) {
            if (hostname == null) {
                throw new NullPointerException("hostname");
            }
            List<String> nonProxyHosts = proxyServer.getNonProxyHosts();
            if (nonProxyHosts != null) {
                for (String nonProxyHost : nonProxyHosts) {
                    if (!ProxyUtils.matchNonProxyHost(hostname, nonProxyHost)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static ProxyServerSelector createProxyServerSelector(Properties properties) {
        String host = properties.getProperty(PROXY_HOST);
        if (host != null) {
            ProxyServer.Protocol protocol;
            int port = Integer.valueOf(properties.getProperty(PROXY_PORT, "80"));
            try {
                protocol = ProxyServer.Protocol.valueOf(properties.getProperty(PROXY_PROTOCOL, "HTTP"));
            }
            catch (IllegalArgumentException e) {
                protocol = ProxyServer.Protocol.HTTP;
            }
            ProxyServer proxyServer = new ProxyServer(protocol, host, port, properties.getProperty(PROXY_USER), properties.getProperty(PROXY_PASSWORD));
            String nonProxyHosts = properties.getProperty(PROXY_NONPROXYHOSTS);
            if (nonProxyHosts != null) {
                for (String spec : nonProxyHosts.split("\\|")) {
                    proxyServer.addNonProxyHost(spec);
                }
            }
            return ProxyUtils.createProxyServerSelector(proxyServer);
        }
        return ProxyServerSelector.NO_PROXY_SELECTOR;
    }

    public static ProxyServerSelector getJdkDefaultProxyServerSelector() {
        return ProxyUtils.createProxyServerSelector(ProxySelector.getDefault());
    }

    public static ProxyServerSelector createProxyServerSelector(final ProxySelector proxySelector) {
        return new ProxyServerSelector(){

            public ProxyServer select(UriComponents uri) {
                try {
                    URI javaUri = uri.toURI();
                    List<Proxy> proxies = proxySelector.select(javaUri);
                    if (proxies != null) {
                        for (Proxy proxy : proxies) {
                            switch (proxy.type()) {
                                case HTTP: {
                                    if (!(proxy.address() instanceof InetSocketAddress)) {
                                        log.warn("Don't know how to connect to address " + proxy.address());
                                        return null;
                                    }
                                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                                    return new ProxyServer(ProxyServer.Protocol.HTTP, address.getHostName(), address.getPort());
                                }
                                case DIRECT: {
                                    return null;
                                }
                            }
                            log.warn("ProxySelector returned proxy type that we don't know how to use: " + (Object)((Object)proxy.type()));
                        }
                    }
                    return null;
                }
                catch (URISyntaxException e) {
                    log.warn(uri + " couldn't be turned into a java.net.URI", (Throwable)e);
                    return null;
                }
            }
        };
    }

    public static ProxyServerSelector createProxyServerSelector(final ProxyServer proxyServer) {
        return new ProxyServerSelector(){

            public ProxyServer select(UriComponents uri) {
                return proxyServer;
            }
        };
    }
}

