/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpClientConfigDefaults;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ProxyServerSelector;
import com.ning.http.client.Realm;
import com.ning.http.client.date.TimeConverter;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.util.ProxyUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpClientConfig {
    protected int maxTotalConnections;
    protected int maxConnectionPerHost;
    protected int connectionTimeOutInMs;
    protected int webSocketIdleTimeoutInMs;
    protected int idleConnectionInPoolTimeoutInMs;
    protected int idleConnectionTimeoutInMs;
    protected int requestTimeoutInMs;
    protected boolean followRedirect;
    protected int maxRedirects;
    protected boolean compressionEnabled;
    protected String userAgent;
    protected boolean allowPoolingConnection;
    protected ExecutorService applicationThreadPool;
    protected ProxyServerSelector proxyServerSelector;
    protected SSLContext sslContext;
    protected AsyncHttpProviderConfig<?, ?> providerConfig;
    protected ConnectionsPool<?, ?> connectionsPool;
    protected Realm realm;
    protected List<RequestFilter> requestFilters;
    protected List<ResponseFilter> responseFilters;
    protected List<IOExceptionFilter> ioExceptionFilters;
    protected int requestCompressionLevel;
    protected int maxRequestRetry;
    protected boolean allowSslConnectionPool;
    protected boolean disableUrlEncodingForBoundedRequests;
    protected boolean removeQueryParamOnRedirect;
    protected HostnameVerifier hostnameVerifier;
    protected int ioThreadMultiplier;
    protected boolean strict302Handling;
    protected boolean useRelativeURIsWithSSLProxies;
    protected int maxConnectionLifeTimeInMs;
    protected TimeConverter timeConverter;
    protected boolean acceptAnyCertificate;

    protected AsyncHttpClientConfig() {
    }

    private AsyncHttpClientConfig(int maxTotalConnections, int maxConnectionPerHost, int connectionTimeOutInMs, int webSocketTimeoutInMs, int idleConnectionInPoolTimeoutInMs, int idleConnectionTimeoutInMs, int requestTimeoutInMs, int connectionMaxLifeTimeInMs, boolean followRedirect, int maxRedirects, boolean compressionEnabled, String userAgent, boolean keepAlive, ExecutorService applicationThreadPool, ProxyServerSelector proxyServerSelector, SSLContext sslContext, AsyncHttpProviderConfig<?, ?> providerConfig, ConnectionsPool<?, ?> connectionsPool, Realm realm, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, List<IOExceptionFilter> ioExceptionFilters, int requestCompressionLevel, int maxRequestRetry, boolean allowSslConnectionCaching, boolean disableUrlEncodingForBoundedRequests, boolean removeQueryParamOnRedirect, HostnameVerifier hostnameVerifier, int ioThreadMultiplier, boolean strict302Handling, boolean useRelativeURIsWithSSLProxies, TimeConverter timeConverter, boolean acceptAnyCertificate) {
        this.maxTotalConnections = maxTotalConnections;
        this.maxConnectionPerHost = maxConnectionPerHost;
        this.connectionTimeOutInMs = connectionTimeOutInMs;
        this.webSocketIdleTimeoutInMs = webSocketTimeoutInMs;
        this.idleConnectionInPoolTimeoutInMs = idleConnectionInPoolTimeoutInMs;
        this.idleConnectionTimeoutInMs = idleConnectionTimeoutInMs;
        this.requestTimeoutInMs = requestTimeoutInMs;
        this.maxConnectionLifeTimeInMs = connectionMaxLifeTimeInMs;
        this.followRedirect = followRedirect;
        this.maxRedirects = maxRedirects;
        this.compressionEnabled = compressionEnabled;
        this.userAgent = userAgent;
        this.allowPoolingConnection = keepAlive;
        this.sslContext = sslContext;
        this.providerConfig = providerConfig;
        this.connectionsPool = connectionsPool;
        this.realm = realm;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.ioExceptionFilters = ioExceptionFilters;
        this.requestCompressionLevel = requestCompressionLevel;
        this.maxRequestRetry = maxRequestRetry;
        this.allowSslConnectionPool = allowSslConnectionCaching;
        this.removeQueryParamOnRedirect = removeQueryParamOnRedirect;
        this.hostnameVerifier = hostnameVerifier;
        this.ioThreadMultiplier = ioThreadMultiplier;
        this.strict302Handling = strict302Handling;
        this.useRelativeURIsWithSSLProxies = useRelativeURIsWithSSLProxies;
        this.applicationThreadPool = applicationThreadPool == null ? Executors.newCachedThreadPool() : applicationThreadPool;
        this.proxyServerSelector = proxyServerSelector;
        this.disableUrlEncodingForBoundedRequests = disableUrlEncodingForBoundedRequests;
        this.timeConverter = timeConverter;
        this.acceptAnyCertificate = acceptAnyCertificate;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMaxConnectionPerHost() {
        return this.maxConnectionPerHost;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeOutInMs;
    }

    public int getWebSocketIdleTimeoutInMs() {
        return this.webSocketIdleTimeoutInMs;
    }

    public int getIdleConnectionTimeoutInMs() {
        return this.idleConnectionTimeoutInMs;
    }

    public int getIdleConnectionInPoolTimeoutInMs() {
        return this.idleConnectionInPoolTimeoutInMs;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isAllowPoolingConnection() {
        return this.allowPoolingConnection;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public ExecutorService executorService() {
        return this.applicationThreadPool;
    }

    public ProxyServerSelector getProxyServerSelector() {
        return this.proxyServerSelector;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public ConnectionsPool<?, ?> getConnectionsPool() {
        return this.connectionsPool;
    }

    public AsyncHttpProviderConfig<?, ?> getAsyncHttpProviderConfig() {
        return this.providerConfig;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public List<RequestFilter> getRequestFilters() {
        return Collections.unmodifiableList(this.requestFilters);
    }

    public List<ResponseFilter> getResponseFilters() {
        return Collections.unmodifiableList(this.responseFilters);
    }

    public List<IOExceptionFilter> getIOExceptionFilters() {
        return Collections.unmodifiableList(this.ioExceptionFilters);
    }

    public int getRequestCompressionLevel() {
        return this.requestCompressionLevel;
    }

    public int getMaxRequestRetry() {
        return this.maxRequestRetry;
    }

    public boolean isSslConnectionPoolEnabled() {
        return this.allowSslConnectionPool;
    }

    public boolean isDisableUrlEncodingForBoundedRequests() {
        return this.disableUrlEncodingForBoundedRequests;
    }

    public boolean isRemoveQueryParamOnRedirect() {
        return this.removeQueryParamOnRedirect;
    }

    public boolean isValid() {
        try {
            return this.applicationThreadPool.isShutdown();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public int getIoThreadMultiplier() {
        return this.ioThreadMultiplier;
    }

    public boolean isStrict302Handling() {
        return this.strict302Handling;
    }

    public boolean isUseRelativeURIsWithSSLProxies() {
        return this.useRelativeURIsWithSSLProxies;
    }

    public int getMaxConnectionLifeTimeInMs() {
        return this.maxConnectionLifeTimeInMs;
    }

    public TimeConverter getTimeConverter() {
        return this.timeConverter;
    }

    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private int maxTotalConnections = AsyncHttpClientConfigDefaults.defaultMaxTotalConnections();
        private int maxConnectionPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionPerHost();
        private int connectionTimeOutInMs = AsyncHttpClientConfigDefaults.defaultConnectionTimeOutInMs();
        private int webSocketIdleTimeoutInMs = AsyncHttpClientConfigDefaults.defaultWebSocketIdleTimeoutInMs();
        private int idleConnectionInPoolTimeoutInMs = AsyncHttpClientConfigDefaults.defaultIdleConnectionInPoolTimeoutInMs();
        private int idleConnectionTimeoutInMs = AsyncHttpClientConfigDefaults.defaultIdleConnectionTimeoutInMs();
        private int requestTimeoutInMs = AsyncHttpClientConfigDefaults.defaultRequestTimeoutInMs();
        private int maxConnectionLifeTimeInMs = AsyncHttpClientConfigDefaults.defaultMaxConnectionLifeTimeInMs();
        private boolean followRedirect = AsyncHttpClientConfigDefaults.defaultFollowRedirect();
        private int maxDefaultRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        private boolean compressionEnabled = AsyncHttpClientConfigDefaults.defaultCompressionEnabled();
        private String userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        private boolean useProxyProperties = AsyncHttpClientConfigDefaults.defaultUseProxyProperties();
        private boolean useProxySelector = AsyncHttpClientConfigDefaults.defaultUseProxySelector();
        private boolean allowPoolingConnection = AsyncHttpClientConfigDefaults.defaultAllowPoolingConnection();
        private boolean useRelativeURIsWithSSLProxies = AsyncHttpClientConfigDefaults.defaultUseRelativeURIsWithSSLProxies();
        private int requestCompressionLevel = AsyncHttpClientConfigDefaults.defaultRequestCompressionLevel();
        private int maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        private int ioThreadMultiplier = AsyncHttpClientConfigDefaults.defaultIoThreadMultiplier();
        private boolean allowSslConnectionPool = AsyncHttpClientConfigDefaults.defaultAllowSslConnectionPool();
        private boolean disableUrlEncodingForBoundedRequests = AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundedRequests();
        private boolean removeQueryParamOnRedirect = AsyncHttpClientConfigDefaults.defaultRemoveQueryParamOnRedirect();
        private boolean strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        private HostnameVerifier hostnameVerifier = AsyncHttpClientConfigDefaults.defaultHostnameVerifier();
        private boolean acceptAnyCertificate = AsyncHttpClientConfigDefaults.defaultAcceptAnyCertificate();
        private ExecutorService applicationThreadPool;
        private ProxyServerSelector proxyServerSelector = null;
        private SSLContext sslContext;
        private AsyncHttpProviderConfig<?, ?> providerConfig;
        private ConnectionsPool<?, ?> connectionsPool;
        private Realm realm;
        private final List<RequestFilter> requestFilters = new LinkedList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new LinkedList<ResponseFilter>();
        private final List<IOExceptionFilter> ioExceptionFilters = new LinkedList<IOExceptionFilter>();
        private TimeConverter timeConverter;

        public Builder() {
        }

        public Builder setMaximumConnectionsTotal(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder setMaximumConnectionsPerHost(int maxConnectionPerHost) {
            this.maxConnectionPerHost = maxConnectionPerHost;
            return this;
        }

        public Builder setConnectionTimeoutInMs(int connectionTimeOutInMs) {
            this.connectionTimeOutInMs = connectionTimeOutInMs;
            return this;
        }

        public Builder setWebSocketIdleTimeoutInMs(int webSocketIdleTimeoutInMs) {
            this.webSocketIdleTimeoutInMs = webSocketIdleTimeoutInMs;
            return this;
        }

        public Builder setIdleConnectionTimeoutInMs(int idleConnectionTimeoutInMs) {
            this.idleConnectionTimeoutInMs = idleConnectionTimeoutInMs;
            return this;
        }

        public Builder setIdleConnectionInPoolTimeoutInMs(int idleConnectionInPoolTimeoutInMs) {
            this.idleConnectionInPoolTimeoutInMs = idleConnectionInPoolTimeoutInMs;
            return this;
        }

        public Builder setRequestTimeoutInMs(int requestTimeoutInMs) {
            this.requestTimeoutInMs = requestTimeoutInMs;
            return this;
        }

        public Builder setFollowRedirect(boolean followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public Builder setMaximumNumberOfRedirects(int maxDefaultRedirects) {
            this.maxDefaultRedirects = maxDefaultRedirects;
            return this;
        }

        public Builder setCompressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setAllowPoolingConnection(boolean allowPoolingConnection) {
            this.allowPoolingConnection = allowPoolingConnection;
            return this;
        }

        public Builder setExecutorService(ExecutorService applicationThreadPool) {
            this.applicationThreadPool = applicationThreadPool;
            return this;
        }

        public Builder setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
            this.proxyServerSelector = proxyServerSelector;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
            return this;
        }

        public Builder setSSLContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setAsyncHttpClientProviderConfig(AsyncHttpProviderConfig<?, ?> providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        public Builder setConnectionsPool(ConnectionsPool<?, ?> connectionsPool) {
            this.connectionsPool = connectionsPool;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder addRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.add(requestFilter);
            return this;
        }

        public Builder removeRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.remove(requestFilter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.add(responseFilter);
            return this;
        }

        public Builder removeResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.remove(responseFilter);
            return this;
        }

        public Builder addIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.add(ioExceptionFilter);
            return this;
        }

        public Builder removeIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.remove(ioExceptionFilter);
            return this;
        }

        public int getRequestCompressionLevel() {
            return this.requestCompressionLevel;
        }

        public Builder setRequestCompressionLevel(int requestCompressionLevel) {
            this.requestCompressionLevel = requestCompressionLevel;
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.maxRequestRetry = maxRequestRetry;
            return this;
        }

        public Builder setAllowSslConnectionPool(boolean allowSslConnectionPool) {
            this.allowSslConnectionPool = allowSslConnectionPool;
            return this;
        }

        public Builder setDisableUrlEncodingForBoundedRequests(boolean disableUrlEncodingForBoundedRequests) {
            this.disableUrlEncodingForBoundedRequests = disableUrlEncodingForBoundedRequests;
            return this;
        }

        public Builder setRemoveQueryParamsOnRedirect(boolean removeQueryParamOnRedirect) {
            this.removeQueryParamOnRedirect = removeQueryParamOnRedirect;
            return this;
        }

        public Builder setUseProxySelector(boolean useProxySelector) {
            this.useProxySelector = useProxySelector;
            return this;
        }

        public Builder setUseProxyProperties(boolean useProxyProperties) {
            this.useProxyProperties = useProxyProperties;
            return this;
        }

        public Builder setIOThreadMultiplier(int multiplier) {
            this.ioThreadMultiplier = multiplier;
            return this;
        }

        public Builder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder setStrict302Handling(boolean strict302Handling) {
            this.strict302Handling = strict302Handling;
            return this;
        }

        public Builder setUseRelativeURIsWithSSLProxies(boolean useRelativeURIsWithSSLProxies) {
            this.useRelativeURIsWithSSLProxies = useRelativeURIsWithSSLProxies;
            return this;
        }

        public Builder setMaxConnectionLifeTimeInMs(int maxConnectionLifeTimeInMs) {
            this.maxConnectionLifeTimeInMs = maxConnectionLifeTimeInMs;
            return this;
        }

        public Builder setTimeConverter(TimeConverter timeConverter) {
            this.timeConverter = timeConverter;
            return this;
        }

        public Builder setAcceptAnyCertificate(boolean acceptAnyCertificate) {
            this.acceptAnyCertificate = acceptAnyCertificate;
            return this;
        }

        public Builder(AsyncHttpClientConfig prototype) {
            this.allowPoolingConnection = prototype.isAllowPoolingConnection();
            this.providerConfig = prototype.getAsyncHttpProviderConfig();
            this.connectionsPool = prototype.getConnectionsPool();
            this.connectionTimeOutInMs = prototype.getConnectionTimeoutInMs();
            this.idleConnectionInPoolTimeoutInMs = prototype.getIdleConnectionInPoolTimeoutInMs();
            this.idleConnectionTimeoutInMs = prototype.getIdleConnectionTimeoutInMs();
            this.maxConnectionPerHost = prototype.getMaxConnectionPerHost();
            this.maxConnectionLifeTimeInMs = prototype.getMaxConnectionLifeTimeInMs();
            this.maxDefaultRedirects = prototype.getMaxRedirects();
            this.maxTotalConnections = prototype.getMaxTotalConnections();
            this.proxyServerSelector = prototype.getProxyServerSelector();
            this.realm = prototype.getRealm();
            this.requestTimeoutInMs = prototype.getRequestTimeoutInMs();
            this.sslContext = prototype.getSSLContext();
            this.userAgent = prototype.getUserAgent();
            this.followRedirect = prototype.isFollowRedirect();
            this.compressionEnabled = prototype.isCompressionEnabled();
            this.applicationThreadPool = prototype.executorService();
            this.requestFilters.clear();
            this.responseFilters.clear();
            this.ioExceptionFilters.clear();
            this.requestFilters.addAll(prototype.getRequestFilters());
            this.responseFilters.addAll(prototype.getResponseFilters());
            this.ioExceptionFilters.addAll(prototype.getIOExceptionFilters());
            this.requestCompressionLevel = prototype.getRequestCompressionLevel();
            this.disableUrlEncodingForBoundedRequests = prototype.isDisableUrlEncodingForBoundedRequests();
            this.ioThreadMultiplier = prototype.getIoThreadMultiplier();
            this.maxRequestRetry = prototype.getMaxRequestRetry();
            this.allowSslConnectionPool = prototype.isAllowPoolingConnection();
            this.removeQueryParamOnRedirect = prototype.isRemoveQueryParamOnRedirect();
            this.hostnameVerifier = prototype.getHostnameVerifier();
            this.strict302Handling = prototype.isStrict302Handling();
            this.timeConverter = prototype.timeConverter;
            this.acceptAnyCertificate = prototype.acceptAnyCertificate;
        }

        public AsyncHttpClientConfig build() {
            if (this.applicationThreadPool == null) {
                this.applicationThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(r, "AsyncHttpClient-Callback");
                        t.setDaemon(true);
                        return t;
                    }
                });
            }
            if (this.proxyServerSelector == null && this.useProxySelector) {
                this.proxyServerSelector = ProxyUtils.getJdkDefaultProxyServerSelector();
            }
            if (this.proxyServerSelector == null && this.useProxyProperties) {
                this.proxyServerSelector = ProxyUtils.createProxyServerSelector(System.getProperties());
            }
            if (this.proxyServerSelector == null) {
                this.proxyServerSelector = ProxyServerSelector.NO_PROXY_SELECTOR;
            }
            return new AsyncHttpClientConfig(this.maxTotalConnections, this.maxConnectionPerHost, this.connectionTimeOutInMs, this.webSocketIdleTimeoutInMs, this.idleConnectionInPoolTimeoutInMs, this.idleConnectionTimeoutInMs, this.requestTimeoutInMs, this.maxConnectionLifeTimeInMs, this.followRedirect, this.maxDefaultRedirects, this.compressionEnabled, this.userAgent, this.allowPoolingConnection, this.applicationThreadPool, this.proxyServerSelector, this.sslContext, this.providerConfig, this.connectionsPool, this.realm, this.requestFilters, this.responseFilters, this.ioExceptionFilters, this.requestCompressionLevel, this.maxRequestRetry, this.allowSslConnectionPool, this.disableUrlEncodingForBoundedRequests, this.removeQueryParamOnRedirect, this.hostnameVerifier, this.ioThreadMultiplier, this.strict302Handling, this.useRelativeURIsWithSSLProxies, this.timeConverter, this.acceptAnyCertificate);
        }
    }
}

