/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Part;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.Response;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProvider;
import com.ning.http.client.resumable.ResumableAsyncHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpClient
implements Closeable {
    private static final String DEFAULT_PROVIDER = "com.ning.http.client.providers.netty.NettyAsyncHttpProvider";
    private final AsyncHttpProvider httpProvider;
    private final AsyncHttpClientConfig config;
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClient.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected SignatureCalculator signatureCalculator;

    public AsyncHttpClient() {
        this(new AsyncHttpClientConfig.Builder().build());
    }

    public AsyncHttpClient(AsyncHttpProvider provider) {
        this(provider, new AsyncHttpClientConfig.Builder().build());
    }

    public AsyncHttpClient(AsyncHttpClientConfig config) {
        this(AsyncHttpClient.loadDefaultProvider(DEFAULT_PROVIDER, config), config);
    }

    public AsyncHttpClient(AsyncHttpProvider httpProvider, AsyncHttpClientConfig config) {
        this.config = config;
        this.httpProvider = httpProvider;
    }

    public AsyncHttpClient(String providerClass, AsyncHttpClientConfig config) {
        this.config = new AsyncHttpClientConfig.Builder().build();
        this.httpProvider = AsyncHttpClient.loadDefaultProvider(providerClass, config);
    }

    public AsyncHttpProvider getProvider() {
        return this.httpProvider;
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.httpProvider.close();
        }
    }

    public void closeAsynchronously() {
        final ExecutorService e = Executors.newSingleThreadExecutor();
        e.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AsyncHttpClient.this.close();
                }
                catch (Throwable t) {
                    logger.warn("", t);
                }
                finally {
                    e.shutdown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed.get()) {
                logger.debug("AsyncHttpClient.close() hasn't been invoked, which may produce file descriptor leaks");
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    public AsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    public BoundRequestBuilder prepareGet(String url) {
        return this.requestBuilder("GET", url);
    }

    public BoundRequestBuilder prepareConnect(String url) {
        return this.requestBuilder("CONNECT", url);
    }

    public BoundRequestBuilder prepareOptions(String url) {
        return this.requestBuilder("OPTIONS", url);
    }

    public BoundRequestBuilder prepareHead(String url) {
        return this.requestBuilder("HEAD", url);
    }

    public BoundRequestBuilder preparePost(String url) {
        return this.requestBuilder("POST", url);
    }

    public BoundRequestBuilder preparePut(String url) {
        return this.requestBuilder("PUT", url);
    }

    public BoundRequestBuilder prepareDelete(String url) {
        return this.requestBuilder("DELETE", url);
    }

    public BoundRequestBuilder prepareRequest(Request request) {
        return this.requestBuilder(request);
    }

    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) throws IOException {
        FilterContext fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(handler).request(request).build();
        fc = this.preProcessRequest(fc);
        return this.httpProvider.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    public ListenableFuture<Response> executeRequest(Request request) throws IOException {
        FilterContext fc = new FilterContext.FilterContextBuilder<Response>().asyncHandler(new AsyncCompletionHandlerBase()).request(request).build();
        fc = this.preProcessRequest(fc);
        return this.httpProvider.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    private FilterContext preProcessRequest(FilterContext fc) throws IOException {
        for (RequestFilter asyncFilter : this.config.getRequestFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException e) {
                IOException ex = new IOException();
                ex.initCause(e);
                throw ex;
            }
        }
        Request request = fc.getRequest();
        if (fc.getAsyncHandler() instanceof ResumableAsyncHandler) {
            request = ((ResumableAsyncHandler)ResumableAsyncHandler.class.cast(fc.getAsyncHandler())).adjustRequestRange(request);
        }
        if (request.getRangeOffset() != 0L) {
            RequestBuilder builder = new RequestBuilder(request);
            builder.setHeader("Range", "bytes=" + request.getRangeOffset() + "-");
            request = builder.build();
        }
        fc = new FilterContext.FilterContextBuilder(fc).request(request).build();
        return fc;
    }

    private static final AsyncHttpProvider loadDefaultProvider(String className, AsyncHttpClientConfig config) {
        try {
            Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (AsyncHttpProvider)providerClass.getDeclaredConstructor(AsyncHttpClientConfig.class).newInstance(config);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)t;
                if (logger.isErrorEnabled()) {
                    logger.error("Unable to instantiate provider {}.  Trying other providers.", (Object)className);
                    logger.error(ite.getCause().toString(), ite.getCause());
                }
            }
            try {
                Class<?> providerClass = AsyncHttpClient.class.getClassLoader().loadClass(className);
                return (AsyncHttpProvider)providerClass.getDeclaredConstructor(AsyncHttpClientConfig.class).newInstance(config);
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Default provider not found {}. Using the {}", (Object)DEFAULT_PROVIDER, (Object)JDKAsyncHttpProvider.class.getName());
                }
                return new JDKAsyncHttpProvider(config);
            }
        }
    }

    protected BoundRequestBuilder requestBuilder(String reqType, String url) {
        return new BoundRequestBuilder(reqType, this.config.isUseRawUrl()).setUrl(url).setSignatureCalculator(this.signatureCalculator);
    }

    protected BoundRequestBuilder requestBuilder(Request prototype) {
        return new BoundRequestBuilder(prototype).setSignatureCalculator(this.signatureCalculator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BoundRequestBuilder
    extends RequestBuilderBase<BoundRequestBuilder> {
        private BoundRequestBuilder(String reqType, boolean useRawUrl) {
            super(BoundRequestBuilder.class, reqType, useRawUrl);
        }

        private BoundRequestBuilder(Request prototype) {
            super(BoundRequestBuilder.class, prototype);
        }

        public <T> ListenableFuture<T> execute(AsyncHandler<T> handler) throws IOException {
            return AsyncHttpClient.this.executeRequest(this.build(), handler);
        }

        public ListenableFuture<Response> execute() throws IOException {
            return AsyncHttpClient.this.executeRequest(this.build(), new AsyncCompletionHandlerBase());
        }

        @Override
        public BoundRequestBuilder addBodyPart(Part part) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.addBodyPart(part);
        }

        @Override
        public BoundRequestBuilder addCookie(Cookie cookie) {
            return (BoundRequestBuilder)super.addCookie(cookie);
        }

        @Override
        public BoundRequestBuilder addHeader(String name, String value) {
            return (BoundRequestBuilder)super.addHeader(name, value);
        }

        @Override
        public BoundRequestBuilder addParameter(String key, String value) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.addParameter(key, value);
        }

        @Override
        public BoundRequestBuilder addQueryParameter(String name, String value) {
            return (BoundRequestBuilder)super.addQueryParameter(name, value);
        }

        @Override
        public Request build() {
            return super.build();
        }

        @Override
        public BoundRequestBuilder setBody(byte[] data) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(data);
        }

        @Override
        public BoundRequestBuilder setBody(Request.EntityWriter dataWriter, long length) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(dataWriter, length);
        }

        @Override
        public BoundRequestBuilder setBody(Request.EntityWriter dataWriter) {
            return (BoundRequestBuilder)super.setBody(dataWriter);
        }

        @Override
        public BoundRequestBuilder setBody(InputStream stream) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(stream);
        }

        @Override
        public BoundRequestBuilder setBody(String data) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(data);
        }

        @Override
        public BoundRequestBuilder setHeader(String name, String value) {
            return (BoundRequestBuilder)super.setHeader(name, value);
        }

        @Override
        public BoundRequestBuilder setHeaders(FluentCaseInsensitiveStringsMap headers) {
            return (BoundRequestBuilder)super.setHeaders(headers);
        }

        @Override
        public BoundRequestBuilder setHeaders(Map<String, Collection<String>> headers) {
            return (BoundRequestBuilder)super.setHeaders(headers);
        }

        @Override
        public BoundRequestBuilder setParameters(Map<String, Collection<String>> parameters) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setParameters(parameters);
        }

        @Override
        public BoundRequestBuilder setParameters(FluentStringsMap parameters) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setParameters(parameters);
        }

        @Override
        public BoundRequestBuilder setUrl(String url) {
            return (BoundRequestBuilder)super.setUrl(url);
        }

        @Override
        public BoundRequestBuilder setVirtualHost(String virtualHost) {
            return (BoundRequestBuilder)super.setVirtualHost(virtualHost);
        }

        @Override
        public BoundRequestBuilder setSignatureCalculator(SignatureCalculator signatureCalculator) {
            return (BoundRequestBuilder)super.setSignatureCalculator(signatureCalculator);
        }
    }
}

