/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.date;

import com.ning.http.client.date.RFC2616Date;

public class RFC2616DateParser {
    private final String string;
    private final int offset;
    private final int length;

    public RFC2616DateParser(String string) {
        this(string, 0, string.length());
    }

    public RFC2616DateParser(String string, int offset, int length) {
        if (string.length() + offset < length) {
            throw new IllegalArgumentException("String length doesn't match offset and length");
        }
        this.string = string;
        this.offset = offset;
        this.length = length;
    }

    private Tokens tokenize() {
        int[] starts = new int[8];
        int[] ends = new int[8];
        boolean inToken = false;
        int tokenCount = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            char c = this.string.charAt(i);
            if (c == ' ' || c == ',' || c == '-' || c == ':') {
                if (!inToken) continue;
                ends[tokenCount++] = i;
                inToken = false;
                continue;
            }
            if (inToken) continue;
            starts[tokenCount] = i;
            inToken = true;
        }
        inToken = true;
        if (true) {
            ends[tokenCount++] = end;
        }
        return new Tokens(starts, ends, tokenCount);
    }

    public RFC2616Date parse() {
        Tokens tokens = this.tokenize();
        if (tokens.length != 7 && tokens.length != 8) {
            return null;
        }
        if (this.isDigit(this.string.charAt(tokens.starts[1]))) {
            return this.buildDate(tokens);
        }
        return this.buildANSICDate(tokens);
    }

    private RFC2616Date buildDate(Tokens tokens) {
        RFC2616Date.Builder dateBuilder = new RFC2616Date.Builder();
        if (this.isValidDayOfMonth(tokens.starts[1], tokens.ends[1], dateBuilder) && this.isValidMonth(tokens.starts[2], tokens.ends[2], dateBuilder) && this.isValidYear(tokens.starts[3], tokens.ends[3], dateBuilder) && this.isValidHour(tokens.starts[4], tokens.ends[4], dateBuilder) && this.isValidMinuteSecond(tokens.starts[5], tokens.ends[5], dateBuilder, true) && this.isValidMinuteSecond(tokens.starts[6], tokens.ends[6], dateBuilder, false)) {
            return dateBuilder.build();
        }
        return null;
    }

    private RFC2616Date buildANSICDate(Tokens tokens) {
        RFC2616Date.Builder dateBuilder = new RFC2616Date.Builder();
        if (this.isValidMonth(tokens.starts[1], tokens.ends[1], dateBuilder) && this.isValidDayOfMonth(tokens.starts[2], tokens.ends[2], dateBuilder) && this.isValidHour(tokens.starts[3], tokens.ends[3], dateBuilder) && this.isValidMinuteSecond(tokens.starts[4], tokens.ends[4], dateBuilder, true) && this.isValidMinuteSecond(tokens.starts[5], tokens.ends[5], dateBuilder, false) && this.isValidYear(tokens.starts[6], tokens.ends[6], dateBuilder)) {
            return dateBuilder.build();
        }
        return null;
    }

    private boolean isValid1DigitDayOfMonth(char c0, RFC2616Date.Builder dateBuilder) {
        if (this.isDigit(c0)) {
            dateBuilder.setDayOfMonth(this.getNumericValue(c0));
            return true;
        }
        return false;
    }

    private boolean isValid2DigitsDayOfMonth(char c0, char c1, RFC2616Date.Builder dateBuilder) {
        int i1;
        int i0;
        int day;
        if (this.isDigit(c0) && this.isDigit(c1) && (day = (i0 = this.getNumericValue(c0)) * 10 + (i1 = this.getNumericValue(c1))) <= 31) {
            dateBuilder.setDayOfMonth(day);
            return true;
        }
        return false;
    }

    private boolean isValidDayOfMonth(int start, int end, RFC2616Date.Builder dateBuilder) {
        int tokenLength = end - start;
        if (tokenLength == 1) {
            char c0 = this.string.charAt(start);
            return this.isValid1DigitDayOfMonth(c0, dateBuilder);
        }
        if (tokenLength == 2) {
            char c0 = this.string.charAt(start);
            char c1 = this.string.charAt(start + 1);
            return this.isValid2DigitsDayOfMonth(c0, c1, dateBuilder);
        }
        return false;
    }

    private boolean isValidJanuaryJuneJuly(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (c0 == 'J' || c0 == 'j') {
            if (c1 == 'a' || c1 == 'A') {
                if (c2 == 'n' || c2 == 'N') {
                    dateBuilder.setJanuary();
                    return true;
                }
            } else if (c1 == 'u' || c1 == 'U') {
                if (c2 == 'n' || c2 == 'N') {
                    dateBuilder.setJune();
                    return true;
                }
                if (c2 == 'l' || c2 == 'L') {
                    dateBuilder.setJuly();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isValidFebruary(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (!(c0 != 'F' && c0 != 'f' || c1 != 'e' && c1 != 'E' || c2 != 'b' && c2 != 'B')) {
            dateBuilder.setFebruary();
            return true;
        }
        return false;
    }

    private boolean isValidMarchMay(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (!(c0 != 'M' && c0 != 'm' || c1 != 'a' && c1 != 'A')) {
            if (c2 == 'r' || c2 == 'R') {
                dateBuilder.setMarch();
                return true;
            }
            if (c2 == 'y' || c2 == 'M') {
                dateBuilder.setMay();
                return true;
            }
        }
        return false;
    }

    private boolean isValidAprilAugust(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (c0 == 'A' || c0 == 'a') {
            if (!(c1 != 'p' && c1 != 'P' || c2 != 'r' && c2 != 'R')) {
                dateBuilder.setApril();
                return true;
            }
            if (!(c1 != 'u' && c1 != 'U' || c2 != 'g' && c2 != 'G')) {
                dateBuilder.setAugust();
                return true;
            }
        }
        return false;
    }

    private boolean isValidSeptember(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (!(c0 != 'S' && c0 != 's' || c1 != 'e' && c1 != 'E' || c2 != 'p' && c2 != 'P')) {
            dateBuilder.setSeptember();
            return true;
        }
        return false;
    }

    private boolean isValidOctober(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (!(c0 != 'O' && c0 != 'o' || c1 != 'c' && c1 != 'C' || c2 != 't' && c2 != 'T')) {
            dateBuilder.setOctobre();
            return true;
        }
        return false;
    }

    private boolean isValidNovember(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (!(c0 != 'N' && c0 != 'n' || c1 != 'o' && c1 != 'O' || c2 != 'v' && c2 != 'V')) {
            dateBuilder.setNovembre();
            return true;
        }
        return false;
    }

    private boolean isValidDecember(char c0, char c1, char c2, RFC2616Date.Builder dateBuilder) {
        if (!(c0 != 'D' && c0 != 'd' || c1 != 'e' && c1 != 'E' || c2 != 'c' && c2 != 'C')) {
            dateBuilder.setDecember();
            return true;
        }
        return false;
    }

    private boolean isValidMonth(int start, int end, RFC2616Date.Builder dateBuilder) {
        char c2;
        char c1;
        if (end - start != 3) {
            return false;
        }
        char c0 = this.string.charAt(start);
        return this.isValidJanuaryJuneJuly(c0, c1 = this.string.charAt(start + 1), c2 = this.string.charAt(start + 2), dateBuilder) || this.isValidFebruary(c0, c1, c2, dateBuilder) || this.isValidMarchMay(c0, c1, c2, dateBuilder) || this.isValidAprilAugust(c0, c1, c2, dateBuilder) || this.isValidSeptember(c0, c1, c2, dateBuilder) || this.isValidOctober(c0, c1, c2, dateBuilder) || this.isValidNovember(c0, c1, c2, dateBuilder) || this.isValidDecember(c0, c1, c2, dateBuilder);
    }

    private boolean isValid2DigitsYear(char c0, char c1, RFC2616Date.Builder dateBuilder) {
        if (this.isDigit(c0) && this.isDigit(c1)) {
            int i1;
            int i0 = this.getNumericValue(c0);
            int year = i0 * 10 + (i1 = this.getNumericValue(c1));
            year = year < 70 ? year + 2000 : year + 1900;
            return this.setValidYear(year, dateBuilder);
        }
        return false;
    }

    private boolean isValid4DigitsYear(char c0, char c1, char c2, char c3, RFC2616Date.Builder dateBuilder) {
        if (this.isDigit(c0) && this.isDigit(c1) && this.isDigit(c2) && this.isDigit(c3)) {
            int i0 = this.getNumericValue(c0);
            int i1 = this.getNumericValue(c1);
            int i2 = this.getNumericValue(c2);
            int i3 = this.getNumericValue(c3);
            int year = i0 * 1000 + i1 * 100 + i2 * 10 + i3;
            return this.setValidYear(year, dateBuilder);
        }
        return false;
    }

    private boolean setValidYear(int year, RFC2616Date.Builder dateBuilder) {
        if (year >= 1601) {
            dateBuilder.setYear(year);
            return true;
        }
        return false;
    }

    private boolean isValidYear(int start, int end, RFC2616Date.Builder dateBuilder) {
        int length = end - start;
        if (length == 2) {
            char c0 = this.string.charAt(start);
            char c1 = this.string.charAt(start + 1);
            return this.isValid2DigitsYear(c0, c1, dateBuilder);
        }
        if (length == 4) {
            char c0 = this.string.charAt(start);
            char c1 = this.string.charAt(start + 1);
            char c2 = this.string.charAt(start + 2);
            char c3 = this.string.charAt(start + 3);
            return this.isValid4DigitsYear(c0, c1, c2, c3, dateBuilder);
        }
        return false;
    }

    private boolean isValid1DigitHour(char c0, RFC2616Date.Builder dateBuilder) {
        if (this.isDigit(c0)) {
            int hour = this.getNumericValue(c0);
            dateBuilder.setHour(hour);
            return true;
        }
        return false;
    }

    private boolean isValid2DigitsHour(char c0, char c1, RFC2616Date.Builder dateBuilder) {
        int i1;
        int i0;
        int hour;
        if (this.isDigit(c0) && this.isDigit(c1) && (hour = (i0 = this.getNumericValue(c0)) * 10 + (i1 = this.getNumericValue(c1))) <= 24) {
            dateBuilder.setHour(hour);
            return true;
        }
        return false;
    }

    private boolean isValidHour(int start, int end, RFC2616Date.Builder dateBuilder) {
        int length = end - start;
        if (length == 1) {
            char c0 = this.string.charAt(start);
            return this.isValid1DigitHour(c0, dateBuilder);
        }
        if (length == 2) {
            char c0 = this.string.charAt(start);
            char c1 = this.string.charAt(start + 1);
            return this.isValid2DigitsHour(c0, c1, dateBuilder);
        }
        return false;
    }

    private boolean isValid1DigitMinuteSecond(char c0, RFC2616Date.Builder dateBuilder, boolean minuteOrSecond) {
        if (this.isDigit(c0)) {
            int value = this.getNumericValue(c0);
            if (minuteOrSecond) {
                dateBuilder.setMinute(value);
            } else {
                dateBuilder.setSecond(value);
            }
            return true;
        }
        return false;
    }

    private boolean isValid2DigitsMinuteSecond(char c0, char c1, RFC2616Date.Builder dateBuilder, boolean minuteOrSecond) {
        int i1;
        int i0;
        int value;
        if (this.isDigit(c0) && this.isDigit(c1) && (value = (i0 = this.getNumericValue(c0)) * 10 + (i1 = this.getNumericValue(c1))) <= 60) {
            if (minuteOrSecond) {
                dateBuilder.setMinute(value);
            } else {
                dateBuilder.setSecond(value);
            }
            return true;
        }
        return false;
    }

    private boolean isValidMinuteSecond(int start, int end, RFC2616Date.Builder dateBuilder, boolean minuteOrSecond) {
        int length = end - start;
        if (length == 1) {
            char c0 = this.string.charAt(start);
            return this.isValid1DigitMinuteSecond(c0, dateBuilder, minuteOrSecond);
        }
        if (length == 2) {
            char c0 = this.string.charAt(start);
            char c1 = this.string.charAt(start + 1);
            return this.isValid2DigitsMinuteSecond(c0, c1, dateBuilder, minuteOrSecond);
        }
        return false;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private int getNumericValue(char c) {
        return c - 48;
    }

    private static class Tokens {
        public final int[] starts;
        public final int[] ends;
        public final int length;

        public Tokens(int[] starts, int[] ends, int length) {
            this.starts = starts;
            this.ends = ends;
            this.length = length;
        }
    }
}

