/*
 * Decompiled with CFR 0.152.
 */
package com.ning.org.jboss.netty.handler.codec.http;

import com.ning.http.client.Cookie;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CookieEncoder {
    private CookieEncoder() {
    }

    public static String encodeClientSide(Collection<Cookie> cookies, boolean useRFC6265Style) {
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : cookies) {
            if (useRFC6265Style) {
                CookieEncoder.encodeRFC6265Style(sb, cookie);
                continue;
            }
            CookieEncoder.encodeRFC2965Style(sb, cookie);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private static void encodeRFC6265Style(StringBuilder sb, Cookie cookie) {
        CookieEncoder.addUnquoted(sb, cookie.getName(), cookie.getRawValue());
    }

    private static void encodeRFC2965Style(StringBuilder sb, Cookie cookie) {
        if (cookie.getVersion() >= 1) {
            CookieEncoder.add(sb, "$Version", 1);
        }
        CookieEncoder.add(sb, cookie.getName(), cookie.getValue());
        if (cookie.getPath() != null) {
            CookieEncoder.add(sb, "$Path", cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            CookieEncoder.add(sb, "$Domain", cookie.getDomain());
        }
        if (cookie.getVersion() >= 1 && !cookie.getPorts().isEmpty()) {
            sb.append('$');
            sb.append("Port");
            sb.append('=');
            sb.append('\"');
            for (int port : cookie.getPorts()) {
                sb.append(port);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, '\"');
            sb.append(';');
            sb.append(' ');
        }
    }

    private static void add(StringBuilder sb, String name, String val) {
        if (val == null) {
            CookieEncoder.addQuoted(sb, name, "");
            return;
        }
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    CookieEncoder.addQuoted(sb, name, val);
                    return;
                }
            }
        }
        CookieEncoder.addUnquoted(sb, name, val);
    }

    private static void addUnquoted(StringBuilder sb, String name, String val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }

    private static void addQuoted(StringBuilder sb, String name, String val) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        sb.append('\"');
        sb.append(val.replace("\\", "\\\\").replace("\"", "\\\""));
        sb.append('\"');
        sb.append(';');
        sb.append(' ');
    }

    private static void add(StringBuilder sb, String name, int val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }
}

