/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionPoolKeyStrategy;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.client.providers.netty.BodyChunkedInput;
import com.ning.http.client.providers.netty.BodyFileRegion;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.NettyConnectListener;
import com.ning.http.client.providers.netty.NettyConnectionsPool;
import com.ning.http.client.providers.netty.NettyResponse;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.NettyWebSocket;
import com.ning.http.client.providers.netty.Protocol;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.client.providers.netty.ResponseHeaders;
import com.ning.http.client.providers.netty.ResponseStatus;
import com.ning.http.client.providers.netty.WebSocketUtil;
import com.ning.http.client.providers.netty.spnego.SpnegoEngine;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.multipart.MultipartBody;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.CleanupChannelGroup;
import com.ning.http.util.DateUtil;
import com.ning.http.util.MiscUtil;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import com.ning.org.jboss.netty.handler.codec.http.CookieDecoder;
import com.ning.org.jboss.netty.handler.codec.http.CookieEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.PrematureChannelClosureException;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider {
    public static final String GZIP_DEFLATE = "gzip,deflate";
    public static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Remotely Closed");
    private static final String HTTP_HANDLER = "httpHandler";
    protected static final String SSL_HANDLER = "sslHandler";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String WEBSOCKET = "ws";
    private static final String WEBSOCKET_SSL = "wss";
    private static final Logger log;
    private static final Charset UTF8;
    private final ClientBootstrap plainBootstrap;
    private final ClientBootstrap secureBootstrap;
    private final ClientBootstrap webSocketBootstrap;
    private final ClientBootstrap secureWebSocketBootstrap;
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final ClientSocketChannelFactory socketChannelFactory;
    private final boolean allowReleaseSocketChannelFactory;
    private int httpClientCodecMaxInitialLineLength = 4096;
    private int httpClientCodecMaxHeaderSize = 8192;
    private int httpClientCodecMaxChunkSize = 8192;
    private int httpsClientCodecMaxInitialLineLength = 4096;
    private int httpsClientCodecMaxHeaderSize = 8192;
    private int httpsClientCodecMaxChunkSize = 8192;
    private final ChannelGroup openChannels = new CleanupChannelGroup("asyncHttpClient"){

        public boolean remove(Object o) {
            boolean removed = super.remove(o);
            if (removed && NettyAsyncHttpProvider.this.trackConnections) {
                NettyAsyncHttpProvider.this.freeConnections.release();
            }
            return removed;
        }
    };
    private final ConnectionsPool<String, Channel> connectionsPool;
    private Semaphore freeConnections = null;
    private final NettyAsyncHttpProviderConfig asyncHttpProviderConfig;
    private boolean executeConnectAsync = true;
    public static final ThreadLocal<Boolean> IN_IO_THREAD;
    private final boolean trackConnections;
    private final boolean useRawUrl;
    private static final NTLMEngine ntlmEngine;
    private static SpnegoEngine spnegoEngine;
    private final Protocol httpProtocol = new HttpProtocol();
    private final Protocol webSocketProtocol = new WebSocketProtocol();

    private static boolean isNTLM(List<String> auth) {
        return MiscUtil.isNonEmpty(auth) && auth.get(0).startsWith("NTLM");
    }

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.asyncHttpProviderConfig = config.getAsyncHttpProviderConfig() instanceof NettyAsyncHttpProviderConfig ? (NettyAsyncHttpProviderConfig)NettyAsyncHttpProviderConfig.class.cast(config.getAsyncHttpProviderConfig()) : new NettyAsyncHttpProviderConfig();
        if (this.asyncHttpProviderConfig.getProperty("useBlockingIO") != null) {
            this.socketChannelFactory = new OioClientSocketChannelFactory((Executor)config.executorService());
            this.allowReleaseSocketChannelFactory = true;
        } else {
            Object oo = this.asyncHttpProviderConfig.getProperty("socketChannelFactory");
            if (oo instanceof NioClientSocketChannelFactory) {
                this.socketChannelFactory = (ClientSocketChannelFactory)NioClientSocketChannelFactory.class.cast(oo);
                this.allowReleaseSocketChannelFactory = false;
            } else {
                Object o = this.asyncHttpProviderConfig.getProperty("bossExecutorService");
                ExecutorService e = o instanceof ExecutorService ? (ExecutorService)ExecutorService.class.cast(o) : Executors.newCachedThreadPool();
                int numWorkers = config.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
                log.debug("Number of application's worker threads is {}", (Object)numWorkers);
                this.socketChannelFactory = new NioClientSocketChannelFactory((Executor)e, (Executor)config.executorService(), numWorkers);
                this.allowReleaseSocketChannelFactory = true;
            }
        }
        this.plainBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.webSocketBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureWebSocketBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.config = config;
        this.configureNetty();
        ConnectionsPool<String, Channel> cp = config.getConnectionsPool();
        if (cp == null && config.getAllowPoolingConnection()) {
            cp = new NettyConnectionsPool(this);
        } else if (cp == null) {
            cp = new NonConnectionsPool();
        }
        this.connectionsPool = cp;
        if (config.getMaxTotalConnections() != -1) {
            this.trackConnections = true;
            this.freeConnections = new Semaphore(config.getMaxTotalConnections());
        } else {
            this.trackConnections = false;
        }
        this.useRawUrl = config.isUseRawUrl();
    }

    public String toString() {
        int availablePermits = this.freeConnections != null ? this.freeConnections.availablePermits() : 0;
        return String.format("NettyAsyncHttpProvider:\n\t- maxConnections: %d\n\t- openChannels: %s\n\t- connectionPools: %s", this.config.getMaxTotalConnections() - availablePermits, this.openChannels.toString(), this.connectionsPool.toString());
    }

    void configureNetty() {
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.plainBootstrap.setOption(entry.getKey(), entry.getValue());
            }
            this.configureHttpClientCodec();
            this.configureHttpsClientCodec();
        }
        this.plainBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)NettyAsyncHttpProvider.this.createHttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.getRequestCompressionLevel() > 0) {
                    pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor(NettyAsyncHttpProvider.this.config.getRequestCompressionLevel()));
                }
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        DefaultChannelFuture.setUseDeadLockChecker((boolean)false);
        if (this.asyncHttpProviderConfig != null) {
            Object value = this.asyncHttpProviderConfig.getProperty("asyncConnect");
            if (value instanceof Boolean) {
                this.executeConnectAsync = (Boolean)Boolean.class.cast(value);
            } else if (this.asyncHttpProviderConfig.getProperty("disableNestedRequest") != null) {
                DefaultChannelFuture.setUseDeadLockChecker((boolean)true);
            }
        }
        this.webSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("http-decoder", (ChannelHandler)new HttpResponseDecoder());
                pipeline.addLast("http-encoder", (ChannelHandler)new HttpRequestEncoder());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
    }

    protected void configureHttpClientCodec() {
        this.httpClientCodecMaxInitialLineLength = this.asyncHttpProviderConfig.getProperty("httpClientCodecMaxInitialLineLength", Integer.class, this.httpClientCodecMaxInitialLineLength);
        this.httpClientCodecMaxHeaderSize = this.asyncHttpProviderConfig.getProperty("httpClientCodecMaxHeaderSize", Integer.class, this.httpClientCodecMaxHeaderSize);
        this.httpClientCodecMaxChunkSize = this.asyncHttpProviderConfig.getProperty("httpClientCodecMaxChunkSize", Integer.class, this.httpClientCodecMaxChunkSize);
    }

    protected void configureHttpsClientCodec() {
        this.httpsClientCodecMaxInitialLineLength = this.asyncHttpProviderConfig.getProperty("httpsClientCodecMaxInitialLineLength", Integer.class, this.httpsClientCodecMaxInitialLineLength);
        this.httpsClientCodecMaxHeaderSize = this.asyncHttpProviderConfig.getProperty("httpsClientCodecMaxHeaderSize", Integer.class, this.httpsClientCodecMaxHeaderSize);
        this.httpsClientCodecMaxChunkSize = this.asyncHttpProviderConfig.getProperty("httpsClientCodecMaxChunkSize", Integer.class, this.httpsClientCodecMaxChunkSize);
    }

    void constructSSLPipeline(final NettyConnectListener<?> cl) {
        this.secureBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                try {
                    pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, (ChannelHandler)new SslHandler(NettyAsyncHttpProvider.this.createSSLEngine()));
                }
                catch (Throwable ex) {
                    NettyAsyncHttpProvider.this.abort(cl.future(), ex);
                }
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)NettyAsyncHttpProvider.this.createHttpsClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        this.secureWebSocketBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                try {
                    pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, (ChannelHandler)new SslHandler(NettyAsyncHttpProvider.this.createSSLEngine()));
                }
                catch (Throwable ex) {
                    NettyAsyncHttpProvider.this.abort(cl.future(), ex);
                }
                pipeline.addLast("http-decoder", (ChannelHandler)new HttpResponseDecoder());
                pipeline.addLast("http-encoder", (ChannelHandler)new HttpRequestEncoder());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.secureBootstrap.setOption(entry.getKey(), entry.getValue());
                this.secureWebSocketBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
    }

    private Channel lookupInCache(URI uri, ConnectionPoolKeyStrategy connectionPoolKeyStrategy) {
        Channel channel = this.connectionsPool.poll(connectionPoolKeyStrategy.getKey(uri));
        if (channel != null) {
            log.debug("Using cached Channel {}\n for uri {}\n", (Object)channel, (Object)uri);
            try {
                return this.verifyChannelPipeline(channel, uri.getScheme());
            }
            catch (Exception ex) {
                log.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private SSLEngine createSSLEngine() throws IOException, GeneralSecurityException {
        SSLEngine sslEngine = this.config.getSSLEngineFactory().newSSLEngine();
        if (sslEngine == null) {
            sslEngine = SslUtils.getSSLEngine();
        }
        return sslEngine;
    }

    private HttpClientCodec createHttpClientCodec() {
        return new HttpClientCodec(this.httpClientCodecMaxInitialLineLength, this.httpClientCodecMaxHeaderSize, this.httpClientCodecMaxChunkSize);
    }

    private HttpClientCodec createHttpsClientCodec() {
        return new HttpClientCodec(this.httpsClientCodecMaxInitialLineLength, this.httpsClientCodecMaxHeaderSize, this.httpsClientCodecMaxChunkSize);
    }

    private Channel verifyChannelPipeline(Channel channel, String scheme) throws IOException, GeneralSecurityException {
        if (channel.getPipeline().get(SSL_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
            channel.getPipeline().remove(SSL_HANDLER);
        } else {
            if (channel.getPipeline().get(HTTP_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
                return channel;
            }
            if (channel.getPipeline().get(SSL_HANDLER) == null && NettyAsyncHttpProvider.isSecure(scheme)) {
                channel.getPipeline().addFirst(SSL_HANDLER, (ChannelHandler)new SslHandler(this.createSSLEngine()));
            }
        }
        return channel;
    }

    protected final <T> void writeRequest(Channel channel, AsyncHttpClientConfig config, NettyResponseFuture<T> future) {
        block39: {
            HttpRequest nettyRequest = future.getNettyRequest();
            boolean ssl = channel.getPipeline().get(SslHandler.class) != null;
            try {
                if (!channel.isOpen() || !channel.isConnected()) {
                    return;
                }
                Body body = null;
                if (!nettyRequest.getMethod().equals((Object)HttpMethod.CONNECT)) {
                    BodyGenerator bg = future.getRequest().getBodyGenerator();
                    if (bg != null) {
                        if (bg instanceof InputStreamBodyGenerator) {
                            ((InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(bg)).patchNettyChunkingIssue(true);
                        }
                        try {
                            body = bg.createBody();
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                        long length = body.getContentLength();
                        if (length >= 0L) {
                            nettyRequest.setHeader("Content-Length", (Object)length);
                        } else {
                            nettyRequest.setHeader("Transfer-Encoding", (Object)"chunked");
                        }
                    } else if (future.getRequest().getParts() != null) {
                        String contentType = nettyRequest.getHeader("Content-Type");
                        String contentLength = nettyRequest.getHeader("Content-Length");
                        long length = -1L;
                        if (contentLength != null) {
                            length = Long.parseLong(contentLength);
                        } else {
                            nettyRequest.addHeader("Transfer-Encoding", (Object)"chunked");
                        }
                        body = new MultipartBody(future.getRequest().getParts(), contentType, length);
                    }
                }
                if (future.getAsyncHandler() instanceof TransferCompletionHandler) {
                    FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
                    for (String s : nettyRequest.getHeaderNames()) {
                        for (String header : nettyRequest.getHeaders(s)) {
                            h.add(s, header);
                        }
                    }
                    ((TransferCompletionHandler)TransferCompletionHandler.class.cast(future.getAsyncHandler())).transferAdapter(new NettyTransferAdapter(h, nettyRequest.getContent(), future.getRequest().getFile()));
                }
                if (future.getAndSetWriteHeaders(true)) {
                    try {
                        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRequestSent();
                        }
                        channel.write((Object)nettyRequest).addListener((ChannelFutureListener)new ProgressListener(true, future.getAsyncHandler(), future));
                    }
                    catch (Throwable cause) {
                        log.debug(cause.getMessage(), cause);
                        try {
                            channel.close();
                        }
                        catch (RuntimeException ex) {
                            log.debug(ex.getMessage(), (Throwable)ex);
                        }
                        return;
                    }
                }
                if (!future.getAndSetWriteBody(true) || nettyRequest.getMethod().equals((Object)HttpMethod.CONNECT)) break block39;
                if (future.getRequest().getFile() != null) {
                    File file = future.getRequest().getFile();
                    long fileLength = 0L;
                    final RandomAccessFile raf = new RandomAccessFile(file, "r");
                    try {
                        ChannelFuture writeFuture;
                        fileLength = raf.length();
                        if (ssl) {
                            writeFuture = channel.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
                        } else {
                            OptimizedFileRegion region = new OptimizedFileRegion(raf, 0L, fileLength);
                            writeFuture = channel.write((Object)region);
                        }
                        writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future){

                            public void operationComplete(ChannelFuture cf) {
                                try {
                                    raf.close();
                                }
                                catch (IOException e) {
                                    log.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                                }
                                super.operationComplete(cf);
                            }
                        });
                        break block39;
                    }
                    catch (IOException ex) {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                }
                if (body != null) {
                    ChannelFuture writeFuture;
                    if (!ssl && body instanceof RandomAccessBody) {
                        BodyFileRegion bodyFileRegion = new BodyFileRegion((RandomAccessBody)body);
                        writeFuture = channel.write((Object)bodyFileRegion);
                    } else {
                        BodyChunkedInput bodyChunkedInput = new BodyChunkedInput(body);
                        writeFuture = channel.write((Object)bodyChunkedInput);
                    }
                    final Body b = body;
                    writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future){

                        public void operationComplete(ChannelFuture cf) {
                            try {
                                b.close();
                            }
                            catch (IOException e) {
                                log.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                            }
                            super.operationComplete(cf);
                        }
                    });
                }
            }
            catch (Throwable ioe) {
                try {
                    channel.close();
                }
                catch (RuntimeException ex) {
                    log.debug(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        try {
            int schedulePeriod;
            future.touch();
            int requestTimeout = NettyAsyncHttpProvider.requestTimeoutInMs(config, future.getRequest().getPerRequestConfig());
            int n = requestTimeout != -1 ? (config.getIdleConnectionTimeoutInMs() != -1 ? Math.min(requestTimeout, config.getIdleConnectionTimeoutInMs()) : requestTimeout) : (schedulePeriod = config.getIdleConnectionTimeoutInMs());
            if (schedulePeriod != -1 && !future.isDone() && !future.isCancelled()) {
                ReaperFuture reaperFuture = new ReaperFuture(future);
                ScheduledFuture<?> scheduledFuture = config.reaper().scheduleAtFixedRate(reaperFuture, 0L, schedulePeriod, TimeUnit.MILLISECONDS);
                reaperFuture.setScheduledFuture(scheduledFuture);
                future.setReaperFuture(reaperFuture);
            }
        }
        catch (RejectedExecutionException ex) {
            this.abort(future, ex);
        }
    }

    protected static final HttpRequest buildRequest(AsyncHttpClientConfig config, Request request, URI uri, boolean allowConnect, ChannelBuffer buffer, ProxyServer proxyServer) throws IOException {
        String method = request.getMethod();
        if (allowConnect && proxyServer != null && NettyAsyncHttpProvider.isSecure(uri)) {
            method = HttpMethod.CONNECT.toString();
        }
        return NettyAsyncHttpProvider.construct(config, request, new HttpMethod(method), uri, buffer, proxyServer);
    }

    private static SpnegoEngine getSpnegoEngine() {
        if (spnegoEngine == null) {
            spnegoEngine = new SpnegoEngine();
        }
        return spnegoEngine;
    }

    private static HttpRequest construct(AsyncHttpClientConfig config, Request request, HttpMethod m, URI uri, ChannelBuffer buffer, ProxyServer proxyServer) throws IOException {
        String userAgentHeader;
        Realm realm;
        DefaultHttpRequest nettyRequest;
        String host = null;
        host = request.getVirtualHost() != null ? request.getVirtualHost() : AsyncHttpProviderUtils.getHost(uri);
        if (m.equals((Object)HttpMethod.CONNECT)) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_0, m, AsyncHttpProviderUtils.getAuthority(uri));
        } else {
            String path = null;
            path = proxyServer != null && (!NettyAsyncHttpProvider.isSecure(uri) || !config.isUseRelativeURIsWithSSLProxies()) ? uri.toString() : (uri.getRawQuery() != null ? uri.getRawPath() + "?" + uri.getRawQuery() : uri.getRawPath());
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, path);
        }
        boolean webSocket = NettyAsyncHttpProvider.isWebSocket(uri);
        if (webSocket) {
            nettyRequest.addHeader("Upgrade", (Object)"WebSocket");
            nettyRequest.addHeader("Connection", (Object)"Upgrade");
            nettyRequest.addHeader("Origin", (Object)("http://" + uri.getHost() + ":" + uri.getPort()));
            nettyRequest.addHeader("Sec-WebSocket-Key", (Object)WebSocketUtil.getKey());
            nettyRequest.addHeader("Sec-WebSocket-Version", (Object)"13");
        }
        if (host != null) {
            if (request.getVirtualHost() != null || uri.getPort() == -1) {
                nettyRequest.setHeader("Host", (Object)host);
            } else {
                nettyRequest.setHeader("Host", (Object)(host + ":" + uri.getPort()));
            }
        } else {
            host = "127.0.0.1";
        }
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            for (Map.Entry<String, List<String>> header : request.getHeaders()) {
                String name = header.getKey();
                if ("Host".equalsIgnoreCase(name)) continue;
                for (String value : header.getValue()) {
                    nettyRequest.addHeader(name, (Object)value);
                }
            }
            if (config.isCompressionEnabled()) {
                nettyRequest.setHeader("Accept-Encoding", (Object)GZIP_DEFLATE);
            }
        } else {
            Object auth = request.getHeaders().get("Proxy-Authorization");
            if (NettyAsyncHttpProvider.isNTLM((List<String>)auth)) {
                nettyRequest.addHeader("Proxy-Authorization", auth.get(0));
            }
        }
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : config.getRealm();
        if (realm != null && realm.getUsePreemptiveAuth()) {
            String domain = realm.getNtlmDomain();
            if (proxyServer != null && proxyServer.getNtlmDomain() != null) {
                domain = proxyServer.getNtlmDomain();
            }
            String authHost = realm.getNtlmHost();
            if (proxyServer != null && proxyServer.getHost() != null) {
                host = proxyServer.getHost();
            }
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    nettyRequest.addHeader("Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(realm));
                    break;
                }
                case DIGEST: {
                    if (!MiscUtil.isNonEmpty(realm.getNonce())) break;
                    try {
                        nettyRequest.addHeader("Authorization", (Object)AuthenticatorUtils.computeDigestAuthentication(realm));
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                case NTLM: {
                    try {
                        nettyRequest.addHeader("Authorization", (Object)ntlmEngine.generateType1Msg("NTLM " + domain, authHost));
                        break;
                    }
                    catch (NTLMEngineException e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                }
                case KERBEROS: 
                case SPNEGO: {
                    String challengeHeader = null;
                    String server = proxyServer == null ? host : proxyServer.getHost();
                    try {
                        challengeHeader = NettyAsyncHttpProvider.getSpnegoEngine().generateToken(server);
                    }
                    catch (Throwable e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                    nettyRequest.addHeader("Authorization", (Object)("Negotiate " + challengeHeader));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid Authentication %s", realm.toString()));
                }
            }
        }
        if (!webSocket && !request.getHeaders().containsKey("Connection")) {
            nettyRequest.setHeader("Connection", (Object)AsyncHttpProviderUtils.keepAliveHeaderValue(config));
        }
        if (proxyServer != null) {
            if (!request.getHeaders().containsKey("Proxy-Connection")) {
                nettyRequest.setHeader("Proxy-Connection", (Object)AsyncHttpProviderUtils.keepAliveHeaderValue(config));
            }
            if (proxyServer.getPrincipal() != null) {
                if (MiscUtil.isNonEmpty(proxyServer.getNtlmDomain())) {
                    Object auth = request.getHeaders().get("Proxy-Authorization");
                    if (!NettyAsyncHttpProvider.isNTLM((List<String>)auth)) {
                        try {
                            String msg = ntlmEngine.generateType1Msg(proxyServer.getNtlmDomain(), proxyServer.getHost());
                            nettyRequest.setHeader("Proxy-Authorization", (Object)("NTLM " + msg));
                        }
                        catch (NTLMEngineException e) {
                            IOException ie = new IOException();
                            ie.initCause(e);
                            throw ie;
                        }
                    }
                } else {
                    nettyRequest.setHeader("Proxy-Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(proxyServer));
                }
            }
        }
        if (!request.getHeaders().containsKey("Accept")) {
            nettyRequest.setHeader("Accept", (Object)"*/*");
        }
        if ((userAgentHeader = request.getHeaders().getFirstValue("User-Agent")) != null) {
            nettyRequest.setHeader("User-Agent", (Object)userAgentHeader);
        } else if (config.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", (Object)config.getUserAgent());
        } else {
            nettyRequest.setHeader("User-Agent", (Object)AsyncHttpProviderUtils.constructUserAgent(NettyAsyncHttpProvider.class));
        }
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            String bodyCharset;
            if (MiscUtil.isNonEmpty(request.getCookies())) {
                nettyRequest.setHeader("Cookie", (Object)CookieEncoder.encodeClientSide(request.getCookies(), config.isRfc6265CookieEncoding()));
            }
            String string = bodyCharset = request.getBodyEncoding() == null ? "ISO-8859-1" : request.getBodyEncoding();
            if (buffer != null && buffer.writerIndex() != 0) {
                nettyRequest.setHeader("Content-Length", (Object)buffer.writerIndex());
                nettyRequest.setContent(buffer);
            } else if (request.getByteData() != null) {
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getByteData().length));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])request.getByteData()));
            } else if (request.getStringData() != null) {
                byte[] bytes = request.getStringData().getBytes(bodyCharset);
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(bytes.length));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])bytes));
            } else if (request.getStreamData() != null) {
                int[] lengthWrapper = new int[1];
                byte[] bytes = AsyncHttpProviderUtils.readFully(request.getStreamData(), lengthWrapper);
                int length = lengthWrapper[0];
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(length));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])bytes, (int)0, (int)length));
            } else if (MiscUtil.isNonEmpty(request.getParams())) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                    String key = paramEntry.getKey();
                    for (String value : paramEntry.getValue()) {
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        UTF8UrlEncoder.appendEncoded(sb, key);
                        sb.append("=");
                        UTF8UrlEncoder.appendEncoded(sb, value);
                    }
                }
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(sb.length()));
                nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])sb.toString().getBytes(bodyCharset)));
                if (!request.getHeaders().containsKey("Content-Type")) {
                    nettyRequest.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                }
            } else if (request.getParts() != null) {
                MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getHeaders());
                nettyRequest.setHeader("Content-Type", (Object)mre.getContentType());
                long contentLength = mre.getContentLength();
                if (contentLength >= 0L) {
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(contentLength));
                }
            } else if (request.getEntityWriter() != null) {
                int length = (int)request.getContentLength();
                if (length == -1) {
                    length = 8192;
                }
                ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)length);
                request.getEntityWriter().writeEntity((OutputStream)new ChannelBufferOutputStream(b));
                nettyRequest.setHeader("Content-Length", (Object)b.writerIndex());
                nettyRequest.setContent(b);
            } else if (request.getFile() != null) {
                File file = request.getFile();
                if (!file.isFile()) {
                    throw new IOException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
                }
                nettyRequest.setHeader("Content-Length", (Object)file.length());
            }
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        this.isClose.set(true);
        try {
            this.connectionsPool.destroy();
            this.openChannels.close();
            for (Channel channel : this.openChannels) {
                ChannelHandlerContext ctx = channel.getPipeline().getContext(NettyAsyncHttpProvider.class);
                if (!(ctx.getAttachment() instanceof NettyResponseFuture)) continue;
                NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
                future.setReaperFuture(null);
            }
            this.config.executorService().shutdown();
            this.config.reaper().shutdown();
            if (this.allowReleaseSocketChannelFactory) {
                this.socketChannelFactory.releaseExternalResources();
                this.plainBootstrap.releaseExternalResources();
                this.secureBootstrap.releaseExternalResources();
                this.webSocketBootstrap.releaseExternalResources();
                this.secureWebSocketBootstrap.releaseExternalResources();
            }
        }
        catch (Throwable t) {
            log.warn("Unexpected error on close", t);
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        return new NettyResponse(status, headers, bodyParts);
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null, true, this.executeConnectAsync, false);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, useCache, asyncConnect, reclaimCache);
    }

    private <T> ListenableFuture<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        boolean directInvokation;
        ChannelFuture channelFuture;
        boolean useSSl;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (request.getUrl().startsWith(WEBSOCKET) && !NettyAsyncHttpProvider.validateWebSocketRequest(request, asyncHandler)) {
            throw new IOException("WebSocket method must be a GET");
        }
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        boolean useProxy = proxyServer != null;
        URI uri = this.useRawUrl ? request.getRawURI() : request.getURI();
        Channel channel = null;
        if (useCache) {
            if (f != null && f.reuseChannel() && f.channel() != null) {
                channel = f.channel();
            } else {
                URI connectionKeyUri = useProxy ? proxyServer.getURI() : uri;
                channel = this.lookupInCache(connectionKeyUri, request.getConnectionPoolKeyStrategy());
            }
        }
        ChannelBuffer bufferedBytes = null;
        if (f != null && f.getRequest().getFile() == null && !f.getNettyRequest().getMethod().getName().equals(HttpMethod.CONNECT.getName())) {
            bufferedBytes = f.getNettyRequest().getContent();
        }
        boolean bl = useSSl = NettyAsyncHttpProvider.isSecure(uri) && !useProxy;
        if (channel != null && channel.isOpen() && channel.isConnected()) {
            HttpRequest nettyRequest = null;
            if (f == null) {
                nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, false, bufferedBytes, proxyServer);
                f = NettyAsyncHttpProvider.newFuture(uri, request, asyncHandler, nettyRequest, this.config, this, proxyServer);
            } else {
                nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, f.isConnectAllowed(), bufferedBytes, proxyServer);
                f.setNettyRequest(nettyRequest);
            }
            f.setState(NettyResponseFuture.STATE.POOLED);
            f.attachChannel(channel, false);
            log.debug("\nUsing cached Channel {}\n for request \n{}\n", (Object)channel, (Object)nettyRequest);
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(f);
            try {
                this.writeRequest(channel, this.config, f);
            }
            catch (Exception ex) {
                log.debug("writeRequest failure", (Throwable)ex);
                if (useSSl && ex.getMessage() != null && ex.getMessage().contains("SSLEngine")) {
                    log.debug("SSLEngine failure", (Throwable)ex);
                    f = null;
                }
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Throwable t) {
                    log.warn("doConnect.writeRequest()", t);
                }
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            return f;
        }
        if (!reclaimCache && !this.connectionsPool.canCacheConnection()) {
            IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
            try {
                asyncHandler.onThrowable(ex);
            }
            catch (Throwable t) {
                log.warn("!connectionsPool.canCacheConnection()", t);
            }
            throw ex;
        }
        boolean acquiredConnection = false;
        if (this.trackConnections && !reclaimCache) {
            if (!this.freeConnections.tryAcquire()) {
                IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Throwable t) {
                    log.warn("!connectionsPool.canCacheConnection()", t);
                }
                throw ex;
            }
            acquiredConnection = true;
        }
        NettyConnectListener<T> c = new NettyConnectListener.Builder<T>(this.config, request, asyncHandler, f, this, bufferedBytes).build(uri);
        if (useSSl) {
            this.constructSSLPipeline(c);
        }
        ClientBootstrap bootstrap = request.getUrl().startsWith(WEBSOCKET) ? (useSSl ? this.secureWebSocketBootstrap : this.webSocketBootstrap) : (useSSl ? this.secureBootstrap : this.plainBootstrap);
        bootstrap.setOption("connectTimeoutMillis", (Object)this.config.getConnectionTimeoutInMs());
        if (!System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win")) {
            bootstrap.setOption("reuseAddress", this.asyncHttpProviderConfig.getProperty("reuseAddress"));
        }
        try {
            InetSocketAddress remoteAddress = request.getInetAddress() != null ? new InetSocketAddress(request.getInetAddress(), AsyncHttpProviderUtils.getPort(uri)) : (!useProxy ? new InetSocketAddress(AsyncHttpProviderUtils.getHost(uri), AsyncHttpProviderUtils.getPort(uri)) : new InetSocketAddress(proxyServer.getHost(), proxyServer.getPort()));
            channelFuture = request.getLocalAddress() != null ? bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)new InetSocketAddress(request.getLocalAddress(), 0)) : bootstrap.connect((SocketAddress)remoteAddress);
        }
        catch (Throwable t) {
            if (acquiredConnection) {
                this.freeConnections.release();
            }
            this.abort(c.future(), t.getCause() == null ? t : t.getCause());
            return c.future();
        }
        boolean bl2 = directInvokation = IN_IO_THREAD.get() == false || !DefaultChannelFuture.isUseDeadLockChecker();
        if (directInvokation && !asyncConnect && request.getFile() == null) {
            int timeOut;
            int n = timeOut = this.config.getConnectionTimeoutInMs() > 0 ? this.config.getConnectionTimeoutInMs() : Integer.MAX_VALUE;
            if (!channelFuture.awaitUninterruptibly((long)timeOut, TimeUnit.MILLISECONDS)) {
                if (acquiredConnection) {
                    this.freeConnections.release();
                }
                channelFuture.cancel();
                this.abort(c.future(), new ConnectException(String.format("Connect operation to %s timeout %s", uri, timeOut)));
            }
            try {
                c.operationComplete(channelFuture);
            }
            catch (Exception e) {
                if (acquiredConnection) {
                    this.freeConnections.release();
                }
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                try {
                    asyncHandler.onThrowable(ioe);
                }
                catch (Throwable t) {
                    log.warn("c.operationComplete()", t);
                }
                throw ioe;
            }
        }
        channelFuture.addListener(c);
        log.debug("\nNon cached request \n{}\n\nusing Channel \n{}\n", (Object)c.future().getNettyRequest(), (Object)channelFuture.getChannel());
        if (!c.future().isCancelled() || !c.future().isDone()) {
            this.openChannels.add((Object)channelFuture.getChannel());
            c.future().attachChannel(channelFuture.getChannel(), false);
        }
        return c.future();
    }

    protected static int requestTimeoutInMs(AsyncHttpClientConfig config, PerRequestConfig perRequestConfig) {
        int prRequestTimeout;
        int result = perRequestConfig != null ? ((prRequestTimeout = perRequestConfig.getRequestTimeoutInMs()) != 0 ? prRequestTimeout : config.getRequestTimeoutInMs()) : config.getRequestTimeoutInMs();
        return result;
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        this.connectionsPool.removeAll(ctx.getChannel());
        this.finishChannel(ctx);
    }

    private void finishChannel(ChannelHandlerContext ctx) {
        ctx.setAttachment((Object)new DiscardEvent());
        if (ctx.getChannel() == null) {
            return;
        }
        log.debug("Closing Channel {} ", (Object)ctx.getChannel());
        try {
            ctx.getChannel().close();
        }
        catch (Throwable t) {
            log.debug("Error closing a connection", t);
        }
        if (ctx.getChannel() != null) {
            this.openChannels.remove((Object)ctx.getChannel());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        IN_IO_THREAD.set(Boolean.TRUE);
        if (ctx.getAttachment() == null) {
            log.debug("ChannelHandlerContext wasn't having any attachment");
        }
        if (ctx.getAttachment() instanceof DiscardEvent) {
            return;
        }
        if (ctx.getAttachment() instanceof AsyncCallable) {
            if (e.getMessage() instanceof HttpChunk) {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                if (!chunk.isLast()) return;
                AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                ac.call();
            } else {
                AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                ac.call();
            }
            ctx.setAttachment((Object)new DiscardEvent());
            return;
        }
        if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
            try {
                ctx.getChannel().close();
                return;
            }
            catch (Throwable t) {
                log.trace("Closing an orphan channel {}", (Object)ctx.getChannel());
            }
            return;
        }
        Protocol p = ctx.getPipeline().get(HttpClientCodec.class) != null ? this.httpProtocol : this.webSocketProtocol;
        p.handle(ctx, e);
    }

    private Realm kerberosChallenge(List<String> proxyAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) throws NTLMEngineException {
        URI uri = request.getURI();
        String host = request.getVirtualHost() == null ? AsyncHttpProviderUtils.getHost(uri) : request.getVirtualHost();
        String server = proxyServer == null ? host : proxyServer.getHost();
        try {
            String challengeHeader = NettyAsyncHttpProvider.getSpnegoEngine().generateToken(server);
            headers.remove("Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm) : new Realm.RealmBuilder();
            return realmBuilder.setUri(uri.getRawPath()).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (Throwable throwable) {
            if (NettyAsyncHttpProvider.isNTLM(proxyAuth)) {
                return this.ntlmChallenge(proxyAuth, request, proxyServer, headers, realm, future);
            }
            this.abort(future, throwable);
            return null;
        }
    }

    private void addType3NTLMAuthorizationHeader(List<String> auth, FluentCaseInsensitiveStringsMap headers, String username, String password, String domain, String workstation) throws NTLMEngineException {
        headers.remove("Authorization");
        if (NettyAsyncHttpProvider.isNTLM(auth)) {
            String serverChallenge = auth.get(0).trim().substring("NTLM ".length());
            String challengeHeader = ntlmEngine.generateType3Msg(username, password, domain, workstation, serverChallenge);
            headers.add("Authorization", "NTLM " + challengeHeader);
        }
    }

    private Realm ntlmChallenge(List<String> wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) throws NTLMEngineException {
        Realm newRealm;
        String password;
        boolean useRealm = proxyServer == null && realm != null;
        String ntlmDomain = useRealm ? realm.getNtlmDomain() : proxyServer.getNtlmDomain();
        String ntlmHost = useRealm ? realm.getNtlmHost() : proxyServer.getHost();
        String principal = useRealm ? realm.getPrincipal() : proxyServer.getPrincipal();
        String string = password = useRealm ? realm.getPassword() : proxyServer.getPassword();
        if (realm != null && !realm.isNtlmMessageType2Received()) {
            String challengeHeader = ntlmEngine.generateType1Msg(ntlmDomain, ntlmHost);
            URI uri = request.getURI();
            headers.add("Authorization", "NTLM " + challengeHeader);
            newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(uri.getRawPath()).setMethodName(request.getMethod()).setNtlmMessageType2Received(true).build();
            future.getAndSetAuth(false);
        } else {
            Realm.AuthScheme authScheme;
            Realm.RealmBuilder realmBuilder;
            this.addType3NTLMAuthorizationHeader(wwwAuth, headers, principal, password, ntlmDomain, ntlmHost);
            if (realm != null) {
                realmBuilder = new Realm.RealmBuilder().clone(realm);
                authScheme = realm.getAuthScheme();
            } else {
                realmBuilder = new Realm.RealmBuilder();
                authScheme = Realm.AuthScheme.NTLM;
            }
            newRealm = realmBuilder.setScheme(authScheme).setUri(request.getURI().getPath()).setMethodName(request.getMethod()).build();
        }
        return newRealm;
    }

    private Realm ntlmProxyChallenge(List<String> wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) throws NTLMEngineException {
        future.getAndSetAuth(false);
        this.addType3NTLMAuthorizationHeader(wwwAuth, headers, proxyServer.getPrincipal(), proxyServer.getPassword(), proxyServer.getNtlmDomain(), proxyServer.getHost());
        Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm) : new Realm.RealmBuilder();
        Realm newRealm = realmBuilder.setUri(request.getURI().getPath()).setMethodName(request.getMethod()).build();
        return newRealm;
    }

    private String getPoolKey(NettyResponseFuture<?> future) throws MalformedURLException {
        URI uri = future.getProxyServer() != null ? future.getProxyServer().getURI() : future.getURI();
        return future.getConnectionPoolKeyStrategy().getKey(uri);
    }

    private void drainChannel(final ChannelHandlerContext ctx, final NettyResponseFuture<?> future) {
        ctx.setAttachment((Object)new AsyncCallable(future){

            public Object call() throws Exception {
                if (future.getKeepAlive() && ctx.getChannel().isReadable() && NettyAsyncHttpProvider.this.connectionsPool.offer(NettyAsyncHttpProvider.this.getPoolKey(future), ctx.getChannel())) {
                    return null;
                }
                NettyAsyncHttpProvider.this.finishChannel(ctx);
                return null;
            }

            public String toString() {
                return String.format("Draining task for channel %s", ctx.getChannel());
            }
        });
    }

    private FilterContext handleIoException(FilterContext fc, NettyResponseFuture<?> future) {
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(future, efe);
            }
        }
        return fc;
    }

    private void replayRequest(NettyResponseFuture<?> future, FilterContext fc, HttpResponse response, ChannelHandlerContext ctx) throws IOException {
        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
        }
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setState(NettyResponseFuture.STATE.NEW);
        future.touch();
        log.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, future);
        this.drainChannel(ctx, future);
        this.nextRequest(newRequest, future);
    }

    private List<String> getAuthorizationToken(List<Map.Entry<String, String>> list, String headerAuth) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> e : list) {
            if (!e.getKey().equalsIgnoreCase(headerAuth)) continue;
            l.add(e.getValue().trim());
        }
        return l;
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future) throws IOException {
        this.nextRequest(request, future, true);
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future, boolean useCache) throws IOException {
        this.execute(request, future, useCache, true, true);
    }

    private void abort(NettyResponseFuture<?> future, Throwable t) {
        Channel channel = future.channel();
        if (channel != null && this.openChannels.contains((Object)channel)) {
            this.closeChannel(channel.getPipeline().getContext(NettyAsyncHttpProvider.class));
            this.openChannels.remove((Object)channel);
        }
        if (!future.isCancelled() && !future.isDone()) {
            log.debug("Aborting Future {}\n", future);
            log.debug(t.getMessage(), t);
        }
        future.abort(t);
    }

    private void upgradeProtocol(ChannelPipeline p, String scheme) throws IOException, GeneralSecurityException {
        if (p.get(HTTP_HANDLER) != null) {
            p.remove(HTTP_HANDLER);
        }
        if (NettyAsyncHttpProvider.isSecure(scheme)) {
            if (p.get(SSL_HANDLER) == null) {
                p.addFirst(HTTP_HANDLER, (ChannelHandler)this.createHttpClientCodec());
                p.addFirst(SSL_HANDLER, (ChannelHandler)new SslHandler(this.createSSLEngine()));
            } else {
                p.addAfter(SSL_HANDLER, HTTP_HANDLER, (ChannelHandler)this.createHttpClientCodec());
            }
        } else {
            p.addFirst(HTTP_HANDLER, (ChannelHandler)this.createHttpClientCodec());
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.isClose.get()) {
            return;
        }
        this.connectionsPool.removeAll(ctx.getChannel());
        try {
            super.channelClosed(ctx, e);
        }
        catch (Exception ex) {
            log.trace("super.channelClosed", (Throwable)ex);
        }
        log.debug("Channel Closed: {} with attachment {}", (Object)e.getChannel(), ctx.getAttachment());
        if (ctx.getAttachment() instanceof AsyncCallable) {
            AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
            ctx.setAttachment(ac.future());
            ac.call();
            return;
        }
        if (ctx.getAttachment() instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
            future.touch();
            if (!this.config.getIOExceptionFilters().isEmpty()) {
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                if ((fc = this.handleIoException(fc, future)).replayRequest() && !future.cannotBeReplay()) {
                    this.replayRequest(future, fc, null, ctx);
                    return;
                }
            }
            Protocol p = ctx.getPipeline().get(HttpClientCodec.class) != null ? this.httpProtocol : this.webSocketProtocol;
            p.onClose(ctx, e);
            if (future != null && !future.isDone() && !future.isCancelled()) {
                if (this.remotelyClosed(ctx.getChannel(), future)) {
                    this.abort(future, REMOTELY_CLOSED_EXCEPTION);
                }
            } else {
                this.closeChannel(ctx);
            }
        }
    }

    protected boolean remotelyClosed(Channel channel, NettyResponseFuture<?> future) {
        Object attachment;
        if (this.isClose.get()) {
            return true;
        }
        this.connectionsPool.removeAll(channel);
        if (future == null && (attachment = channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment()) instanceof NettyResponseFuture) {
            future = (NettyResponseFuture)attachment;
        }
        if (future == null || future.cannotBeReplay()) {
            log.debug("Unable to recover future {}\n", future);
            return true;
        }
        future.setState(NettyResponseFuture.STATE.RECONNECTED);
        log.debug("Trying to recover request {}\n", (Object)future.getNettyRequest());
        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
        }
        try {
            this.nextRequest(future.getRequest(), future);
            return false;
        }
        catch (IOException iox) {
            future.setState(NettyResponseFuture.STATE.CLOSED);
            future.abort(iox);
            log.error("Remotely Closed, unable to recover", (Throwable)iox);
            return true;
        }
    }

    private void markAsDone(NettyResponseFuture<?> future, ChannelHandlerContext ctx) throws MalformedURLException {
        try {
            future.done();
        }
        catch (Throwable t) {
            log.debug(t.getMessage(), t);
        }
        if (!future.getKeepAlive() || !ctx.getChannel().isReadable()) {
            this.closeChannel(ctx);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, ChannelHandlerContext ctx, boolean lastValidChunk) throws IOException {
        if (lastValidChunk && future.getKeepAlive()) {
            this.drainChannel(ctx, future);
        } else {
            if (future.getKeepAlive() && ctx.getChannel().isReadable() && this.connectionsPool.offer(this.getPoolKey(future), ctx.getChannel())) {
                this.markAsDone(future, ctx);
                return;
            }
            this.finishChannel(ctx);
        }
        this.markAsDone(future, ctx);
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(NettyResponseFuture<?> future, AsyncHandler handler, HttpResponseBodyPart c) throws Exception {
        boolean state;
        boolean bl = state = handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
        if (c.closeUnderlyingConnection()) {
            future.setKeepAlive(false);
        }
        return state;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NettyResponseFuture<?> future;
        Throwable cause;
        block17: {
            Channel channel = e.getChannel();
            cause = e.getCause();
            future = null;
            if (e.getCause() instanceof PrematureChannelClosureException) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
            }
            try {
                if (cause instanceof ClosedChannelException) {
                    return;
                }
                if (ctx.getAttachment() instanceof NettyResponseFuture) {
                    future = (NettyResponseFuture<?>)ctx.getAttachment();
                    future.attachChannel(null, false);
                    future.touch();
                    if (cause instanceof IOException) {
                        if (!this.config.getIOExceptionFilters().isEmpty()) {
                            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                            if ((fc = this.handleIoException(fc, future)).replayRequest()) {
                                this.replayRequest(future, fc, null, ctx);
                                return;
                            }
                        } else {
                            try {
                                ctx.getChannel().close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    if (NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                        log.debug("Trying to recover from dead Channel: {}", (Object)channel);
                        return;
                    }
                    break block17;
                }
                if (ctx.getAttachment() instanceof AsyncCallable) {
                    future = ((AsyncCallable)ctx.getAttachment()).future();
                }
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        if (future != null) {
            try {
                log.debug("Was unable to recover Future: {}", (Object)future);
                this.abort(future, cause);
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        }
        Protocol p = ctx.getPipeline().get(HttpClientCodec.class) != null ? this.httpProtocol : this.webSocketProtocol;
        p.onError(ctx, e);
        this.closeChannel(ctx);
        ctx.sendUpstream((ChannelEvent)e);
    }

    protected static boolean abortOnConnectCloseException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("sun.nio.ch.SocketChannelImpl") || !element.getMethodName().equals("checkConnect")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnDisconnectException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("org.jboss.netty.handler.ssl.SslHandler") || !element.getMethodName().equals("channelDisconnected")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnReadCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("read")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    protected static boolean abortOnWriteCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("write")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    public static <T> NettyResponseFuture<T> newFuture(URI uri, Request request, AsyncHandler<T> asyncHandler, HttpRequest nettyRequest, AsyncHttpClientConfig config, NettyAsyncHttpProvider provider, ProxyServer proxyServer) {
        NettyResponseFuture<T> f = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, NettyAsyncHttpProvider.requestTimeoutInMs(config, request.getPerRequestConfig()), config.getIdleConnectionTimeoutInMs(), provider, request.getConnectionPoolKeyStrategy(), proxyServer);
        String expectHeader = request.getHeaders().getFirstValue("Expect");
        if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
            f.getAndSetWriteBody(false);
        }
        return f;
    }

    protected AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    private static final boolean validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        return request.getMethod() == "GET" && asyncHandler instanceof WebSocketUpgradeHandler;
    }

    private boolean redirect(Request request, NettyResponseFuture<?> future, HttpResponse response, final ChannelHandlerContext ctx) throws Exception {
        boolean redirectEnabled;
        int statusCode = response.getStatus().getCode();
        boolean bl = redirectEnabled = request.isRedirectOverrideSet() ? request.isRedirectEnabled() : this.config.isRedirectEnabled();
        if (redirectEnabled && (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307)) {
            if (future.incrementAndGetCurrentRedirectCount() < this.config.getMaxRedirects()) {
                future.getAndSetAuth(false);
                String location = response.getHeader("Location");
                URI uri = AsyncHttpProviderUtils.getRedirectUri(future.getURI(), location);
                boolean stripQueryString = this.config.isRemoveQueryParamOnRedirect();
                if (!uri.toString().equals(future.getURI().toString())) {
                    RequestBuilder nBuilder;
                    RequestBuilder requestBuilder = nBuilder = stripQueryString ? new RequestBuilder(future.getRequest()).setQueryParameters(null) : new RequestBuilder(future.getRequest());
                    if (!(statusCode < 302 || statusCode > 303 || statusCode == 302 && this.config.isStrict302Handling())) {
                        nBuilder.setMethod("GET");
                    }
                    final boolean initialConnectionKeepAlive = future.getKeepAlive();
                    final String initialPoolKey = this.getPoolKey(future);
                    future.setURI(uri);
                    String newUrl = uri.toString();
                    if (request.getUrl().startsWith(WEBSOCKET)) {
                        newUrl = newUrl.replace(HTTP, WEBSOCKET);
                    }
                    log.debug("Redirecting to {}", (Object)newUrl);
                    for (String cookieStr : future.getHttpResponse().getHeaders("Set-Cookie")) {
                        for (Cookie c : CookieDecoder.decode(cookieStr)) {
                            nBuilder.addOrReplaceCookie(c);
                        }
                    }
                    for (String cookieStr : future.getHttpResponse().getHeaders("Set-Cookie2")) {
                        for (Cookie c : CookieDecoder.decode(cookieStr)) {
                            nBuilder.addOrReplaceCookie(c);
                        }
                    }
                    AsyncCallable ac = new AsyncCallable(future){

                        public Object call() throws Exception {
                            if (initialConnectionKeepAlive && ctx.getChannel().isReadable() && NettyAsyncHttpProvider.this.connectionsPool.offer(initialPoolKey, ctx.getChannel())) {
                                return null;
                            }
                            NettyAsyncHttpProvider.this.finishChannel(ctx);
                            return null;
                        }
                    };
                    if (response.isChunked()) {
                        ctx.setAttachment((Object)ac);
                    } else {
                        ac.call();
                    }
                    this.nextRequest(nBuilder.setUrl(newUrl).build(), future);
                    return true;
                }
            } else {
                throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
            }
        }
        return false;
    }

    private static boolean isWebSocket(URI uri) {
        return WEBSOCKET.equalsIgnoreCase(uri.getScheme()) || WEBSOCKET_SSL.equalsIgnoreCase(uri.getScheme());
    }

    private static boolean isSecure(String scheme) {
        return HTTPS.equalsIgnoreCase(scheme) || WEBSOCKET_SSL.equalsIgnoreCase(scheme);
    }

    private static boolean isSecure(URI uri) {
        return NettyAsyncHttpProvider.isSecure(uri.getScheme());
    }

    static {
        REMOTELY_CLOSED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
        log = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
        UTF8 = Charset.forName("UTF-8");
        IN_IO_THREAD = new ThreadLocalBoolean();
        ntlmEngine = new NTLMEngine();
        spnegoEngine = null;
    }

    private final class WebSocketProtocol
    implements Protocol {
        private static final byte OPCODE_CONT = 0;
        private static final byte OPCODE_TEXT = 1;
        private static final byte OPCODE_BINARY = 2;
        private static final byte OPCODE_UNKNOWN = -1;
        protected byte pendingOpcode = (byte)-1;

        private WebSocketProtocol() {
        }

        private void invokeOnSucces(ChannelHandlerContext ctx, WebSocketUpgradeHandler h) {
            if (!h.touchSuccess()) {
                try {
                    h.onSuccess(new NettyWebSocket(ctx.getChannel()));
                }
                catch (Exception ex) {
                    WebSocketProtocol webSocketProtocol = this;
                    log.warn("onSuccess unexexpected exception", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            NettyResponseFuture future = (NettyResponseFuture)NettyResponseFuture.class.cast(ctx.getAttachment());
            WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(future.getAsyncHandler());
            Request request = future.getRequest();
            if (e.getMessage() instanceof HttpResponse) {
                boolean headerOK;
                HttpResponse response = (HttpResponse)e.getMessage();
                ResponseStatus s = new ResponseStatus(future.getURI(), response, NettyAsyncHttpProvider.this);
                ResponseHeaders responseHeaders = new ResponseHeaders(future.getURI(), response, NettyAsyncHttpProvider.this);
                FilterContext fc = new FilterContext.FilterContextBuilder<WebSocket>().asyncHandler(h).request(request).responseStatus(s).responseHeaders(responseHeaders).build();
                for (ResponseFilter asyncFilter : NettyAsyncHttpProvider.this.config.getResponseFilters()) {
                    try {
                        if ((fc = asyncFilter.filter(fc)) != null) continue;
                        throw new NullPointerException("FilterContext is null");
                    }
                    catch (FilterException efe) {
                        NettyAsyncHttpProvider.this.abort(future, efe);
                    }
                }
                future.setAsyncHandler(fc.getAsyncHandler());
                if (fc.replayRequest()) {
                    NettyAsyncHttpProvider.this.replayRequest(future, fc, response, ctx);
                    return;
                }
                future.setHttpResponse(response);
                if (NettyAsyncHttpProvider.this.redirect(request, future, response, ctx)) {
                    return;
                }
                org.jboss.netty.handler.codec.http.HttpResponseStatus status = new org.jboss.netty.handler.codec.http.HttpResponseStatus(101, "Web Socket Protocol Handshake");
                boolean validStatus = response.getStatus().equals((Object)status);
                boolean validUpgrade = response.getHeader("Upgrade") != null;
                String c = response.getHeader("Connection");
                if (c == null) {
                    c = response.getHeader("connection");
                }
                boolean validConnection = c == null ? false : c.equalsIgnoreCase("Upgrade");
                s = new ResponseStatus(future.getURI(), response, NettyAsyncHttpProvider.this);
                boolean statusReceived = h.onStatusReceived(s) == AsyncHandler.STATE.UPGRADE;
                boolean bl = headerOK = h.onHeadersReceived(responseHeaders) == AsyncHandler.STATE.CONTINUE;
                if (!(headerOK && validStatus && validUpgrade && validConnection && statusReceived)) {
                    NettyAsyncHttpProvider.this.abort(future, new IOException("Invalid handshake response"));
                    return;
                }
                String accept = response.getHeader("Sec-WebSocket-Accept");
                String key = WebSocketUtil.getAcceptKey(future.getNettyRequest().getHeader("Sec-WebSocket-Key"));
                if (accept == null || !accept.equals(key)) {
                    throw new IOException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, key));
                }
                ctx.getPipeline().replace("http-encoder", "ws-encoder", (ChannelHandler)new WebSocket08FrameEncoder(true));
                ((HttpResponseDecoder)ctx.getPipeline().get(HttpResponseDecoder.class)).replace("ws-decoder", (ChannelHandler)new WebSocket08FrameDecoder(false, false));
                this.invokeOnSucces(ctx, h);
                future.done();
            } else if (e.getMessage() instanceof WebSocketFrame) {
                this.invokeOnSucces(ctx, h);
                WebSocketFrame frame = (WebSocketFrame)e.getMessage();
                if (frame instanceof TextWebSocketFrame) {
                    this.pendingOpcode = 1;
                } else if (frame instanceof BinaryWebSocketFrame) {
                    this.pendingOpcode = (byte)2;
                }
                HttpChunk webSocketChunk = new HttpChunk(){
                    private ChannelBuffer content;

                    public boolean isLast() {
                        return false;
                    }

                    public ChannelBuffer getContent() {
                        return this.content;
                    }

                    public void setContent(ChannelBuffer content) {
                        this.content = content;
                    }
                };
                if (frame.getBinaryData() != null) {
                    webSocketChunk.setContent(ChannelBuffers.wrappedBuffer((ChannelBuffer)frame.getBinaryData()));
                    ResponseBodyPart rp = new ResponseBodyPart(future.getURI(), null, NettyAsyncHttpProvider.this, webSocketChunk, true);
                    h.onBodyPartReceived(rp);
                    NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
                    if (webSocket != null) {
                        if (this.pendingOpcode == 2) {
                            webSocket.onBinaryFragment(rp.getBodyPartBytes(), frame.isFinalFragment());
                        } else {
                            webSocket.onTextFragment(frame.getBinaryData().toString(UTF8), frame.isFinalFragment());
                        }
                        if (frame instanceof CloseWebSocketFrame) {
                            try {
                                ctx.setAttachment(DiscardEvent.class);
                                webSocket.onClose(((CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame)).getStatusCode(), ((CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame)).getReasonText());
                            }
                            catch (Throwable t) {
                                log.trace("", t);
                            }
                            finally {
                                h.resetSuccess();
                            }
                        }
                    } else {
                        log.debug("UpgradeHandler returned a null NettyWebSocket ");
                    }
                }
            } else {
                log.error("Invalid attachment {}", ctx.getAttachment());
            }
        }

        public void onError(ChannelHandlerContext ctx, ExceptionEvent e) {
            try {
                log.warn("onError {}", (Object)e);
                if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
                    return;
                }
                NettyResponseFuture nettyResponse = (NettyResponseFuture)NettyResponseFuture.class.cast(ctx.getAttachment());
                WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
                NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
                if (webSocket != null) {
                    webSocket.onError(e.getCause());
                    webSocket.close();
                }
            }
            catch (Throwable t) {
                log.error("onError", t);
            }
        }

        public void onClose(ChannelHandlerContext ctx, ChannelStateEvent e) {
            log.trace("onClose {}", (Object)e);
            if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
                return;
            }
            try {
                NettyResponseFuture nettyResponse = (NettyResponseFuture)NettyResponseFuture.class.cast(ctx.getAttachment());
                WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(nettyResponse.getAsyncHandler());
                NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
                h.resetSuccess();
                if (!(ctx.getAttachment() instanceof DiscardEvent)) {
                    webSocket.close(1006, "Connection was closed abnormally (that is, with no close frame being sent).");
                }
            }
            catch (Throwable t) {
                log.error("onError", t);
            }
        }
    }

    private final class HttpProtocol
    implements Protocol {
        private HttpProtocol() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            block42: {
                final NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
                future.touch();
                if (future.isCancelled() || future.isDone()) {
                    NettyAsyncHttpProvider.this.finishChannel(ctx);
                    return;
                }
                HttpRequest nettyRequest = future.getNettyRequest();
                AsyncHandler<Object> handler = future.getAsyncHandler();
                Request request = future.getRequest();
                ProxyServer proxyServer = future.getProxyServer();
                HttpResponse response = null;
                try {
                    if (e.getMessage() instanceof HttpResponse) {
                        response = (HttpResponse)e.getMessage();
                        log.debug("\n\nRequest {}\n\nResponse {}\n", (Object)nettyRequest, (Object)response);
                        future.setHttpResponse(response);
                        int statusCode = response.getStatus().getCode();
                        String ka = response.getHeader("Connection");
                        future.setKeepAlive(ka == null || ka.equalsIgnoreCase("keep-alive"));
                        List wwwAuth = NettyAsyncHttpProvider.this.getAuthorizationToken(response.getHeaders(), "WWW-Authenticate");
                        Realm realm = request.getRealm() != null ? request.getRealm() : NettyAsyncHttpProvider.this.config.getRealm();
                        ResponseStatus status = new ResponseStatus(future.getURI(), response, NettyAsyncHttpProvider.this);
                        ResponseHeaders responseHeaders = new ResponseHeaders(future.getURI(), response, NettyAsyncHttpProvider.this);
                        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(request).responseStatus(status).responseHeaders(responseHeaders).build();
                        for (ResponseFilter asyncFilter : NettyAsyncHttpProvider.this.config.getResponseFilters()) {
                            try {
                                if ((fc = asyncFilter.filter(fc)) != null) continue;
                                throw new NullPointerException("FilterContext is null");
                            }
                            catch (FilterException efe) {
                                NettyAsyncHttpProvider.this.abort(future, efe);
                            }
                        }
                        handler = fc.getAsyncHandler();
                        future.setAsyncHandler(handler);
                        if (fc.replayRequest()) {
                            NettyAsyncHttpProvider.this.replayRequest(future, fc, response, ctx);
                            return;
                        }
                        Realm newRealm = null;
                        final FluentCaseInsensitiveStringsMap headers = request.getHeaders();
                        final RequestBuilder builder = new RequestBuilder(future.getRequest());
                        if (statusCode == 401 && realm != null && !wwwAuth.isEmpty() && !future.getAndSetAuth(true)) {
                            future.setState(NettyResponseFuture.STATE.NEW);
                            if (!wwwAuth.contains("Kerberos") && (NettyAsyncHttpProvider.isNTLM(wwwAuth) || wwwAuth.contains("Negotiate"))) {
                                newRealm = NettyAsyncHttpProvider.this.ntlmChallenge(wwwAuth, request, proxyServer, headers, realm, future);
                            } else if (wwwAuth.contains("Negotiate")) {
                                newRealm = NettyAsyncHttpProvider.this.kerberosChallenge(wwwAuth, request, proxyServer, headers, realm, future);
                                if (newRealm == null) {
                                    return;
                                }
                            } else {
                                Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()) : new Realm.RealmBuilder();
                                newRealm = realmBuilder.setUri(request.getURI().getPath()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader((String)wwwAuth.get(0)).build();
                            }
                            final Realm nr = new Realm.RealmBuilder().clone(newRealm).setUri(request.getUrl()).build();
                            log.debug("Sending authentication to {}", (Object)request.getUrl());
                            AsyncCallable ac = new AsyncCallable(future){

                                public Object call() throws Exception {
                                    NettyAsyncHttpProvider.this.drainChannel(ctx, future);
                                    NettyAsyncHttpProvider.this.nextRequest(((RequestBuilder)builder.setHeaders(headers).setRealm(nr)).build(), future);
                                    return null;
                                }
                            };
                            if (future.getKeepAlive()) {
                                future.setReuseChannel(true);
                            }
                            if (future.getKeepAlive() && response.isChunked()) {
                                ctx.setAttachment((Object)ac);
                            } else {
                                ac.call();
                            }
                            return;
                        }
                        if (statusCode == 100) {
                            future.getAndSetWriteHeaders(false);
                            future.getAndSetWriteBody(true);
                            NettyAsyncHttpProvider.this.writeRequest(ctx.getChannel(), NettyAsyncHttpProvider.this.config, future);
                            return;
                        }
                        List proxyAuth = NettyAsyncHttpProvider.this.getAuthorizationToken(response.getHeaders(), "Proxy-Authenticate");
                        if (statusCode == 407 && realm != null && !proxyAuth.isEmpty() && !future.getAndSetAuth(true)) {
                            log.debug("Sending proxy authentication to {}", (Object)request.getUrl());
                            future.setState(NettyResponseFuture.STATE.NEW);
                            if (!proxyAuth.contains("Kerberos") && (NettyAsyncHttpProvider.isNTLM(proxyAuth) || proxyAuth.contains("Negotiate"))) {
                                newRealm = NettyAsyncHttpProvider.this.ntlmProxyChallenge(proxyAuth, request, proxyServer, headers, realm, future);
                            } else if (proxyAuth.contains("Negotiate")) {
                                newRealm = NettyAsyncHttpProvider.this.kerberosChallenge(proxyAuth, request, proxyServer, headers, realm, future);
                                if (newRealm == null) {
                                    return;
                                }
                            } else {
                                newRealm = future.getRequest().getRealm();
                            }
                            Request req = ((RequestBuilder)builder.setHeaders(headers).setRealm(newRealm)).build();
                            future.setReuseChannel(true);
                            future.setConnectAllowed(true);
                            NettyAsyncHttpProvider.this.nextRequest(req, future);
                            return;
                        }
                        if (future.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT) && statusCode == 200) {
                            log.debug("Connected to {}:{}", (Object)proxyServer.getHost(), (Object)proxyServer.getPort());
                            if (future.getKeepAlive()) {
                                future.attachChannel(ctx.getChannel(), true);
                            }
                            try {
                                log.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)request.getUrl());
                                NettyAsyncHttpProvider.this.upgradeProtocol(ctx.getChannel().getPipeline(), request.getURI().getScheme());
                            }
                            catch (Throwable ex) {
                                NettyAsyncHttpProvider.this.abort(future, ex);
                            }
                            Request req = builder.build();
                            future.setReuseChannel(true);
                            future.setConnectAllowed(false);
                            NettyAsyncHttpProvider.this.nextRequest(req, future);
                            return;
                        }
                        if (NettyAsyncHttpProvider.this.redirect(request, future, response, ctx)) {
                            return;
                        }
                        if (!future.getAndSetStatusReceived(true) && NettyAsyncHttpProvider.this.updateStatusAndInterrupt(handler, status)) {
                            NettyAsyncHttpProvider.this.finishUpdate(future, ctx, response.isChunked());
                            return;
                        }
                        if (!response.getHeaders().isEmpty() && NettyAsyncHttpProvider.this.updateHeadersAndInterrupt(handler, responseHeaders)) {
                            NettyAsyncHttpProvider.this.finishUpdate(future, ctx, response.isChunked());
                            return;
                        }
                        if (!response.isChunked()) {
                            if (response.getContent().readableBytes() != 0) {
                                NettyAsyncHttpProvider.this.updateBodyAndInterrupt(future, handler, new ResponseBodyPart(future.getURI(), response, NettyAsyncHttpProvider.this, true));
                            }
                            NettyAsyncHttpProvider.this.finishUpdate(future, ctx, false);
                            return;
                        }
                        if (nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
                            NettyAsyncHttpProvider.this.updateBodyAndInterrupt(future, handler, new ResponseBodyPart(future.getURI(), response, NettyAsyncHttpProvider.this, true));
                            NettyAsyncHttpProvider.this.markAsDone(future, ctx);
                            NettyAsyncHttpProvider.this.drainChannel(ctx, future);
                        }
                        break block42;
                    }
                    if (e.getMessage() instanceof HttpChunk) {
                        HttpChunk chunk = (HttpChunk)e.getMessage();
                        if (handler != null && (chunk.isLast() || NettyAsyncHttpProvider.this.updateBodyAndInterrupt(future, handler, new ResponseBodyPart(future.getURI(), null, NettyAsyncHttpProvider.this, chunk, chunk.isLast())))) {
                            if (chunk instanceof DefaultHttpChunkTrailer) {
                                NettyAsyncHttpProvider.this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), future.getHttpResponse(), NettyAsyncHttpProvider.this, (HttpChunkTrailer)chunk));
                            }
                            NettyAsyncHttpProvider.this.finishUpdate(future, ctx, !chunk.isLast());
                        }
                    }
                }
                catch (Exception t) {
                    if (t instanceof IOException && !NettyAsyncHttpProvider.this.config.getIOExceptionFilters().isEmpty()) {
                        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException((IOException)IOException.class.cast(t)).build();
                        if ((fc = NettyAsyncHttpProvider.this.handleIoException(fc, future)).replayRequest()) {
                            NettyAsyncHttpProvider.this.replayRequest(future, fc, response, ctx);
                            return;
                        }
                    }
                    try {
                        NettyAsyncHttpProvider.this.abort(future, t);
                    }
                    finally {
                        NettyAsyncHttpProvider.this.finishUpdate(future, ctx, false);
                        throw t;
                    }
                }
            }
        }

        public void onError(ChannelHandlerContext ctx, ExceptionEvent e) {
        }

        public void onClose(ChannelHandlerContext ctx, ChannelStateEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonConnectionsPool
    implements ConnectionsPool<String, Channel> {
        private NonConnectionsPool() {
        }

        @Override
        public boolean offer(String uri, Channel connection) {
            return false;
        }

        @Override
        public Channel poll(String uri) {
            return null;
        }

        @Override
        public boolean removeAll(Channel connection) {
            return false;
        }

        @Override
        public boolean canCacheConnection() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    private static class NettyTransferAdapter
    extends TransferCompletionHandler.TransferAdapter {
        private final ChannelBuffer content;
        private final FileInputStream file;
        private int byteRead = 0;

        public NettyTransferAdapter(FluentCaseInsensitiveStringsMap headers, ChannelBuffer content, File file) throws IOException {
            super(headers);
            this.content = content;
            this.file = file != null ? new FileInputStream(file) : null;
        }

        public void getBytes(byte[] bytes) {
            if (this.content.writableBytes() != 0) {
                this.content.getBytes(this.byteRead, bytes);
                this.byteRead += bytes.length;
            } else if (this.file != null) {
                try {
                    this.byteRead += this.file.read(bytes);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static class OptimizedFileRegion
    implements FileRegion {
        private final FileChannel file;
        private final RandomAccessFile raf;
        private final long position;
        private final long count;
        private long byteWritten;

        public OptimizedFileRegion(RandomAccessFile raf, long position, long count) {
            this.raf = raf;
            this.file = raf.getChannel();
            this.position = position;
            this.count = count;
        }

        public long getPosition() {
            return this.position;
        }

        public long getCount() {
            return this.count;
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            long count = this.count - position;
            if (count < 0L || position < 0L) {
                throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
            }
            if (count == 0L) {
                return 0L;
            }
            long bw = this.file.transferTo(this.position + position, count, target);
            this.byteWritten += bw;
            if (this.byteWritten == this.raf.length()) {
                this.releaseExternalResources();
            }
            return bw;
        }

        public void releaseExternalResources() {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", (Throwable)e);
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        private final boolean defaultValue;

        public ThreadLocalBoolean() {
            this(false);
        }

        public ThreadLocalBoolean(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected Boolean initialValue() {
            return this.defaultValue ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AsyncCallable
    implements Callable<Object> {
        private final NettyResponseFuture<?> future;

        public AsyncCallable(NettyResponseFuture<?> future) {
            this.future = future;
        }

        @Override
        public abstract Object call() throws Exception;

        public NettyResponseFuture<?> future() {
            return this.future;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReaperFuture
    implements Future,
    Runnable {
        private Future scheduledFuture;
        private NettyResponseFuture<?> nettyResponseFuture;

        public ReaperFuture(NettyResponseFuture<?> nettyResponseFuture) {
            this.nettyResponseFuture = nettyResponseFuture;
        }

        public void setScheduledFuture(Future scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.nettyResponseFuture = null;
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.scheduledFuture.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.scheduledFuture.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        private void expire(String message) {
            log.debug("{} for {}", (Object)message, this.nettyResponseFuture);
            NettyAsyncHttpProvider.this.abort(this.nettyResponseFuture, new TimeoutException(message));
            this.nettyResponseFuture = null;
        }

        @Override
        public synchronized void run() {
            if (NettyAsyncHttpProvider.this.isClose.get()) {
                this.cancel(true);
                return;
            }
            boolean futureDone = this.nettyResponseFuture.isDone();
            boolean futureCanceled = this.nettyResponseFuture.isCancelled();
            if (this.nettyResponseFuture != null && !futureDone && !futureCanceled) {
                long now = DateUtil.millisTime();
                if (this.nettyResponseFuture.hasRequestTimedOut(now)) {
                    long age = now - this.nettyResponseFuture.getStart();
                    this.expire("Request reached time out of " + this.nettyResponseFuture.getRequestTimeoutInMs() + " ms after " + age + " ms");
                } else if (this.nettyResponseFuture.hasConnectionIdleTimedOut(now)) {
                    long age = now - this.nettyResponseFuture.getStart();
                    this.expire("Request reached idle time out of " + this.nettyResponseFuture.getIdleConnectionTimeoutInMs() + " ms after " + age + " ms");
                }
            } else if (this.nettyResponseFuture == null || futureDone || futureCanceled) {
                this.cancel(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProgressListener
    implements ChannelFutureProgressListener {
        private final boolean notifyHeaders;
        private final AsyncHandler asyncHandler;
        private final NettyResponseFuture<?> future;

        public ProgressListener(boolean notifyHeaders, AsyncHandler asyncHandler, NettyResponseFuture<?> future) {
            this.notifyHeaders = notifyHeaders;
            this.asyncHandler = asyncHandler;
            this.future = future;
        }

        public void operationComplete(ChannelFuture cf) {
            boolean startPublishing;
            Throwable cause = cf.getCause();
            if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
                if (cause instanceof IllegalStateException) {
                    log.debug(cause.getMessage(), cause);
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), (Throwable)ex);
                    }
                    return;
                }
                if (cause instanceof ClosedChannelException || NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                    if (log.isDebugEnabled()) {
                        log.debug(cf.getCause() == null ? "" : cf.getCause().getMessage(), cf.getCause());
                    }
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), (Throwable)ex);
                    }
                    return;
                }
                this.future.abort(cause);
                return;
            }
            this.future.touch();
            Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : NettyAsyncHttpProvider.this.getConfig().getRealm();
            boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
            if (startPublishing && this.asyncHandler instanceof ProgressAsyncHandler) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
            }
        }

        public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
            this.future.touch();
            if (this.asyncHandler instanceof ProgressAsyncHandler) {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
            }
        }
    }

    static final class DiscardEvent {
        DiscardEvent() {
        }
    }
}

