/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.multipart.MultipartEncodingUtil;
import com.ning.http.multipart.Part;
import com.ning.http.multipart.RequestEntity;
import com.ning.http.util.MiscUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartRequestEntity
implements RequestEntity {
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static byte[] MULTIPART_CHARS = MultipartEncodingUtil.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    private final Logger log = LoggerFactory.getLogger(MultipartRequestEntity.class);
    protected Part[] parts;
    private byte[] multipartBoundary;
    private final String contentType;

    public static byte[] generateMultipartBoundary() {
        Random rand = new Random();
        byte[] bytes = new byte[rand.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    public MultipartRequestEntity(Part[] parts, FluentCaseInsensitiveStringsMap requestHeaders) {
        if (parts == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        this.parts = parts;
        String contentTypeHeader = requestHeaders.getFirstValue("Content-Type");
        this.contentType = MiscUtil.isNonEmpty(contentTypeHeader) ? contentTypeHeader : MULTIPART_FORM_CONTENT_TYPE;
    }

    protected byte[] getMultipartBoundary() {
        if (this.multipartBoundary == null) {
            this.multipartBoundary = MultipartRequestEntity.generateMultipartBoundary();
        }
        return this.multipartBoundary;
    }

    public boolean isRepeatable() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isRepeatable()) continue;
            return false;
        }
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        Part.sendParts(out, this.parts, this.getMultipartBoundary());
    }

    public long getContentLength() {
        try {
            return Part.getLengthOfParts(this.parts, this.getMultipartBoundary());
        }
        catch (Exception e) {
            this.log.error("An exception occurred while getting the length of the parts", (Throwable)e);
            return 0L;
        }
    }

    public String getContentType() {
        if (this.contentType.contains("boundary=")) {
            return this.contentType;
        }
        StringBuffer buffer = new StringBuffer(this.contentType);
        if (!this.contentType.endsWith(";")) {
            buffer.append(";");
        }
        buffer.append(" boundary=");
        buffer.append(MultipartEncodingUtil.getAsciiString(this.getMultipartBoundary()));
        return buffer.toString();
    }
}

