/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.websocket;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.UpgradeHandler;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebSocketUpgradeHandler
implements UpgradeHandler<WebSocket>,
AsyncHandler<WebSocket> {
    private WebSocket webSocket;
    private final ConcurrentLinkedQueue<WebSocketListener> l;
    private final String protocol;
    private final long maxByteSize;
    private final long maxTextSize;
    private final AtomicBoolean ok = new AtomicBoolean(false);

    private WebSocketUpgradeHandler(Builder b) {
        this.l = b.l;
        this.protocol = b.protocol;
        this.maxByteSize = b.maxByteSize;
        this.maxTextSize = b.maxTextSize;
    }

    @Override
    public final void onThrowable(Throwable t) {
        this.onFailure(t);
    }

    @Override
    public final AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        if (responseStatus.getStatusCode() == 101) {
            return AsyncHandler.STATE.UPGRADE;
        }
        throw new IllegalStateException("Invalid Upgrade protocol");
    }

    @Override
    public final AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final WebSocket onCompleted() throws Exception {
        if (this.webSocket == null) {
            throw new IllegalStateException("WebSocket is null");
        }
        return this.webSocket;
    }

    @Override
    public final void onSuccess(WebSocket webSocket) {
        this.webSocket = webSocket;
        for (WebSocketListener w : this.l) {
            webSocket.addMessageListener(w);
            w.onOpen(webSocket);
        }
        this.ok.set(true);
    }

    @Override
    public final void onFailure(Throwable t) {
        for (WebSocketListener w : this.l) {
            if (!this.ok.get()) {
                this.webSocket.addMessageListener(w);
            }
            w.onError(t);
        }
    }

    public static final class Builder {
        private ConcurrentLinkedQueue<WebSocketListener> l = new ConcurrentLinkedQueue();
        private String protocol = "";
        private long maxByteSize = 8192L;
        private long maxTextSize = 8192L;

        public Builder addWebSocketListener(WebSocketListener listener) {
            this.l.add(listener);
            return this;
        }

        public Builder removeWebSocketListener(WebSocketListener listener) {
            this.l.remove(listener);
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder setMaxByteSize(long maxByteSize) {
            this.maxByteSize = maxByteSize;
            return this;
        }

        public Builder setMaxTextSize(long maxTextSize) {
            this.maxTextSize = maxTextSize;
            return this;
        }

        public WebSocketUpgradeHandler build() {
            return new WebSocketUpgradeHandler(this);
        }
    }
}

