/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.netty4;

import com.ning.http.client.providers.netty.netty4.BinaryWebSocketFrame;
import com.ning.http.client.providers.netty.netty4.CloseWebSocketFrame;
import com.ning.http.client.providers.netty.netty4.ContinuationWebSocketFrame;
import com.ning.http.client.providers.netty.netty4.PingWebSocketFrame;
import com.ning.http.client.providers.netty.netty4.PongWebSocketFrame;
import com.ning.http.client.providers.netty.netty4.TextWebSocketFrame;
import com.ning.http.client.providers.netty.netty4.WebSocketFrame;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocket08FrameEncoder
extends OneToOneEncoder {
    private static final Logger logger = LoggerFactory.getLogger(WebSocket08FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private boolean maskPayload = false;

    public WebSocket08FrameEncoder(boolean maskPayload) {
        this.maskPayload = maskPayload;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        byte[] mask = null;
        if (msg instanceof WebSocketFrame) {
            ChannelBuffer body;
            ChannelBuffer header;
            int maskLength;
            int opcode;
            WebSocketFrame frame = (WebSocketFrame)msg;
            ChannelBuffer data = frame.getBinaryData();
            if (data == null) {
                data = ChannelBuffers.EMPTY_BUFFER;
            }
            if (frame instanceof TextWebSocketFrame) {
                opcode = 1;
            } else if (frame instanceof PingWebSocketFrame) {
                opcode = 9;
            } else if (frame instanceof PongWebSocketFrame) {
                opcode = 10;
            } else if (frame instanceof CloseWebSocketFrame) {
                opcode = 8;
            } else if (frame instanceof BinaryWebSocketFrame) {
                opcode = 2;
            } else if (frame instanceof ContinuationWebSocketFrame) {
                opcode = 0;
            } else {
                throw new UnsupportedOperationException("Cannot encode frame of type: " + frame.getClass().getName());
            }
            int length = data.readableBytes();
            logger.debug("Encoding WebSocket Frame opCode=" + opcode + " length=" + length);
            int b0 = 0;
            if (frame.isFinalFragment()) {
                b0 |= 0x80;
            }
            b0 |= frame.getRsv() % 8 << 4;
            b0 |= opcode % 128;
            if (opcode == 9 && length > 125) {
                throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + length);
            }
            int n = maskLength = this.maskPayload ? 4 : 0;
            if (length <= 125) {
                header = ChannelBuffers.buffer((int)(2 + maskLength));
                header.writeByte(b0);
                byte b = this.maskPayload ? (byte)(0x80 | (byte)length) : (byte)length;
                header.writeByte((int)b);
            } else if (length <= 65535) {
                header = ChannelBuffers.buffer((int)(4 + maskLength));
                header.writeByte(b0);
                header.writeByte(this.maskPayload ? 254 : 126);
                header.writeByte(length >>> 8 & 0xFF);
                header.writeByte(length & 0xFF);
            } else {
                header = ChannelBuffers.buffer((int)(10 + maskLength));
                header.writeByte(b0);
                header.writeByte(this.maskPayload ? 255 : 127);
                header.writeLong((long)length);
            }
            if (this.maskPayload) {
                Integer random = (int)(Math.random() * 2.147483647E9);
                mask = ByteBuffer.allocate(4).putInt(random).array();
                header.writeBytes(mask);
                body = ChannelBuffers.buffer((int)length);
                int counter = 0;
                while (data.readableBytes() > 0) {
                    byte byteData = data.readByte();
                    body.writeByte(byteData ^ mask[counter++ % 4]);
                }
            } else {
                body = data;
            }
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, body});
        }
        return msg;
    }
}

